/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPLayout;

public class TextPanel
extends JPanel {
    protected static Dimension ZEROSIZE = new Dimension(0, 0);
    protected String text = "";
    protected Font font;
    protected String fontname = "TimesRoman";
    protected int fontsize = 14;
    protected int fontstyle = 0;
    protected Color textColor = Color.black;
    protected Color backgroundColor = Color.yellow;
    protected Dimension dim = ZEROSIZE;

    public TextPanel() {
        this.setBackground(this.backgroundColor);
        this.font = new Font(this.fontname, this.fontstyle, this.fontsize);
    }

    public TextPanel(String text) {
        this();
        this.setText(text);
    }

    public void setText(String _text) {
        Container c;
        if (this.text == (_text = GUIUtils.parseTeX(_text))) {
            return;
        }
        this.text = _text;
        if (this.text == null) {
            this.text = "";
        }
        if ((c = this.getParent()) == null) {
            return;
        }
        if (c.getLayout() instanceof OSPLayout) {
            ((OSPLayout)c.getLayout()).quickLayout(c, this);
            this.repaint();
        } else {
            c.validate();
        }
    }

    public Dimension getPreferredSize() {
        Container c = this.getParent();
        String text = this.text;
        if (c == null || text.equals("")) {
            return ZEROSIZE;
        }
        Graphics2D g2 = (Graphics2D)c.getGraphics();
        if (g2 == null) {
            return ZEROSIZE;
        }
        Font oldFont = g2.getFont();
        g2.setFont(this.font);
        FontMetrics fm = g2.getFontMetrics();
        int boxHeight = fm.getAscent() + 4;
        int boxWidth = fm.stringWidth(text) + 6;
        g2.setFont(oldFont);
        return new Dimension(boxWidth, boxHeight);
    }

    public void paint(Graphics g) {
        String text = this.text;
        if (!this.dim.equals(this.getPreferredSize())) {
            this.dim = this.getPreferredSize();
            this.setSize(this.dim);
        }
        if (text.equals("") || !this.isVisible()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        g2.setColor(this.textColor);
        Font oldFont = g2.getFont();
        g2.setFont(this.font);
        g2.drawString(text, 3, h - 4);
        g2.setFont(oldFont);
        g2.setColor(Color.black);
        g2.drawRect(0, 0, w - 1, h - 1);
    }
}

