/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import org.opensourcephysics.display.DrawableTextLine;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.axes.DrawableAxes;
import org.opensourcephysics.tools.FontSizer;

public abstract class AbstractAxes
implements DrawableAxes {
    protected boolean visible = true;
    protected Font titleFont = new Font("Dialog", 1, 14);
    protected Font labelFont = new Font("SansSerif", 0, 9);
    protected Font superscriptFont = new Font("SansSerif", 0, 9);
    protected DecimalFormat labelFormat = new DecimalFormat("0.0");
    protected Color gridcolor = Color.lightGray;
    protected Color interiorColor = Color.white;
    protected DrawableTextLine titleLine = new DrawableTextLine("", 0.0, 0.0);
    protected DrawingPanel drawingPanel;

    public AbstractAxes(DrawingPanel drawingPanel) {
        this.drawingPanel = drawingPanel;
        this.resizeFonts(FontSizer.getFactor(FontSizer.getLevel()), drawingPanel);
        FontSizer.addPropertyChangeListener("level", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                AbstractAxes.this.resizeFonts(FontSizer.getFactor(FontSizer.getLevel()), AbstractAxes.this.drawingPanel);
            }
        });
    }

    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setInteriorBackground(Color color) {
        this.interiorColor = color;
    }

    public Color getInteriorBackground() {
        return this.interiorColor;
    }

    public void resizeFonts(double factor, DrawingPanel panel) {
        this.labelFont = FontSizer.getResizedFont(this.labelFont, factor);
        this.superscriptFont = FontSizer.getResizedFont(this.superscriptFont, factor);
        this.titleFont = FontSizer.getResizedFont(this.titleFont, factor);
        this.titleLine.setFont(this.titleFont);
    }

    public String getTitle() {
        return this.titleLine.getText();
    }

    public void setTitle(String s, String font_name) {
        this.titleLine.setText(s);
        if (font_name == null || font_name.equals("")) {
            return;
        }
        this.titleLine.setFont(Font.decode(font_name));
    }

    public abstract /* synthetic */ void draw(DrawingPanel var1, Graphics var2);

    public abstract /* synthetic */ String getXLabel();

    public abstract /* synthetic */ String getYLabel();

    public abstract /* synthetic */ void setShowMajorXGrid(boolean var1);

    public abstract /* synthetic */ void setShowMajorYGrid(boolean var1);

    public abstract /* synthetic */ void setShowMinorXGrid(boolean var1);

    public abstract /* synthetic */ void setShowMinorYGrid(boolean var1);

    public abstract /* synthetic */ void setXLabel(String var1, String var2);

    public abstract /* synthetic */ void setYLabel(String var1, String var2);
}

