/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;

public class CartesianCoordinateStringBuilder
extends CoordinateStringBuilder {
    protected DecimalFormat scientificFormat = new DecimalFormat("0.###E0");
    protected DecimalFormat decimalFormat = new DecimalFormat("0.00");
    protected String xLabel = "x=";
    protected String yLabel = "  y=";

    public CartesianCoordinateStringBuilder() {
        this("x=", "  y=");
    }

    public CartesianCoordinateStringBuilder(String xLabel, String yLabel) {
        this.xLabel = xLabel;
        this.yLabel = yLabel;
    }

    public void setCoordinateLabels(String xLabel, String yLabel) {
        this.xLabel = xLabel;
        this.yLabel = yLabel;
    }

    public String getCoordinateString(DrawingPanel panel, MouseEvent e) {
        double x = panel.pixToX(e.getPoint().x);
        double y = panel.pixToY(e.getPoint().y);
        String msg = "";
        if (Math.abs(x) > 100.0 || Math.abs(x) < 0.01 || Math.abs(y) > 100.0 || Math.abs(y) < 0.01) {
            if (this.xLabel != null) {
                msg = this.xLabel + this.scientificFormat.format((float)x);
            }
            if (this.yLabel != null) {
                msg = msg + this.yLabel + this.scientificFormat.format((float)y);
            }
        } else {
            if (this.xLabel != null) {
                msg = this.xLabel + this.decimalFormat.format((float)x);
            }
            if (this.yLabel != null) {
                msg = msg + this.yLabel + this.decimalFormat.format((float)y);
            }
        }
        return msg;
    }
}

