/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AbstractAxes;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.display.axes.DrawableAxes;

public class CustomAxes
extends AbstractAxes
implements DrawableAxes {
    Color gridColor = Color.lightGray;
    ArrayList drawableList = new ArrayList();

    public CustomAxes(PlottingPanel panel) {
        super(panel);
        if (panel == null) {
            return;
        }
        panel.setGutters(25, 25, 25, 25);
        this.titleLine.setJustification(0);
        this.titleLine.setFont(this.titleFont);
        panel.setCoordinateStringBuilder(CoordinateStringBuilder.createCartesian());
        panel.setAxes(this);
    }

    public void setXLabel(String s, String font_name) {
    }

    public void setYLabel(String s, String font_name) {
    }

    public String getXLabel() {
        return "";
    }

    public String getYLabel() {
        return "";
    }

    public String getTitle() {
        return this.titleLine.getText();
    }

    public void setTitle(String s, String font_name) {
        this.titleLine.setText(s);
        if (font_name == null || font_name.equals("")) {
            return;
        }
        this.titleLine.setFont(Font.decode(font_name));
    }

    public void setXLog(boolean isLog) {
    }

    public void setYLog(boolean isLog) {
    }

    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    public void setInteriorBackground(Color color) {
        this.interiorColor = color;
    }

    public void setShowMajorXGrid(boolean showGrid) {
    }

    public void setShowMinorXGrid(boolean showGrid) {
    }

    public void setShowMajorYGrid(boolean showGrid) {
    }

    public void setShowMinorYGrid(boolean showGrid) {
    }

    public synchronized void addDrawable(Drawable drawable) {
        if (drawable != null && !this.drawableList.contains(drawable)) {
            this.drawableList.add(drawable);
        }
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.interiorColor != panel.getBackground()) {
            g.setColor(this.interiorColor);
            int gw = panel.getLeftGutter() + panel.getRightGutter();
            int gh = panel.getTopGutter() + panel.getLeftGutter();
            g.fillRect(panel.getLeftGutter(), panel.getTopGutter(), panel.getWidth() - gw, panel.getHeight() - gh);
            g.setColor(this.gridColor);
            g.drawRect(panel.getLeftGutter(), panel.getTopGutter(), panel.getWidth() - gw, panel.getHeight() - gh);
        }
        Iterator it = ((AbstractList)this.drawableList).iterator();
        while (it.hasNext()) {
            Drawable drawable = (Drawable)it.next();
            drawable.draw(panel, g);
        }
        this.titleLine.setX((panel.getXMax() + panel.getXMin()) / 2.0);
        if (panel.getTopGutter() > 20) {
            this.titleLine.setY(panel.getYMax() + 5.0 / panel.getYPixPerUnit());
        } else {
            this.titleLine.setY(panel.getYMax() - 25.0 / panel.getYPixPerUnit());
        }
        this.titleLine.draw(panel, g);
    }
}

