/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AbstractPolarAxis;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.display.axes.PolarAxes;

public class PolarType2
extends AbstractPolarAxis
implements PolarAxes {
    public PolarType2(PlottingPanel panel, String rLabel, String phiLabel, double phiOffset) {
        super(panel);
        if (panel == null) {
            return;
        }
        panel.setGutters(25, 25, 25, 25);
        this.titleLine.setJustification(0);
        this.titleLine.setFont(this.titleFont);
        panel.setAxes(this);
        panel.setCoordinateStringBuilder(CoordinateStringBuilder.createPolar(rLabel, phiLabel, phiOffset));
    }

    public PolarType2(PlottingPanel panel) {
        this(panel, "r=", " phi=", 0.0);
    }

    public void setXLabel(String s, String font_name) {
    }

    public void setYLabel(String s, String font_name) {
    }

    public String getXLabel() {
        return "";
    }

    public String getYLabel() {
        return "";
    }

    public void setXLog(boolean isLog) {
    }

    public void setYLog(boolean isLog) {
    }

    public void setShowMajorXGrid(boolean showGrid) {
    }

    public void setShowMinorXGrid(boolean showGrid) {
    }

    public void setShowMajorYGrid(boolean showGrid) {
    }

    public void setShowMinorYGrid(boolean showGrid) {
    }

    public void draw(DrawingPanel panel, Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Shape clipShape = g2.getClip();
        int gw = panel.getLeftGutter() + panel.getRightGutter();
        int gh = panel.getTopGutter() + panel.getLeftGutter();
        if (this.interiorColor != null) {
            g.setColor(this.interiorColor);
            g.fillRect(panel.getLeftGutter(), panel.getTopGutter(), panel.getWidth() - gw, panel.getHeight() - gh);
            g.setColor(this.gridcolor);
            g.drawRect(panel.getLeftGutter(), panel.getTopGutter(), panel.getWidth() - gw, panel.getHeight() - gh);
        }
        g2.clipRect(panel.getLeftGutter(), panel.getTopGutter(), panel.getWidth() - gw, panel.getHeight() - gh);
        double rmax = Math.abs(panel.getXMax()) + Math.abs(panel.getYMax());
        rmax = Math.max(rmax, Math.abs(panel.getXMax()) + Math.abs(panel.getYMin()));
        rmax = Math.max(rmax, Math.abs(panel.getXMin()) + Math.abs(panel.getYMax()));
        rmax = Math.max(rmax, Math.abs(panel.getXMin()) + Math.abs(panel.getYMin()));
        double dr = this.drawRings(rmax, panel, g);
        this.drawSpokes(rmax, panel, g);
        g2.setClip(clipShape);
        this.drawRAxis(dr, rmax, panel, g);
        this.titleLine.setX((panel.getXMax() + panel.getXMin()) / 2.0);
        if (panel.getTopGutter() > 20) {
            this.titleLine.setY(panel.getYMax() + 5.0 / panel.getYPixPerUnit());
        } else {
            this.titleLine.setY(panel.getYMax() - 25.0 / panel.getYPixPerUnit());
        }
        this.titleLine.draw(panel, g);
    }
}

