/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.dialogs.DialogsRes;

public class AutoScaleInspector
extends JDialog {
    protected DrawingPanel plotPanel;
    protected JPanel dataPanel;
    protected JCheckBox xAutoscaleCheckBox;
    protected JCheckBox yAutoscaleCheckBox;
    protected JButton okButton;

    public AutoScaleInspector(DrawingPanel panel) {
        super((Frame)null, true);
        this.plotPanel = panel;
        this.setTitle(DialogsRes.AUTOSCALE_AUTOSCALE);
        this.setResizable(false);
        this.createGUI();
        this.pack();
    }

    private void createGUI() {
        this.xAutoscaleCheckBox = new JCheckBox(DialogsRes.AUTOSCALE_AUTO + " x");
        this.xAutoscaleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AutoScaleInspector.this.plotPanel.setAutoscaleX(AutoScaleInspector.this.xAutoscaleCheckBox.isSelected());
                AutoScaleInspector.this.plotPanel.scale();
                AutoScaleInspector.this.updateDisplay();
                AutoScaleInspector.this.plotPanel.repaint();
            }
        });
        this.yAutoscaleCheckBox = new JCheckBox(DialogsRes.AUTOSCALE_AUTO + " y");
        this.yAutoscaleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AutoScaleInspector.this.plotPanel.setAutoscaleY(AutoScaleInspector.this.yAutoscaleCheckBox.isSelected());
                AutoScaleInspector.this.plotPanel.scale();
                AutoScaleInspector.this.updateDisplay();
                AutoScaleInspector.this.plotPanel.repaint();
            }
        });
        JPanel inspectorPanel = new JPanel(new BorderLayout());
        this.setContentPane(inspectorPanel);
        JPanel controlPanel = new JPanel(new BorderLayout());
        inspectorPanel.add((Component)controlPanel, "South");
        JPanel xPanel = new JPanel(new GridLayout(1, 2));
        xPanel.setBorder(BorderFactory.createTitledBorder(DialogsRes.AUTOSCALE_ZOOM_WARNING));
        this.dataPanel = new JPanel(new GridLayout(1, 1));
        this.dataPanel.setBorder(BorderFactory.createEtchedBorder());
        controlPanel.add((Component)this.dataPanel, "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        xPanel.add(this.xAutoscaleCheckBox);
        xPanel.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        xPanel.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        xPanel.add(this.yAutoscaleCheckBox);
        this.dataPanel.add(xPanel);
        this.xAutoscaleCheckBox.setAlignmentX(1.0f);
        this.yAutoscaleCheckBox.setAlignmentX(1.0f);
        this.okButton = new JButton(DialogsRes.AUTOSCALE_OK);
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((Component)AutoScaleInspector.this).setVisible(false);
            }
        });
        JPanel buttonbar = new JPanel();
        controlPanel.add((Component)buttonbar, "South");
        buttonbar.add(this.okButton);
    }

    public void updateDisplay() {
        this.xAutoscaleCheckBox.setSelected(this.plotPanel.isAutoscaleX());
        this.yAutoscaleCheckBox.setSelected(this.plotPanel.isAutoscaleY());
    }
}

