/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.dialogs;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;

public class DecimalField
extends JTextField {
    private NumberFormat format = NumberFormat.getInstance();
    private double prevValue;
    private Double maxValue;
    private Double minValue;

    public DecimalField(int columns, int places) {
        super(columns);
        this.setDecimalPlaces(places);
    }

    public double getValue() {
        double retValue;
        try {
            retValue = this.format.parse(this.getText()).doubleValue();
            if (this.minValue != null && retValue < this.minValue) {
                this.setValue(this.minValue);
                return this.minValue;
            }
            if (this.maxValue != null && retValue > this.maxValue) {
                this.setValue(this.maxValue);
                return this.maxValue;
            }
        }
        catch (ParseException e) {
            Toolkit.getDefaultToolkit().beep();
            this.setValue(this.prevValue);
            return this.prevValue;
        }
        return retValue;
    }

    public void setValue(double value) {
        if (this.minValue != null) {
            value = Math.max(value, this.minValue);
        }
        if (this.maxValue != null) {
            value = Math.min(value, this.maxValue);
        }
        this.setText(this.format.format(value));
        this.prevValue = value;
    }

    public void setDecimalPlaces(int places) {
        places = Math.abs(places);
        places = Math.min(places, 5);
        this.format.setMinimumIntegerDigits(1);
        this.format.setMinimumFractionDigits(places);
        this.format.setMaximumFractionDigits(places);
    }

    public void setMinValue(double min) {
        this.minValue = new Double(min);
    }

    public void setMaxValue(double max) {
        this.maxValue = new Double(max);
    }
}

