/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display2d.ByteLattice;
import org.opensourcephysics.display2d.CellLatticeOSX;
import org.opensourcephysics.display2d.CellLatticePC;
import org.opensourcephysics.display2d.SiteLattice;

public class CellLattice
implements ByteLattice {
    ByteLattice lattice = null;
    static String osName;

    public CellLattice() {
        this.lattice = osName.indexOf("Mac") > -1 ? new CellLatticeOSX() : new CellLatticePC();
    }

    public CellLattice(int nx, int ny) {
        this.lattice = osName.indexOf("Mac") > -1 ? new CellLatticeOSX(nx, ny) : new CellLatticePC(nx, ny);
    }

    public double getXMin() {
        return this.lattice.getXMin();
    }

    public double getXMax() {
        return this.lattice.getXMax();
    }

    public double getYMin() {
        return this.lattice.getYMin();
    }

    public double getYMax() {
        return this.lattice.getYMax();
    }

    public boolean isMeasured() {
        return this.lattice.isMeasured();
    }

    public void draw(DrawingPanel panel, Graphics g) {
        this.lattice.draw(panel, g);
    }

    public int getNx() {
        return this.lattice.getNx();
    }

    public int getNy() {
        return this.lattice.getNy();
    }

    public int indexFromPoint(double x, double y) {
        return this.lattice.indexFromPoint(x, y);
    }

    public int xToIndex(double x) {
        return this.lattice.xToIndex(x);
    }

    public int yToIndex(double y) {
        return this.lattice.yToIndex(y);
    }

    public byte getValue(int ix, int iy) {
        return this.lattice.getValue(ix, iy);
    }

    public void setValue(int ix, int iy, byte val) {
        this.lattice.setValue(ix, iy, val);
    }

    public void randomize() {
        this.lattice.randomize();
    }

    public void resizeLattice(int nx, int ny) {
        this.lattice.resizeLattice(nx, ny);
    }

    public void setAll(byte[][] val, double xmin, double xmax, double ymin, double ymax) {
        this.lattice.setAll(val, xmin, xmax, ymin, ymax);
    }

    public void setBlock(int ix_offset, int iy_offset, byte[][] val) {
        this.lattice.setBlock(ix_offset, iy_offset, val);
    }

    public void setBlock(byte[][] val) {
        this.lattice.setBlock(val);
    }

    public void setCol(int ix, int iy_offset, byte[] val) {
        this.lattice.setCol(ix, iy_offset, val);
    }

    public void setRow(int iy, int ix_offset, byte[] val) {
        this.lattice.setRow(iy, ix_offset, val);
    }

    public void setShowGridLines(boolean show) {
        this.lattice.setShowGridLines(show);
    }

    public void setGridLineColor(Color c) {
        this.lattice.setGridLineColor(c);
    }

    public JFrame showLegend() {
        return this.lattice.showLegend();
    }

    public void setVisible(boolean isVisible) {
        this.lattice.setVisible(isVisible);
    }

    public void setColorPalette(Color[] colors) {
        this.lattice.setColorPalette(colors);
    }

    public void setIndexedColor(int i, Color color) {
        this.lattice.setIndexedColor(i, color);
    }

    public void setMinMax(double xmin, double xmax, double ymin, double ymax) {
        this.lattice.setMinMax(xmin, xmax, ymin, ymax);
    }

    public SiteLattice createSiteLattice() {
        if (osName.indexOf("Mac") > -1) {
            return ((CellLatticeOSX)this.lattice).createSiteLattice();
        }
        return ((CellLatticePC)this.lattice).createSiteLattice();
    }

    public void setBlock(int ix_offset, int iy_offset, int[][] val) {
        if (osName.indexOf("Mac") > -1) {
            ((CellLatticeOSX)this.lattice).setBlock(ix_offset, iy_offset, val);
        } else {
            ((CellLatticePC)this.lattice).setBlock(ix_offset, iy_offset, val);
        }
    }

    public void setXMin(double xmin) {
        this.lattice.setXMin(xmin);
    }

    public void setXMax(double xmax) {
        this.lattice.setXMax(xmax);
    }

    public void setYMin(double ymin) {
        this.lattice.setYMin(ymin);
    }

    public void setYMax(double ymax) {
        this.lattice.setYMax(ymax);
    }

    public void createDefaultColors() {
        this.lattice.createDefaultColors();
    }

    static {
        try {
            osName = System.getProperty("os.name", "");
        }
        catch (Exception ex) {
            osName = "";
        }
    }
}

