/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Random;
import javax.swing.JFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display2d.ByteLattice;
import org.opensourcephysics.display2d.CellLattice;
import org.opensourcephysics.display2d.SiteLattice;

public class CellLatticeOSX
extends Grid
implements Measurable,
ByteLattice {
    boolean visible = true;
    Color[] colors = new Color[256];
    byte[][] data;
    private JFrame legendFrame;

    public CellLatticeOSX() {
        this(1, 1);
    }

    public CellLatticeOSX(int nx, int ny) {
        super(nx, ny);
        this.createDefaultColors();
        this.data = new byte[nx][ny];
        this.color = Color.lightGray;
    }

    public SiteLattice createSiteLattice() {
        SiteLattice lattice = new SiteLattice(this.nx, this.ny);
        lattice.setBlock(this.data);
        lattice.setMinMax(this.getXMin(), this.getXMax(), this.getYMin(), this.getYMax());
        lattice.setColorPalette(this.colors);
        return lattice;
    }

    public void resizeLattice(int _nx, int _ny) {
        this.nx = _nx;
        this.ny = _ny;
        this.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
        this.data = new byte[this.nx][this.ny];
    }

    public int getNx() {
        return this.nx;
    }

    public int getNy() {
        return this.ny;
    }

    public int indexFromPoint(double x, double y) {
        int nx = this.getNx();
        int ny = this.getNy();
        double xMin = this.getXMin();
        double xMax = this.getXMax();
        double yMin = this.getYMin();
        double yMax = this.getYMax();
        double deltaX = (x - xMin) / (xMax - xMin);
        double deltaY = (y - yMin) / (yMax - yMin);
        int ix = (int)(deltaX * (double)nx);
        int iy = (int)(deltaY * (double)ny);
        if (ix < 0 || iy < 0 || ix >= nx || iy >= ny) {
            return -1;
        }
        return iy * nx + ix;
    }

    public int xToIndex(double x) {
        double xMax;
        int nx = this.getNx();
        double xMin = this.getXMin();
        double deltaX = (x - xMin) / ((xMax = this.getXMax()) - xMin);
        int ix = (int)(deltaX * (double)nx);
        if (ix < 0) {
            return 0;
        }
        if (ix >= nx) {
            return nx - 1;
        }
        return ix;
    }

    public int yToIndex(double y) {
        double yMax;
        int ny = this.getNy();
        double yMin = this.getYMin();
        double deltaY = (y - yMin) / ((yMax = this.getYMax()) - yMin);
        int iy = (int)(deltaY * (double)ny);
        if (iy < 0) {
            return 0;
        }
        if (iy >= ny) {
            return ny - 1;
        }
        return iy;
    }

    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    private Rectangle getBounds(DrawingPanel panel) {
        int x1 = panel.xToPix(this.xmin);
        int x2 = panel.xToPix(this.xmax);
        int y1 = panel.yToPix(this.ymin);
        int y2 = panel.yToPix(this.ymax);
        return new Rectangle(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1));
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        double ymax = this.ymax;
        double xmin = this.xmin;
        if (panel.getXMax() < panel.getXMin()) {
            double d = xmin = this.dx < 0.0 ? this.xmin - this.dx : this.xmin + this.dx;
        }
        if (panel.getYMax() < panel.getYMin()) {
            ymax = this.dy < 0.0 ? this.ymax + this.dy : this.ymax - this.dy;
        }
        double x = this.dx < 0.0 ? xmin + this.dx : xmin;
        double y = this.dy < 0.0 ? ymax - this.dy : ymax;
        int x1pix = panel.xToPix(x);
        int y1pix = panel.yToPix(y);
        Shape clipShape = g.getClip();
        Rectangle r = this.getBounds(panel);
        g.clipRect(r.x, r.y, r.width, r.height);
        for (int ix = 0; ix < this.nx; ++ix) {
            int x2pix = panel.xToPix(x += this.dx);
            for (int iy = this.ny - 1; iy >= 0; --iy) {
                int y2pix = panel.yToPix(y -= this.dy);
                int val = this.data[ix][iy] & 0xFF;
                g.setColor(this.colors[val]);
                g.fillRect(x1pix, y1pix, Math.abs(x2pix - x1pix) + 1, Math.abs(y1pix - y2pix) + 1);
                y1pix = y2pix;
            }
            x1pix = x2pix;
            y = this.dy < 0.0 ? ymax - this.dy : ymax;
            y1pix = panel.yToPix(y);
        }
        g.setClip(clipShape);
        super.draw(panel, g);
    }

    public void setBlock(int ix_offset, int iy_offset, byte[][] val) {
        if (iy_offset < 0 || iy_offset + val[0].length - 1 > this.ny) {
            throw new IllegalArgumentException("Row offset " + iy_offset + " out of range.");
        }
        if (ix_offset < 0 || ix_offset + val.length - 1 > this.nx) {
            throw new IllegalArgumentException("Column offset " + ix_offset + " out of range.");
        }
        int my = val[0].length + iy_offset;
        for (int iy = iy_offset; iy < my; ++iy) {
            int mx = val.length + ix_offset;
            for (int ix = ix_offset; ix < mx; ++ix) {
                this.data[ix][iy] = val[ix - ix_offset][iy - iy_offset];
            }
        }
    }

    public void setAll(byte[][] val) {
        if (this.getNx() != val.length || this.getNy() != val[0].length) {
            this.resizeLattice(val.length, val[0].length);
        }
        this.setBlock(0, 0, val);
    }

    public void setAll(byte[][] val, double xmin, double xmax, double ymin, double ymax) {
        this.setAll(val);
        this.setMinMax(xmin, xmax, ymin, ymax);
    }

    public void setBlock(int ix_offset, int iy_offset, int[][] val) {
        if (iy_offset < 0 || iy_offset + val[0].length - 1 > this.ny) {
            throw new IllegalArgumentException("Row offset " + iy_offset + " out of range.");
        }
        if (ix_offset < 0 || ix_offset + val.length - 1 > this.nx) {
            throw new IllegalArgumentException("Column offset " + ix_offset + " out of range.");
        }
        int my = val[0].length + iy_offset;
        for (int iy = iy_offset; iy < my; ++iy) {
            int mx = val.length + ix_offset;
            for (int ix = ix_offset; ix < mx; ++ix) {
                this.data[ix][iy] = (byte)val[ix - ix_offset][iy - iy_offset];
            }
        }
    }

    public void setBlock(byte[][] val) {
        this.setBlock(0, 0, val);
    }

    public void setCol(int ix, int iy_offset, byte[] val) {
        if (iy_offset < 0 || iy_offset + val.length > this.ny) {
            throw new IllegalArgumentException("Row offset " + iy_offset + " out of range.");
        }
        if (ix < 0 || ix >= this.nx) {
            throw new IllegalArgumentException("Column index " + ix + " out of range.");
        }
        int my = val.length + iy_offset;
        for (int iy = iy_offset; iy < my; ++iy) {
            this.data[ix][iy] = val[iy - iy_offset];
        }
    }

    public void setRow(int iy, int ix_offset, byte[] val) {
        if (iy < 0 || iy >= this.ny) {
            throw new IllegalArgumentException("Y index out of range in binary lattice setRow.");
        }
        if (ix_offset < 0 || ix_offset + val.length > this.nx) {
            throw new IllegalArgumentException("X offset out of range in binary lattice setRow.");
        }
        int mx = val.length + ix_offset;
        for (int xindex = ix_offset; xindex < mx; ++xindex) {
            this.data[xindex][iy] = val[xindex - ix_offset];
        }
    }

    public void setValue(int ix, int iy, byte val) {
        if (iy < 0 || iy >= this.ny) {
            throw new IllegalArgumentException("Row index " + iy + " out of range.");
        }
        if (ix < 0 || ix >= this.nx) {
            throw new IllegalArgumentException("Column index " + ix + " out of range.");
        }
        this.data[ix][iy] = val;
    }

    public byte getValue(int col, int row) {
        return this.data[col][row];
    }

    public void setShowVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    public void setShowGridLines(boolean showGridLines) {
        ((Grid)this).visible = showGridLines;
    }

    public void randomize() {
        Random random = new Random();
        int nr = this.data[0].length;
        for (int rindex = 0; rindex < nr; ++rindex) {
            int nc = this.data.length;
            for (int cindex = 0; cindex < nc; ++cindex) {
                this.data[cindex][rindex] = (byte)random.nextInt(256);
            }
        }
    }

    public JFrame showLegend() {
        InteractivePanel dp = new InteractivePanel();
        dp.setPreferredSize(new Dimension(300, 66));
        dp.setGutters(0, 0, 0, 35);
        dp.setClipAtGutter(false);
        if (this.legendFrame == null) {
            this.legendFrame = new JFrame("Legend");
        }
        this.legendFrame.setResizable(false);
        this.legendFrame.setContentPane(dp);
        CellLattice lattice = new CellLattice(256, 1);
        lattice.setMinMax(-128.0, 127.0, 0.0, 1.0);
        byte[][] data = new byte[256][1];
        for (int i = 0; i < 256; ++i) {
            data[i][0] = (byte)(-128 + i);
        }
        lattice.setBlock(0, 0, data);
        dp.addDrawable(lattice);
        XAxis xaxis = new XAxis("");
        xaxis.setLocationType(2);
        xaxis.setLocation(-0.5);
        xaxis.setEnabled(true);
        dp.addDrawable(xaxis);
        this.legendFrame.pack();
        ((Component)this.legendFrame).setVisible(true);
        return this.legendFrame;
    }

    public void setColorPalette(Color[] _colors) {
        int i;
        int n = Math.min(256, _colors.length);
        for (i = 0; i < n; ++i) {
            this.colors[i] = _colors[i];
        }
        for (i = n; i < 256; ++i) {
            this.colors[i] = Color.black;
        }
    }

    public void setGridLineColor(Color _color) {
        this.color = _color;
    }

    public void setIndexedColor(int i, Color color) {
        i = (i + 256) % this.colors.length;
        this.colors[i] = color;
    }

    public boolean isMeasured() {
        return true;
    }

    public void setXMin(double _value) {
        this.xmin = _value;
    }

    public void setXMax(double _value) {
        this.xmax = _value;
    }

    public void setYMin(double _value) {
        this.ymin = _value;
    }

    public void setYMax(double _value) {
        this.ymax = _value;
    }

    public void createDefaultColors() {
        for (int i = 0; i < 256; ++i) {
            double x = i < 128 ? (double)(i - 100) / 255.0 : -1.0;
            double val = Math.exp(-x * x * 8.0);
            int red = (int)(255.0 * val);
            x = i < 128 ? (double)i / 255.0 : (double)(255 - i) / 255.0;
            val = Math.exp(-x * x * 8.0);
            int green = (int)(255.0 * val);
            x = i < 128 ? -1.0 : (double)(i - 156) / 255.0;
            val = Math.exp(-x * x * 8.0);
            int blue = (int)(255.0 * val);
            this.colors[i] = new Color(red, green, blue);
        }
    }
}

