/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display2d.ComplexInterpolatedPlot;
import org.opensourcephysics.display2d.ContourPlot;
import org.opensourcephysics.display2d.GridData;

public class ComplexContourPlot
extends ComplexInterpolatedPlot {
    ContourPlot contour;
    boolean showContours = true;

    public ComplexContourPlot() {
        super((GridData)null);
    }

    public ComplexContourPlot(GridData griddata) {
        super(griddata);
        this.contour = new ContourPlot(griddata);
        this.contour.setPaletteType(7);
        this.contour.setGridLineColor(Color.lightGray);
        this.contour.update();
    }

    public void setAutoscaleZ(boolean isAutoscale, double floor, double ceil) {
        super.setAutoscaleZ(isAutoscale, ceil);
        this.contour.setAutoscaleZ(isAutoscale, floor, ceil);
    }

    public void update() {
        super.update();
        if (this.contour != null && this.showContours) {
            this.contour.update();
        }
    }

    public void setGridData(GridData griddata) {
        super.setGridData(griddata);
        super.setShowGridLines(false);
        this.contour.setGridData(griddata);
    }

    public void setIndexes(int[] indexes) {
        super.setIndexes(indexes);
        this.contour.setIndexes(indexes);
    }

    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    public JFrame showLegend() {
        return this.colorMap.showLegend();
    }

    public void setShowGridLines(boolean show) {
        this.contour.setShowGridLines(show);
    }

    public void setColorPalette(Color[] colors) {
    }

    public void setPaletteType(int type) {
    }

    public void setFloorCeilColor(Color floorColor, Color ceilColor) {
        super.setFloorCeilColor(floorColor, ceilColor);
    }

    public void setGridLineColor(Color color) {
        this.contour.setGridLineColor(color);
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        super.draw(panel, g);
        if (this.showContours) {
            this.contour.draw(panel, g);
        }
    }
}

