/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Point;
import java.awt.Rectangle;

public final class SurfacePlotProjector {
    private double scale_x;
    private double scale_y;
    private double scale_z;
    private double distance;
    private double _2D_scale;
    private double rotation;
    private double elevation;
    private double sin_rotation;
    private double cos_rotation;
    private double sin_elevation;
    private double cos_elevation;
    private int _2D_trans_x;
    private int _2D_trans_y;
    private int x1;
    private int x2;
    private int y1;
    private int y2;
    private int center_x;
    private int center_y;
    private int trans_x;
    private int trans_y;
    private double factor;
    private double sx_cos;
    private double sy_cos;
    private double sz_cos;
    private double sx_sin;
    private double sy_sin;
    private double sz_sin;
    private final double DEGTORAD = Math.PI / 180;

    SurfacePlotProjector() {
        this.setScaling(1.0);
        this.setRotationAngle(0.0);
        this.setElevationAngle(0.0);
        this.setDistance(10.0);
        this.set2DScaling(1.0);
        this.set2DTranslation(0, 0);
    }

    public void setProjectionArea(Rectangle r) {
        this.x1 = r.x;
        this.x2 = this.x1 + r.width;
        this.y1 = r.y;
        this.y2 = this.y1 + r.height;
        this.center_x = (this.x1 + this.x2) / 2;
        this.center_y = (this.y1 + this.y2) / 2;
        this.trans_x = this.center_x + this._2D_trans_x;
        this.trans_y = this.center_y + this._2D_trans_y;
    }

    public void setRotationAngle(double angle) {
        this.rotation = angle;
        this.sin_rotation = Math.sin(angle * (Math.PI / 180));
        this.cos_rotation = Math.cos(angle * (Math.PI / 180));
        this.sx_cos = -this.scale_x * this.cos_rotation;
        this.sx_sin = -this.scale_x * this.sin_rotation;
        this.sy_cos = -this.scale_y * this.cos_rotation;
        this.sy_sin = this.scale_y * this.sin_rotation;
    }

    public double getRotationAngle() {
        return this.rotation;
    }

    public double getSinRotationAngle() {
        return this.sin_rotation;
    }

    public double getCosRotationAngle() {
        return this.cos_rotation;
    }

    public void setElevationAngle(double angle) {
        this.elevation = angle;
        this.sin_elevation = Math.sin(angle * (Math.PI / 180));
        this.cos_elevation = Math.cos(angle * (Math.PI / 180));
        this.sz_cos = this.scale_z * this.cos_elevation;
        this.sz_sin = this.scale_z * this.sin_elevation;
    }

    public double getElevationAngle() {
        return this.elevation;
    }

    public double getSinElevationAngle() {
        return this.sin_elevation;
    }

    public double getCosElevationAngle() {
        return this.cos_elevation;
    }

    public void setDistance(double new_distance) {
        this.distance = new_distance;
        this.factor = this.distance * this._2D_scale;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setXScaling(double scaling) {
        this.scale_x = scaling;
        this.sx_cos = -this.scale_x * this.cos_rotation;
        this.sx_sin = -this.scale_x * this.sin_rotation;
    }

    public double getXScaling() {
        return this.scale_x;
    }

    public void setYScaling(double scaling) {
        this.scale_y = scaling;
        this.sy_cos = -this.scale_y * this.cos_rotation;
        this.sy_sin = this.scale_y * this.sin_rotation;
    }

    public double getYScaling() {
        return this.scale_y;
    }

    public void setZScaling(double scaling) {
        this.scale_z = scaling;
        this.sz_cos = this.scale_z * this.cos_elevation;
        this.sz_sin = this.scale_z * this.sin_elevation;
    }

    public double getZScaling() {
        return this.scale_z;
    }

    public void setScaling(double x, double y, double z) {
        this.scale_x = x;
        this.scale_y = y;
        this.scale_z = z;
        this.sx_cos = -this.scale_x * this.cos_rotation;
        this.sx_sin = -this.scale_x * this.sin_rotation;
        this.sy_cos = -this.scale_y * this.cos_rotation;
        this.sy_sin = this.scale_y * this.sin_rotation;
        this.sz_cos = this.scale_z * this.cos_elevation;
        this.sz_sin = this.scale_z * this.sin_elevation;
    }

    public void setScaling(double scaling) {
        this.scale_y = this.scale_z = scaling;
        this.scale_x = this.scale_z;
        this.sx_cos = -this.scale_x * this.cos_rotation;
        this.sx_sin = -this.scale_x * this.sin_rotation;
        this.sy_cos = -this.scale_y * this.cos_rotation;
        this.sy_sin = this.scale_y * this.sin_rotation;
        this.sz_cos = this.scale_z * this.cos_elevation;
        this.sz_sin = this.scale_z * this.sin_elevation;
    }

    public void set2DScaling(double scaling) {
        this._2D_scale = scaling;
        this.factor = this.distance * this._2D_scale;
    }

    public double get2DScaling() {
        return this._2D_scale;
    }

    public void set2DTranslation(int x, int y) {
        this._2D_trans_x = x;
        this._2D_trans_y = y;
        this.trans_x = this.center_x + this._2D_trans_x;
        this.trans_y = this.center_y + this._2D_trans_y;
    }

    public void set2D_xTranslation(int x) {
        this._2D_trans_x = x;
        this.trans_x = this.center_x + this._2D_trans_x;
    }

    public int get2D_xTranslation() {
        return this._2D_trans_x;
    }

    public void set2D_yTranslation(int y) {
        this._2D_trans_y = y;
        this.trans_y = this.center_y + this._2D_trans_y;
    }

    public int get2D_yTranslation() {
        return this._2D_trans_y;
    }

    public final Point project(double x, double y, double z) {
        double temp = x;
        x = x * this.sx_cos + y * this.sy_sin;
        y = temp * this.sx_sin + y * this.sy_cos;
        temp = this.factor / (y * this.cos_elevation - z * this.sz_sin + this.distance);
        return new Point((int)(Math.round(x * temp) + (long)this.trans_x), (int)(Math.round((y * this.sin_elevation + z * this.sz_cos) * -temp) + (long)this.trans_y));
    }
}

