/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.VectorPlot;

public class VectorColorMapper {
    public static final int SPECTRUM = 0;
    public static final int RED = 1;
    public static final int BLUE = 2;
    public static final int GREEN = 3;
    public static final int BLACK = 4;
    private Color background = Color.WHITE;
    private Color[] colors;
    private double ceil;
    private double floor;
    private int numColors;
    private int paletteType;
    private JFrame legendFrame;

    public VectorColorMapper(int _numColors, double _ceil) {
        this.ceil = _ceil;
        this.numColors = _numColors;
        this.floor = this.numColors < 2 ? 0.0 : this.ceil / (double)(this.numColors - 1);
        this.createVectorfieldPalette();
    }

    public double getFloor() {
        return this.floor;
    }

    public double getCeiling() {
        return this.ceil;
    }

    protected void setPaletteType(int _paletteType) {
        this.paletteType = _paletteType;
    }

    protected void checkPallet(Color backgroundColor) {
        if (this.background == backgroundColor) {
            return;
        }
        this.background = backgroundColor;
        this.createVectorfieldPalette();
    }

    public void setScale(double _ceil) {
        this.ceil = _ceil;
    }

    public Color doubleToColor(double mag) {
        if (mag <= this.floor) {
            return this.background;
        }
        double sat = 1.0 - Math.abs(mag / this.ceil);
        int r = 255 - (int)(sat * (double)this.background.getRed());
        int g = 255 - (int)(sat * (double)this.background.getGreen());
        int b = 255 - (int)(sat * (double)this.background.getBlue());
        switch (this.paletteType) {
            case 1: {
                if (mag >= this.ceil) {
                    return Color.red;
                }
                return new Color(r, 0, 0);
            }
            case 2: {
                if (mag >= this.ceil) {
                    return Color.blue;
                }
                return new Color(0, 0, b);
            }
            case 3: {
                if (mag >= this.ceil) {
                    return Color.green;
                }
                return new Color(0, g, 0);
            }
            case 4: {
                if (mag >= this.ceil) {
                    return Color.black;
                }
                return new Color(0, 0, 0);
            }
        }
        if (mag >= this.ceil) {
            return new Color((int)(255.0 * this.ceil / mag), 0, 0);
        }
        int index = (int)((double)(this.numColors - 1) * mag / this.ceil);
        return this.colors[index];
    }

    private void createVectorfieldPalette() {
        int i;
        this.colors = new Color[this.numColors];
        int n1 = this.numColors / 3;
        n1 = Math.max(1, n1);
        int bgr = this.background.getRed();
        int bgg = this.background.getGreen();
        int bgb = this.background.getBlue();
        for (i = 0; i < n1; ++i) {
            int tr = bgr - bgr * i / n1;
            int tg = bgg - bgg * i / n1;
            this.colors[i] = new Color(tr, tg, bgb);
        }
        for (i = n1; i < this.numColors; ++i) {
            double sigma = (double)n1 / 1.2;
            double arg1 = (double)(i - n1) / sigma;
            double arg2 = (double)(i - 2 * n1) / sigma;
            double arg3 = (double)(i - this.numColors) / sigma;
            int b = (int)(255.0 * Math.exp(-arg1 * arg1));
            int g = (int)(255.0 * Math.exp(-arg2 * arg2));
            int r = (int)(255.0 * Math.exp(-arg3 * arg3));
            r = Math.min(255, r);
            b = Math.min(255, b);
            g = Math.min(255, g);
            this.colors[i] = new Color(r, g, b);
        }
    }

    public JFrame showLegend() {
        double floor = 0.0;
        double ceil = this.ceil * 2.0;
        InteractivePanel dp = new InteractivePanel();
        dp.setPreferredSize(new Dimension(300, 120));
        dp.setGutters(0, 0, 0, 35);
        dp.setClipAtGutter(false);
        dp.setSquareAspect(false);
        if (this.legendFrame == null) {
            this.legendFrame = new JFrame("Legend");
        }
        this.legendFrame.setResizable(true);
        this.legendFrame.setContentPane(dp);
        int numVecs = 30;
        GridPointData pointdata = new GridPointData(numVecs, 2, 3);
        double[][][] data = pointdata.getData();
        double delta = 1.5 * ceil / (double)numVecs;
        double cval = floor - delta / 2.0;
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            data[i][1][2] = cval;
            data[i][1][3] = 0.0;
            data[i][1][4] = 4.0;
            cval += delta;
        }
        pointdata.setScale(0.0, 1.5 * ceil + delta, 0.0, 1.0);
        VectorPlot plot = new VectorPlot(pointdata);
        plot.setAutoscaleZ(false, 0.5 * ceil, ceil);
        plot.update();
        dp.addDrawable(plot);
        XAxis xaxis = new XAxis("");
        xaxis.setLocationType(2);
        xaxis.setLocation(-0.0);
        xaxis.setEnabled(true);
        dp.addDrawable(xaxis);
        this.legendFrame.pack();
        ((Component)this.legendFrame).setVisible(true);
        return this.legendFrame;
    }
}

