/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.Plot2DLoader;
import org.opensourcephysics.display2d.VectorColorMapper;

public class VectorPlot
implements Plot2D {
    public static final int STROKEDARROW = 0;
    public static final int FILLEDARROW = 1;
    private GeneralPath vectorpath;
    private int arrowType = 0;
    private boolean visible = true;
    private GridData griddata;
    private boolean autoscaleZ = true;
    private boolean scaleArrowToGrid = true;
    private VectorColorMapper colorMap;
    private int ampIndex = 0;
    private int aIndex = 1;
    private int bIndex = 2;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    Grid grid;

    public VectorPlot() {
        this(null);
    }

    public VectorPlot(GridData _griddata) {
        this.griddata = _griddata;
        this.colorMap = new VectorColorMapper(256, 1.0);
        if (this.griddata == null) {
            return;
        }
        this.grid = this.griddata.isCellData() ? new Grid(this.griddata.getNx(), this.griddata.getNy()) : new Grid(this.griddata.getNx() - 1, this.griddata.getNy() - 1);
        this.grid.setColor(Color.lightGray);
        this.grid.setVisible(false);
        this.update();
    }

    public int xToIndex(double x) {
        return this.griddata.xToIndex(x);
    }

    public int yToIndex(double y) {
        return this.griddata.yToIndex(y);
    }

    public double indexToX(int i) {
        return this.griddata.indexToX(i);
    }

    public double indexToY(int i) {
        return this.griddata.indexToY(i);
    }

    public void setAll(Object obj) {
        double[][][] val = (double[][][])obj;
        this.copyVecData(val);
        this.update();
    }

    public void setAll(Object obj, double xmin, double xmax, double ymin, double ymax) {
        double[][][] val = (double[][][])obj;
        this.copyVecData(val);
        if (this.griddata.isCellData()) {
            this.griddata.setCellScale(xmin, xmax, ymin, ymax);
        } else {
            this.griddata.setScale(xmin, xmax, ymin, ymax);
        }
        this.update();
    }

    private void copyVecData(double[][][] vals) {
        if (this.griddata != null && !(this.griddata instanceof ArrayData)) {
            throw new IllegalStateException("SetAll only supports ArrayData for data storage.");
        }
        if (this.griddata == null || this.griddata.getNx() != vals[0].length || this.griddata.getNy() != vals[0][0].length) {
            this.griddata = new ArrayData(vals[0].length, vals[0][0].length, 3);
            this.setGridData(this.griddata);
        }
        double[][] colorValue = this.griddata.getData()[0];
        double[][] xComp = this.griddata.getData()[1];
        double[][] yComp = this.griddata.getData()[2];
        int ny = vals[0][0].length;
        int nx = vals[0].length;
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                colorValue[i][j] = Math.sqrt(vals[0][i][j] * vals[0][i][j] + vals[1][i][j] * vals[1][i][j]);
                xComp[i][j] = colorValue[i][j] == 0.0 ? 0.0 : vals[0][i][j] / colorValue[i][j];
                yComp[i][j] = colorValue[i][j] == 0.0 ? 0.0 : vals[1][i][j] / colorValue[i][j];
            }
        }
    }

    public GridData getGridData() {
        return this.griddata;
    }

    public void setGridData(GridData _griddata) {
        this.griddata = _griddata;
        if (this.griddata == null) {
            return;
        }
        Grid newgrid = this.griddata.isCellData() ? new Grid(this.griddata.getNx(), this.griddata.getNy()) : new Grid(this.griddata.getNx() - 1, this.griddata.getNy() - 1);
        newgrid.setColor(Color.lightGray);
        newgrid.setVisible(false);
        if (this.grid != null) {
            newgrid.setColor(this.grid.getColor());
            newgrid.setVisible(this.grid.isVisible());
        }
        this.grid = newgrid;
    }

    public void setIndexes(int[] indexes) {
        this.ampIndex = indexes[0];
        this.aIndex = indexes[1];
        this.bIndex = indexes[2];
    }

    public void setArrowType(int type) {
        this.arrowType = type;
    }

    public void setPaletteType(int mode) {
        this.colorMap.setPaletteType(mode);
    }

    public void setColorPalette(Color[] colors) {
    }

    public void setVisible(boolean vis) {
        this.visible = vis;
    }

    public void setShowGridLines(boolean showGrid) {
        if (this.grid == null) {
            this.grid = new Grid(0);
        }
        this.grid.setVisible(showGrid);
    }

    public void setGridLineColor(Color c) {
        this.grid.setColor(c);
    }

    public void draw(DrawingPanel panel, Graphics g) {
        int sgny;
        int sgnx;
        if (!this.visible || this.griddata == null) {
            return;
        }
        if (this.grid.isVisible()) {
            this.grid.draw(panel, g);
        }
        this.colorMap.checkPallet(panel.getBackground());
        GridData griddata = this.griddata;
        double[][][] data = griddata.getData();
        double dx = griddata.getDx();
        double dy = griddata.getDy();
        double left = griddata.getLeft();
        double top = griddata.getTop();
        double aspectRatio = panel.getAspectRatio();
        float arrowLength = (float)Math.abs(panel.getYPixPerUnit());
        if (this.scaleArrowToGrid) {
            arrowLength = Math.max(1.0f, (float)panel.getSize().width / (float)data.length / (float)aspectRatio - 1.0f);
            arrowLength = Math.min(18.0f, arrowLength * 0.72f);
        }
        switch (this.arrowType) {
            case 0: {
                this.vectorpath = VectorPlot.createVectorPath(arrowLength);
                break;
            }
            case 1: {
                this.vectorpath = VectorPlot.createFilledVectorPath(arrowLength);
                break;
            }
            default: {
                this.vectorpath = VectorPlot.createVectorPath(arrowLength);
            }
        }
        sgnx = panel.getXPixPerUnit() < 0.0 ? (sgnx = -1) : 1;
        sgny = panel.getYPixPerUnit() < 0.0 ? (sgny = -1) : 1;
        double amp = 0.0;
        double a = 0.0;
        double b = 0.0;
        double x = 0.0;
        double y = 0.0;
        Color background = panel.getBackground();
        int nx = griddata.getNx();
        for (int i = 0; i < nx; ++i) {
            int ny = griddata.getNy();
            block9: for (int j = 0; j < ny; ++j) {
                if (griddata instanceof GridPointData) {
                    x = data[i][j][0];
                    y = data[i][j][1];
                    amp = data[i][j][this.ampIndex + 2];
                    a = data[i][j][this.aIndex + 2];
                    b = data[i][j][this.bIndex + 2];
                } else if (griddata instanceof ArrayData) {
                    x = left + (double)i * dx;
                    y = top + (double)j * dy;
                    amp = data[this.ampIndex][i][j];
                    a = data[this.aIndex][i][j];
                    b = data[this.bIndex][i][j];
                }
                Graphics2D g2 = (Graphics2D)g;
                Color c = this.colorMap.doubleToColor(amp);
                if (background == c) continue;
                g2.setColor(this.colorMap.doubleToColor(amp));
                AffineTransform at = new AffineTransform((double)sgnx * aspectRatio * a, (double)(-sgny) * b, (double)sgnx * aspectRatio * b, (double)sgny * a, (double)panel.xToPix(x), (double)panel.yToPix(y));
                Shape s = this.vectorpath.createTransformedShape(at);
                switch (this.arrowType) {
                    case 0: {
                        g2.draw(s);
                        continue block9;
                    }
                    case 1: {
                        g2.fill(s);
                        continue block9;
                    }
                    default: {
                        g2.draw(s);
                    }
                }
            }
        }
    }

    public void scaleArrowLenghToGrid(boolean scaleToGrid) {
        this.scaleArrowToGrid = scaleToGrid;
    }

    public void setAutoscaleZ(boolean isAutoscale, double floor, double ceil) {
        this.autoscaleZ = isAutoscale;
        if (this.autoscaleZ) {
            this.update();
        } else {
            this.colorMap.setScale(ceil);
        }
    }

    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    public double getFloor() {
        return 0.0;
    }

    public double getCeiling() {
        return this.colorMap.getCeiling();
    }

    public void setFloorCeilColor(Color floorColor, Color ceilColor) {
    }

    public JFrame showLegend() {
        return this.colorMap.showLegend();
    }

    public void update() {
        if (this.griddata == null) {
            return;
        }
        if (this.autoscaleZ) {
            double[] minmax = this.griddata.getZRange(this.ampIndex);
            this.colorMap.setScale(minmax[1]);
        }
        if (this.griddata.isCellData()) {
            double dx = this.griddata.getDx();
            double dy = this.griddata.getDy();
            this.xmin = this.griddata.getLeft() - dx / 2.0;
            this.xmax = this.griddata.getRight() + dx / 2.0;
            this.ymin = this.griddata.getBottom() + dy / 2.0;
            this.ymax = this.griddata.getTop() - dy / 2.0;
        } else {
            this.xmin = this.griddata.getLeft();
            this.xmax = this.griddata.getRight();
            this.ymin = this.griddata.getBottom();
            this.ymax = this.griddata.getTop();
        }
        this.grid.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    private void drawLine(Graphics2D g2, double[] vertex, DrawingPanel panel) {
        g2.setColor(this.colorMap.doubleToColor(vertex[2]));
        int pixx = panel.xToPix(vertex[0]);
        int pixy = panel.yToPix(vertex[1]);
        int pixa = panel.xToPix(vertex[0] + vertex[3]);
        int pixb = panel.yToPix(vertex[1] + vertex[4]);
        g2.drawLine(pixx, pixy, pixa, pixb);
    }

    static GeneralPath createVectorPath(float size) {
        float head = Math.min(15.0f, 1.0f + size / 5.0f);
        GeneralPath path = new GeneralPath();
        path.moveTo(-size / 2.0f, 0.0f);
        path.lineTo(size / 2.0f, 0.0f);
        path.lineTo(size / 2.0f - head, 2.0f * head / 3.0f);
        path.lineTo(size / 2.0f, 0.0f);
        path.lineTo(size / 2.0f - head, -2.0f * head / 3.0f);
        return path;
    }

    static GeneralPath createFilledVectorPath(float size) {
        float head = Math.min(15.0f, 1.0f + size / 5.0f);
        GeneralPath path = new GeneralPath();
        path.moveTo(-size / 2.0f, 1.0f);
        path.lineTo(size / 2.0f - head, 1.0f);
        path.lineTo(size / 2.0f - head, 2.0f * head / 3.0f);
        path.lineTo(size / 2.0f, 0.0f);
        path.lineTo(size / 2.0f - head, -2.0f * head / 3.0f);
        path.lineTo(size / 2.0f - head, -1.0f);
        path.moveTo(-size / 2.0f, -1.0f);
        return path;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getYMax() {
        return this.ymax;
    }

    public boolean isMeasured() {
        return this.griddata != null;
    }

    public static XML.ObjectLoader getLoader() {
        return new Plot2DLoader(){

            public Object createObject(XMLControl control) {
                return new VectorPlot(null);
            }
        };
    }
}

