/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.core;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.numerics.Transformation;

public interface Camera {
    public static final int MODE_PLANAR_XY = 0;
    public static final int MODE_PLANAR_XZ = 1;
    public static final int MODE_PLANAR_YZ = 2;
    public static final int MODE_NO_PERSPECTIVE = 10;
    public static final int MODE_PERSPECTIVE = 11;

    public void setProjectionMode(int var1);

    public int getProjectionMode();

    public void reset();

    public void setXYZ(double var1, double var3, double var5);

    public void setXYZ(double[] var1);

    public double getX();

    public double getY();

    public double getZ();

    public void setFocusXYZ(double var1, double var3, double var5);

    public void setFocusXYZ(double[] var1);

    public double getFocusX();

    public double getFocusY();

    public double getFocusZ();

    public void setRotation(double var1);

    public double getRotation();

    public void setDistanceToScreen(double var1);

    public double getDistanceToScreen();

    public void setAzimuth(double var1);

    public double getAzimuth();

    public void setAltitude(double var1);

    public double getAltitude();

    public void setAzimuthAndAltitude(double var1, double var3);

    public Transformation getTransformation();

    public static abstract class Loader
    implements XML.ObjectLoader {
        public abstract Object createObject(XMLControl var1);

        public void saveObject(XMLControl control, Object obj) {
            Camera camera = (Camera)obj;
            control.setValue("projection mode", camera.getProjectionMode());
            control.setValue("x", camera.getX());
            control.setValue("y", camera.getY());
            control.setValue("z", camera.getZ());
            control.setValue("focus x", camera.getFocusX());
            control.setValue("focus y", camera.getFocusY());
            control.setValue("focus z", camera.getFocusZ());
            control.setValue("rotation", camera.getRotation());
            control.setValue("distance to screen", camera.getDistanceToScreen());
        }

        public Object loadObject(XMLControl control, Object obj) {
            Camera camera = (Camera)obj;
            camera.setProjectionMode(control.getInt("projection mode"));
            double x = control.getDouble("x");
            double y = control.getDouble("y");
            double z = control.getDouble("z");
            camera.setXYZ(x, y, z);
            x = control.getDouble("focus x");
            y = control.getDouble("focus y");
            z = control.getDouble("focus z");
            camera.setFocusXYZ(x, y, z);
            camera.setRotation(control.getDouble("rotation"));
            camera.setDistanceToScreen(control.getDouble("distance to screen"));
            return camera;
        }
    }
}

