/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.core;

import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.Element;

public interface ElementCone
extends Element {
    public void setTruncationHeight(double var1);

    public double getTruncationHeight();

    public void setMinimumAngle(int var1);

    public int getMinimumAngle();

    public void setMaximumAngle(int var1);

    public int getMaximumAngle();

    public void setClosedBottom(boolean var1);

    public boolean isClosedBottom();

    public void setClosedTop(boolean var1);

    public boolean isClosedTop();

    public void setClosedLeft(boolean var1);

    public boolean isClosedLeft();

    public void setClosedRight(boolean var1);

    public boolean isClosedRight();

    public static abstract class Loader
    extends Element.Loader {
        public void saveObject(XMLControl control, Object obj) {
            super.saveObject(control, obj);
            ElementCone element = (ElementCone)obj;
            if (Double.isNaN(element.getTruncationHeight())) {
                control.setValue("truncation height", -1.0);
            } else {
                control.setValue("truncation height", element.getTruncationHeight());
            }
            control.setValue("closed top", element.isClosedTop());
            control.setValue("closed bottom", element.isClosedBottom());
            control.setValue("closed left", element.isClosedLeft());
            control.setValue("closed right", element.isClosedRight());
            control.setValue("minimum angle", element.getMinimumAngle());
            control.setValue("maximum angle", element.getMaximumAngle());
        }

        public Object loadObject(XMLControl control, Object obj) {
            super.loadObject(control, obj);
            ElementCone element = (ElementCone)obj;
            element.setTruncationHeight(control.getDouble("truncation height"));
            element.setClosedTop(control.getBoolean("closed top"));
            element.setClosedBottom(control.getBoolean("closed bottom"));
            element.setClosedLeft(control.getBoolean("closed left"));
            element.setClosedRight(control.getBoolean("closed right"));
            element.setMinimumAngle(control.getInt("minimum angle"));
            element.setMaximumAngle(control.getInt("maximum angle"));
            return obj;
        }
    }
}

