/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.core;

import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;

public interface VisualizationHints {
    public static final int DECORATION_NONE = 0;
    public static final int DECORATION_AXES = 1;
    public static final int DECORATION_CUBE = 2;
    public static final int CURSOR_NONE = 0;
    public static final int CURSOR_XYZ = 1;
    public static final int CURSOR_CUBE = 2;
    public static final int CURSOR_CROSSHAIR = 3;

    public void setDecorationType(int var1);

    public int getDecorationType();

    public void setCursorType(int var1);

    public int getCursorType();

    public void setRemoveHiddenLines(boolean var1);

    public boolean isRemoveHiddenLines();

    public void setAllowQuickRedraw(boolean var1);

    public boolean isAllowQuickRedraw();

    public void setUseColorDepth(boolean var1);

    public boolean isUseColorDepth();

    public void setShowCoordinates(int var1);

    public int getShowCoordinates();

    public void setXFormat(String var1);

    public String getXFormat();

    public void setYFormat(String var1);

    public String getYFormat();

    public void setZFormat(String var1);

    public String getZFormat();

    public static abstract class Loader
    extends XMLLoader {
        public abstract Object createObject(XMLControl var1);

        public void saveObject(XMLControl control, Object obj) {
            VisualizationHints hints = (VisualizationHints)obj;
            control.setValue("decoration type", hints.getDecorationType());
            control.setValue("cursor type", hints.getCursorType());
            control.setValue("remove hidden lines", hints.isRemoveHiddenLines());
            control.setValue("allow quick redraw", hints.isAllowQuickRedraw());
            control.setValue("use color depth", hints.isUseColorDepth());
            control.setValue("show coordinates at", hints.getShowCoordinates());
            control.setValue("x format", hints.getXFormat());
            control.setValue("y format", hints.getYFormat());
            control.setValue("z format", hints.getZFormat());
        }

        public Object loadObject(XMLControl control, Object obj) {
            VisualizationHints hints = (VisualizationHints)obj;
            hints.setDecorationType(control.getInt("decoration type"));
            hints.setCursorType(control.getInt("cursor type"));
            hints.setRemoveHiddenLines(control.getBoolean("remove hidden lines"));
            hints.setAllowQuickRedraw(control.getBoolean("allow quick redraw"));
            hints.setUseColorDepth(control.getBoolean("use color depth"));
            hints.setShowCoordinates(control.getInt("show coordinates at"));
            hints.setXFormat(control.getString("x format"));
            hints.setYFormat(control.getString("y format"));
            hints.setZFormat(control.getString("z format"));
            return obj;
        }
    }
}

