/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.opensourcephysics.controls.ControlFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTreeChooser;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display3d.core.CameraInspector;
import org.opensourcephysics.display3d.core.DrawingFrame3D;
import org.opensourcephysics.display3d.simple3d.DrawingPanel3D;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.tools.ExportTool;
import org.opensourcephysics.tools.LocalJob;

public class DrawingFrame3D
extends OSPFrame
implements ClipboardOwner,
org.opensourcephysics.display3d.core.DrawingFrame3D {
    protected JMenu fileMenu;
    protected JMenu editMenu;
    protected JMenuItem copyItem;
    protected JMenuItem pasteItem;
    protected JMenuItem replaceItem;
    protected JMenu visualMenu;
    protected JMenu displayMenu;
    protected JMenu decorationMenu;
    protected JMenu cursorMenu;
    protected JMenuItem displayPerspectiveItem;
    protected JMenuItem displayNoPerspectiveItem;
    protected JMenuItem displayXYItem;
    protected JMenuItem displayXZItem;
    protected JMenuItem displayYZItem;
    protected JMenuItem decorationCubeItem;
    protected JMenuItem decorationNoneItem;
    protected JMenuItem decorationAxesItem;
    protected JMenuItem cursorNoneItem;
    protected JMenuItem cursorCubeItem;
    protected JMenuItem cursorXYZItem;
    protected JMenuItem cursorCrosshairItem;
    protected JMenuItem zoomToFitItem;
    protected JMenuItem resetCameraItem;
    protected JMenuItem cameraItem;
    protected JFrame cameraInspectorFrame;
    protected JMenuBar menuBar = new JMenuBar();
    protected org.opensourcephysics.display3d.core.DrawingPanel3D drawingPanel;
    protected static final int MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    static /* synthetic */ Class class$org$opensourcephysics$display3d$simple3d$Element;

    public DrawingFrame3D() {
        this("Drawing Frame", (DrawingPanel3D)null);
    }

    public DrawingFrame3D(DrawingPanel3D drawingPanel) {
        this("Drawing Frame", drawingPanel);
    }

    public DrawingFrame3D(String title, DrawingPanel3D _drawingPanel) {
        super(title);
        this.drawingPanel = _drawingPanel;
        if (this.drawingPanel != null) {
            this.getContentPane().add((Component)((JPanel)((Object)this.drawingPanel)), "Center");
        }
        this.pack();
        if (!OSPFrame.appletMode) {
            this.createMenuBar();
        }
        this.setAnimated(true);
        this.setEnabledPaste(true);
        this.setEnabledReplace(true);
    }

    public void render() {
        this.drawingPanel.render();
    }

    public void setMessage(String msg) {
        ((DrawingPanel3D)this.drawingPanel).setMessage(msg);
    }

    public void setMessage(String msg, int location) {
        ((DrawingPanel3D)this.drawingPanel).setMessage(msg, location);
    }

    public org.opensourcephysics.display3d.core.DrawingPanel3D getDrawingPanel3D() {
        return this.drawingPanel;
    }

    public void setDrawingPanel3D(org.opensourcephysics.display3d.core.DrawingPanel3D _drawingPanel) {
        if (this.drawingPanel != null) {
            this.getContentPane().remove((JPanel)((Object)this.drawingPanel));
        }
        this.drawingPanel = _drawingPanel;
        if (this.drawingPanel != null) {
            this.getContentPane().add((Component)((JPanel)((Object)this.drawingPanel)), "Center");
        }
        this.pack();
    }

    public JFrame getJFrame() {
        return this;
    }

    public void setEnabledPaste(boolean enable) {
        this.pasteItem.setEnabled(enable);
    }

    protected void pasteAction() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable data = clipboard.getContents(null);
            XMLControlElement control = new XMLControlElement();
            control.readXML((String)data.getTransferData(DataFlavor.stringFlavor));
            XMLTreeChooser chooser = new XMLTreeChooser("Select Elements", "Select one or more elements.", this);
            List props = chooser.choose(control, class$org$opensourcephysics$display3d$simple3d$Element == null ? (class$org$opensourcephysics$display3d$simple3d$Element = DrawingFrame3D.class$("org.opensourcephysics.display3d.simple3d.Element")) : class$org$opensourcephysics$display3d$simple3d$Element);
            if (!props.isEmpty()) {
                Iterator it = props.iterator();
                while (it.hasNext()) {
                    XMLControl prop = (XMLControl)it.next();
                    Element element = (Element)prop.loadObject(null);
                    System.out.println("Adding element " + element);
                    this.drawingPanel.addElement(element);
                }
            }
            if (this.drawingPanel != null) {
                this.drawingPanel.repaint();
            }
        }
        catch (UnsupportedFlavorException ex) {
        }
        catch (IOException ex) {
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
    }

    public void setEnabledReplace(boolean enable) {
        this.replaceItem.setEnabled(enable);
    }

    public void replaceAction() {
        this.drawingPanel.removeAllElements();
        this.pasteAction();
    }

    protected void copyAction() {
        XMLControlElement control = new XMLControlElement(this);
        control.saveObject(null);
        StringSelection data = new StringSelection(control.toXML());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(data, this);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void setEnabledCopy(boolean enable) {
        this.copyItem.setEnabled(enable);
    }

    private void createMenuBar() {
        this.fileMenu = new JMenu("File");
        JMenuItem printItem = new JMenuItem("Print...");
        printItem.setAccelerator(KeyStroke.getKeyStroke(80, MENU_SHORTCUT_KEY_MASK));
        printItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintable((Printable)((Object)DrawingFrame3D.this.drawingPanel));
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException pe) {
                        JOptionPane.showMessageDialog(DrawingFrame3D.this, "A printing error occurred. Please try again.", "Error", 0);
                    }
                }
            }
        });
        JMenuItem saveXMLItem = new JMenuItem("Save XML...");
        saveXMLItem.setAccelerator(KeyStroke.getKeyStroke(83, MENU_SHORTCUT_KEY_MASK));
        saveXMLItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawingFrame3D.this.saveXML();
            }
        });
        JMenuItem exportItem = new JMenuItem("Export...");
        exportItem.setAccelerator(KeyStroke.getKeyStroke(69, MENU_SHORTCUT_KEY_MASK));
        exportItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ExportTool.getTool().send(new LocalJob(DrawingFrame3D.this.drawingPanel), null);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
        JMenuItem saveAsPSItem = new JMenuItem("Save As PS...");
        saveAsPSItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIUtils.saveImage((JComponent)((JPanel)DrawingFrame3D.this.drawingPanel.getComponent()), "eps", DrawingFrame3D.this);
            }
        });
        JMenuItem inspectItem = new JMenuItem("Inspect");
        inspectItem.setAccelerator(KeyStroke.getKeyStroke(73, MENU_SHORTCUT_KEY_MASK));
        inspectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawingFrame3D.this.inspectXML();
            }
        });
        this.fileMenu.add(printItem);
        this.fileMenu.add(saveXMLItem);
        this.fileMenu.add(exportItem);
        this.fileMenu.add(saveAsPSItem);
        this.fileMenu.add(inspectItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu = new JMenu("Edit");
        this.menuBar.add(this.editMenu);
        this.copyItem = new JMenuItem("Copy");
        this.copyItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawingFrame3D.this.copyAction();
            }
        });
        this.editMenu.add(this.copyItem);
        this.pasteItem = new JMenuItem("Paste");
        this.pasteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawingFrame3D.this.pasteAction();
            }
        });
        this.pasteItem.setEnabled(false);
        this.editMenu.add(this.pasteItem);
        this.replaceItem = new JMenuItem("Replace");
        this.replaceItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawingFrame3D.this.replaceAction();
            }
        });
        this.replaceItem.setEnabled(false);
        this.editMenu.add(this.replaceItem);
        this.setJMenuBar(this.menuBar);
        this.cameraItem = new JMenuItem("Camera Inspector");
        this.cameraItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DrawingFrame3D.this.drawingPanel != null) {
                    if (DrawingFrame3D.this.cameraInspectorFrame == null) {
                        DrawingFrame3D.this.cameraInspectorFrame = CameraInspector.createFrame(DrawingFrame3D.this.drawingPanel);
                    }
                    ((Component)DrawingFrame3D.this.cameraInspectorFrame).setVisible(true);
                }
            }
        });
        this.decorationMenu = new JMenu("Decoration");
        this.decorationNoneItem = new JMenuItem("No decoration");
        this.decorationNoneItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DrawingFrame3D.this.drawingPanel != null) {
                    DrawingFrame3D.this.drawingPanel.getVisualizationHints().setDecorationType(0);
                    DrawingFrame3D.this.drawingPanel.repaint();
                }
            }
        });
        this.decorationMenu.add(this.decorationNoneItem);
        this.decorationCubeItem = new JMenuItem("Cube");
        this.decorationCubeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DrawingFrame3D.this.drawingPanel != null) {
                    DrawingFrame3D.this.drawingPanel.getVisualizationHints().setDecorationType(2);
                    DrawingFrame3D.this.drawingPanel.repaint();
                }
            }
        });
        this.decorationMenu.add(this.decorationCubeItem);
        this.decorationAxesItem = new JMenuItem("Axes");
        this.decorationAxesItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DrawingFrame3D.this.drawingPanel != null) {
                    DrawingFrame3D.this.drawingPanel.getVisualizationHints().setDecorationType(1);
                    DrawingFrame3D.this.drawingPanel.repaint();
                }
            }
        });
        this.decorationMenu.add(this.decorationAxesItem);
        this.cursorMenu = new JMenu("Cursor");
        this.cursorNoneItem = new JMenuItem("No cursor");
        this.cursorNoneItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DrawingFrame3D.this.drawingPanel != null) {
                    DrawingFrame3D.this.drawingPanel.getVisualizationHints().setCursorType(0);
                    DrawingFrame3D.this.drawingPanel.repaint();
                }
            }
        });
        this.cursorMenu.add(this.cursorNoneItem);
        this.cursorCubeItem = new JMenuItem("Cube");
        this.cursorCubeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DrawingFrame3D.this.drawingPanel != null) {
                    DrawingFrame3D.this.drawingPanel.getVisualizationHints().setCursorType(2);
                    DrawingFrame3D.this.drawingPanel.repaint();
                }
            }
        });
        this.cursorMenu.add(this.cursorCubeItem);
        this.cursorXYZItem = new JMenuItem("XYZ");
        this.cursorXYZItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DrawingFrame3D.this.drawingPanel != null) {
                    DrawingFrame3D.this.drawingPanel.getVisualizationHints().setCursorType(1);
                    DrawingFrame3D.this.drawingPanel.repaint();
                }
            }
        });
        this.cursorMenu.add(this.cursorXYZItem);
        this.cursorCrosshairItem = new JMenuItem("Crosshair");
        this.cursorCrosshairItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DrawingFrame3D.this.drawingPanel != null) {
                    DrawingFrame3D.this.drawingPanel.getVisualizationHints().setCursorType(3);
                    DrawingFrame3D.this.drawingPanel.repaint();
                }
            }
        });
        this.cursorMenu.add(this.cursorCrosshairItem);
        this.zoomToFitItem = new JMenuItem("Zoom to fit");
        this.zoomToFitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DrawingFrame3D.this.drawingPanel != null) {
                    DrawingFrame3D.this.drawingPanel.zoomToFit();
                    DrawingFrame3D.this.drawingPanel.repaint();
                }
            }
        });
        this.visualMenu = new JMenu("Visual");
        this.visualMenu.add(this.cameraItem);
        this.visualMenu.add(this.decorationMenu);
        this.visualMenu.add(this.cursorMenu);
        this.visualMenu.add(this.zoomToFitItem);
        this.menuBar.add(this.visualMenu);
        JMenu helpMenu = new JMenu("Help");
        this.menuBar.add(helpMenu);
        JMenuItem aboutItem = new JMenuItem("About...");
        aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlFrame.showAboutDialog(DrawingFrame3D.this);
            }
        });
        helpMenu.add(aboutItem);
    }

    public JMenu getMenuItem(String menuName) {
        menuName = menuName.trim();
        JMenu menu = null;
        for (int i = 0; i < this.menuBar.getMenuCount(); ++i) {
            JMenu next = this.menuBar.getMenu(i);
            if (!next.getText().equals(menuName)) continue;
            menu = next;
            break;
        }
        return menu;
    }

    public JMenu removeMenuItem(String menuName) {
        menuName = menuName.trim();
        JMenu menu = null;
        for (int i = 0; i < this.menuBar.getMenuCount(); ++i) {
            JMenu next = this.menuBar.getMenu(i);
            if (!next.getText().equals(menuName)) continue;
            menu = next;
            this.menuBar.remove(i);
            break;
        }
        return menu;
    }

    public void inspectXML() {
        XMLControlElement xml = null;
        try {
            Method method = this.drawingPanel.getClass().getMethod("getLoader", null);
            if (method != null && Modifier.isStatic(method.getModifiers())) {
                xml = new XMLControlElement(this.drawingPanel);
            }
        }
        catch (NoSuchMethodException ex) {
            return;
        }
        XMLTreePanel treePanel = new XMLTreePanel(xml);
        JDialog dialog = new JDialog((Frame)null, true);
        dialog.setContentPane(treePanel);
        ((Component)dialog).setSize(new Dimension(600, 300));
        ((Component)dialog).setVisible(true);
    }

    public void saveXML() {
        JFileChooser chooser = OSPFrame.getChooser();
        int result = chooser.showSaveDialog(null);
        if (result == 0) {
            int selected;
            File file = chooser.getSelectedFile();
            if (file.exists() && (selected = JOptionPane.showConfirmDialog(null, "Replace existing " + file.getName() + "?", "Replace File", 1)) != 0) {
                return;
            }
            String fileName = XML.getRelativePath(file.getAbsolutePath());
            if (fileName == null || fileName.trim().equals("")) {
                return;
            }
            int i = fileName.toLowerCase().lastIndexOf(".xml");
            if (i != fileName.length() - 4) {
                fileName = fileName + ".xml";
            }
            try {
                Method method = this.drawingPanel.getClass().getMethod("getLoader", null);
                if (method != null && Modifier.isStatic(method.getModifiers())) {
                    XMLControlElement xml = new XMLControlElement(this.drawingPanel);
                    xml.write(fileName);
                }
            }
            catch (NoSuchMethodException ex) {
                return;
            }
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new DrawingFrame3D.Loader();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

