/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementBox;
import org.opensourcephysics.display3d.simple3d.AbstractTile;
import org.opensourcephysics.display3d.simple3d.Resolution;

public class ElementBox
extends AbstractTile
implements org.opensourcephysics.display3d.core.ElementBox {
    private boolean closedBottom = true;
    private boolean closedTop = true;
    private boolean changeNTiles = true;
    private int nx = -1;
    private int ny = -1;
    private int nz = -1;
    private double[][][] standardBox = null;

    public ElementBox() {
        this.getStyle().setResolution(new Resolution(3, 3, 3));
    }

    public void setClosedBottom(boolean close) {
        this.closedBottom = close;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean close) {
        this.closedTop = close;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    protected synchronized void computeCorners() {
        int theNx = 1;
        int theNy = 1;
        int theNz = 1;
        org.opensourcephysics.display3d.core.Resolution res = this.getRealStyle().getResolution();
        if (res != null) {
            switch (res.getType()) {
                case 0: {
                    theNx = Math.max(res.getN1(), 1);
                    theNy = Math.max(res.getN2(), 1);
                    theNz = Math.max(res.getN3(), 1);
                    break;
                }
                case 1: {
                    theNx = Math.max((int)Math.round(0.49 + Math.abs(this.getSizeX()) / res.getMaxLength()), 1);
                    theNy = Math.max((int)Math.round(0.49 + Math.abs(this.getSizeY()) / res.getMaxLength()), 1);
                    theNz = Math.max((int)Math.round(0.49 + Math.abs(this.getSizeZ()) / res.getMaxLength()), 1);
                }
            }
        }
        if (this.nx != theNx || this.ny != theNy || this.nz != theNz || this.changeNTiles) {
            this.nx = theNx;
            this.ny = theNy;
            this.nz = theNz;
            this.changeNTiles = false;
            this.standardBox = ElementBox.createStandardBox(this.nx, this.ny, this.nz, this.closedTop, this.closedBottom);
            this.setCorners(new double[this.standardBox.length][4][3]);
        }
        for (int i = 0; i < this.numberOfTiles; ++i) {
            int sides = this.corners[i].length;
            for (int j = 0; j < sides; ++j) {
                System.arraycopy(this.standardBox[i][j], 0, this.corners[i][j], 0, 3);
                this.sizeAndToSpaceFrame(this.corners[i][j]);
            }
        }
        this.setElementChanged(false);
    }

    private static double[][][] createStandardBox(int nx, int ny, int nz, boolean top, boolean bottom) {
        double theY;
        int j;
        double theX;
        int i;
        int nTotal = 2 * nx * nz + 2 * ny * nz;
        if (bottom) {
            nTotal += nx * ny;
        }
        if (top) {
            nTotal += nx * ny;
        }
        double[][][] data = new double[nTotal][4][3];
        int tile = 0;
        double dx = 1.0 / (double)nx;
        double dy = 1.0 / (double)ny;
        double dz = 1.0 / (double)nz;
        for (i = 0; i < nx; ++i) {
            theX = (double)i * dx - 0.5;
            for (j = 0; j < ny; ++j) {
                theY = (double)j * dy - 0.5;
                if (bottom) {
                    data[tile][0][0] = theX;
                    data[tile][0][1] = theY;
                    data[tile][0][2] = -0.5;
                    data[tile][1][0] = theX + dx;
                    data[tile][1][1] = theY;
                    data[tile][1][2] = -0.5;
                    data[tile][2][0] = theX + dx;
                    data[tile][2][1] = theY + dy;
                    data[tile][2][2] = -0.5;
                    data[tile][3][0] = theX;
                    data[tile][3][1] = theY + dy;
                    data[tile][3][2] = -0.5;
                    ++tile;
                }
                if (!top) continue;
                data[tile][0][0] = theX;
                data[tile][0][1] = theY;
                data[tile][0][2] = 0.5;
                data[tile][1][0] = theX + dx;
                data[tile][1][1] = theY;
                data[tile][1][2] = 0.5;
                data[tile][2][0] = theX + dx;
                data[tile][2][1] = theY + dy;
                data[tile][2][2] = 0.5;
                data[tile][3][0] = theX;
                data[tile][3][1] = theY + dy;
                data[tile][3][2] = 0.5;
                ++tile;
            }
        }
        for (i = 0; i < nx; ++i) {
            theX = (double)i * dx - 0.5;
            for (int k = 0; k < nz; ++k) {
                double theZ = (double)k * dz - 0.5;
                data[tile][0][0] = theX;
                data[tile][0][2] = theZ;
                data[tile][0][1] = -0.5;
                data[tile][1][0] = theX + dx;
                data[tile][1][2] = theZ;
                data[tile][1][1] = -0.5;
                data[tile][2][0] = theX + dx;
                data[tile][2][2] = theZ + dz;
                data[tile][2][1] = -0.5;
                data[tile][3][0] = theX;
                data[tile][3][2] = theZ + dz;
                data[tile][3][1] = -0.5;
                data[++tile][0][0] = theX;
                data[tile][0][2] = theZ;
                data[tile][0][1] = 0.5;
                data[tile][1][0] = theX + dx;
                data[tile][1][2] = theZ;
                data[tile][1][1] = 0.5;
                data[tile][2][0] = theX + dx;
                data[tile][2][2] = theZ + dz;
                data[tile][2][1] = 0.5;
                data[tile][3][0] = theX;
                data[tile][3][2] = theZ + dz;
                data[tile][3][1] = 0.5;
                ++tile;
            }
        }
        for (int k = 0; k < nz; ++k) {
            double theZ = (double)k * dz - 0.5;
            for (j = 0; j < ny; ++j) {
                theY = (double)j * dy - 0.5;
                data[tile][0][2] = theZ;
                data[tile][0][1] = theY;
                data[tile][0][0] = -0.5;
                data[tile][1][2] = theZ + dz;
                data[tile][1][1] = theY;
                data[tile][1][0] = -0.5;
                data[tile][2][2] = theZ + dz;
                data[tile][2][1] = theY + dy;
                data[tile][2][0] = -0.5;
                data[tile][3][2] = theZ;
                data[tile][3][1] = theY + dy;
                data[tile][3][0] = -0.5;
                data[++tile][0][2] = theZ;
                data[tile][0][1] = theY;
                data[tile][0][0] = 0.5;
                data[tile][1][2] = theZ + dz;
                data[tile][1][1] = theY;
                data[tile][1][0] = 0.5;
                data[tile][2][2] = theZ + dz;
                data[tile][2][1] = theY + dy;
                data[tile][2][0] = 0.5;
                data[tile][3][2] = theZ;
                data[tile][3][1] = theY + dy;
                data[tile][3][0] = 0.5;
                ++tile;
            }
        }
        return data;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementBox.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl control) {
            return new ElementBox();
        }
    }
}

