/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementCone;
import org.opensourcephysics.display3d.simple3d.AbstractTile;
import org.opensourcephysics.display3d.simple3d.Resolution;

public class ElementCone
extends AbstractTile
implements org.opensourcephysics.display3d.core.ElementCone {
    private boolean closedBottom = true;
    private boolean closedTop = true;
    private boolean closedLeft = true;
    private boolean closedRight = true;
    private int minAngle = 0;
    private int maxAngle = 360;
    private double truncationHeight = Double.NaN;
    private boolean changeNTiles = true;
    private int nr = -1;
    private int nu = -1;
    private int nz = -1;
    private double[][][] standardCone = null;
    protected static final double TO_RADIANS = Math.PI / 180;
    protected static final double[] vectorx = new double[]{1.0, 0.0, 0.0};
    protected static final double[] vectory = new double[]{0.0, 1.0, 0.0};
    protected static final double[] vectorz = new double[]{0.0, 0.0, 1.0};

    public ElementCone() {
        this.getStyle().setResolution(new Resolution(3, 12, 5));
    }

    public void setTruncationHeight(double height) {
        if (height < 0.0) {
            height = Double.NaN;
        }
        this.truncationHeight = height;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public double getTruncationHeight() {
        return this.truncationHeight;
    }

    public void setClosedBottom(boolean close) {
        this.closedBottom = close;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean close) {
        this.closedTop = close;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    public void setClosedLeft(boolean close) {
        this.closedLeft = close;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedLeft() {
        return this.closedLeft;
    }

    public void setClosedRight(boolean close) {
        this.closedRight = close;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedRight() {
        return this.closedRight;
    }

    public void setMinimumAngle(int angle) {
        this.minAngle = angle;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMinimumAngle() {
        return this.minAngle;
    }

    public void setMaximumAngle(int angle) {
        this.maxAngle = angle;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMaximumAngle() {
        return this.maxAngle;
    }

    protected synchronized void computeCorners() {
        org.opensourcephysics.display3d.core.Resolution res;
        int theNr = 1;
        int theNu = 1;
        int theNz = 1;
        double angle2 = this.maxAngle;
        double angle1 = this.minAngle;
        if (Math.abs(angle2 - angle1) > 360.0) {
            angle2 = angle1 + 360.0;
        }
        if ((res = this.getRealStyle().getResolution()) != null) {
            switch (res.getType()) {
                case 0: {
                    theNr = Math.max(res.getN1(), 1);
                    theNu = Math.max(res.getN2(), 1);
                    theNz = Math.max(res.getN3(), 1);
                    break;
                }
                case 1: {
                    double dx = Math.abs(this.getSizeX()) / 2.0;
                    double dy = Math.abs(this.getSizeY()) / 2.0;
                    double dz = Math.abs(this.getSizeZ());
                    if (!Double.isNaN(this.truncationHeight)) {
                        dz = Math.min(dz, this.truncationHeight);
                    }
                    theNr = Math.max((int)Math.round(0.49 + Math.max(dx, dy) / res.getMaxLength()), 1);
                    theNu = Math.max((int)Math.round(0.49 + Math.abs(angle2 - angle1) * (Math.PI / 180) * (dx + dy) / res.getMaxLength()), 1);
                    theNz = Math.max((int)Math.round(0.49 + dz / res.getMaxLength()), 1);
                }
            }
        }
        if (this.nr != theNr || this.nu != theNu || this.nz != theNz || this.changeNTiles) {
            this.nr = theNr;
            this.nu = theNu;
            this.nz = theNz;
            this.changeNTiles = false;
            double height = this.truncationHeight / this.getSizeZ();
            if (!Double.isNaN(height)) {
                height = Math.min(height, 1.0);
            }
            this.standardCone = ElementCone.createStandardCone(this.nr, this.nu, this.nz, angle1, angle2, this.closedTop, this.closedBottom, this.closedLeft, this.closedRight, height);
            this.setCorners(new double[this.standardCone.length][4][3]);
        }
        for (int i = 0; i < this.numberOfTiles; ++i) {
            int sides = this.corners[i].length;
            for (int j = 0; j < sides; ++j) {
                System.arraycopy(this.standardCone[i][j], 0, this.corners[i][j], 0, 3);
                this.sizeAndToSpaceFrame(this.corners[i][j]);
            }
        }
        this.setElementChanged(false);
    }

    private static double[][][] createStandardCone(int nr, int nu, int nz, double angle1, double angle2, boolean top, boolean bottom, boolean left, boolean right, double height) {
        int totalN = nu * nz;
        if (bottom) {
            totalN += nr * nu;
        }
        if (!Double.isNaN(height) && top) {
            totalN += nr * nu;
        }
        if (Math.abs(angle2 - angle1) < 360.0) {
            if (left) {
                totalN += nr * nz;
            }
            if (right) {
                totalN += nr * nz;
            }
        }
        double[][][] data = new double[totalN][4][3];
        double[] cosu = new double[nu + 1];
        double[] sinu = new double[nu + 1];
        for (int u = 0; u <= nu; ++u) {
            double angle = ((double)(nu - u) * angle1 + (double)u * angle2) * (Math.PI / 180) / (double)nu;
            cosu[u] = Math.cos(angle) / 2.0;
            sinu[u] = Math.sin(angle) / 2.0;
        }
        int tile = 0;
        double[] center = new double[]{-vectorz[0] / 2.0, -vectorz[1] / 2.0, -vectorz[2] / 2.0};
        double N = Double.isNaN(height) ? (double)nz : (height == 0.0 ? 2.147483647E9 : (double)nz / height);
        double aux = 1.0 / N;
        for (int j = 0; j < nz; ++j) {
            int u = 0;
            while (u < nu) {
                for (int k = 0; k < 3; ++k) {
                    data[tile][0][k] = center[k] + (cosu[u] * vectorx[k] + sinu[u] * vectory[k]) * (N - (double)j) / N + (double)j * aux * vectorz[k];
                    data[tile][1][k] = center[k] + (cosu[u + 1] * vectorx[k] + sinu[u + 1] * vectory[k]) * (N - (double)j) / N + (double)j * aux * vectorz[k];
                    data[tile][2][k] = center[k] + (cosu[u + 1] * vectorx[k] + sinu[u + 1] * vectory[k]) * (N - (double)j - 1.0) / N + (double)(j + 1) * aux * vectorz[k];
                    data[tile][3][k] = center[k] + (cosu[u] * vectorx[k] + sinu[u] * vectory[k]) * (N - (double)j - 1.0) / N + (double)(j + 1) * aux * vectorz[k];
                }
                ++u;
                ++tile;
            }
        }
        if (bottom) {
            for (int u = 0; u < nu; ++u) {
                int i = 0;
                while (i < nr) {
                    for (int k = 0; k < 3; ++k) {
                        data[tile][0][k] = ((double)(nr - i) * center[k] + (double)i * data[u][0][k]) / (double)nr;
                        data[tile][1][k] = ((double)(nr - i - 1) * center[k] + (double)(i + 1) * data[u][0][k]) / (double)nr;
                        data[tile][2][k] = ((double)(nr - i - 1) * center[k] + (double)(i + 1) * data[u][1][k]) / (double)nr;
                        data[tile][3][k] = ((double)(nr - i) * center[k] + (double)i * data[u][1][k]) / (double)nr;
                    }
                    ++i;
                    ++tile;
                }
            }
        }
        if (!Double.isNaN(height) && top) {
            int ref = nu * (nz - 1);
            center[0] = vectorz[0];
            center[1] = vectorz[1];
            center[2] = Double.isNaN(height) ? vectorz[2] - 0.5 : height * vectorz[2] - 0.5;
            for (int u = 0; u < nu; ++u) {
                int i = 0;
                while (i < nr) {
                    for (int k = 0; k < 3; ++k) {
                        data[tile][0][k] = ((double)(nr - i) * center[k] + (double)i * data[ref + u][3][k]) / (double)nr;
                        data[tile][1][k] = ((double)(nr - i - 1) * center[k] + (double)(i + 1) * data[ref + u][3][k]) / (double)nr;
                        data[tile][2][k] = ((double)(nr - i - 1) * center[k] + (double)(i + 1) * data[ref + u][2][k]) / (double)nr;
                        data[tile][3][k] = ((double)(nr - i) * center[k] + (double)i * data[ref + u][2][k]) / (double)nr;
                    }
                    ++i;
                    ++tile;
                }
            }
        }
        if (Math.abs(angle2 - angle1) < 360.0) {
            int k;
            int i;
            int j;
            center[0] = -vectorz[0] / 2.0;
            center[1] = -vectorz[1] / 2.0;
            center[2] = -vectorz[2] / 2.0;
            if (right) {
                int ref = 0;
                double[] nextCenter = new double[3];
                double N2 = Double.isNaN(height) ? (double)nz : (height == 0.0 ? 2.147483647E9 : (double)nz / height);
                double aux2 = 1.0 / N2;
                j = 0;
                while (j < nz) {
                    center[0] = (double)j * aux2 * vectorz[0];
                    center[1] = (double)j * aux2 * vectorz[1];
                    center[2] = (double)j * aux2 * vectorz[2] - 0.5;
                    nextCenter[0] = (double)(j + 1) * aux2 * vectorz[0];
                    nextCenter[1] = (double)(j + 1) * aux2 * vectorz[1];
                    nextCenter[2] = (double)(j + 1) * aux2 * vectorz[2] - 0.5;
                    i = 0;
                    while (i < nr) {
                        for (k = 0; k < 3; ++k) {
                            data[tile][0][k] = ((double)(nr - i) * center[k] + (double)i * data[ref][0][k]) / (double)nr;
                            data[tile][1][k] = ((double)(nr - i - 1) * center[k] + (double)(i + 1) * data[ref][0][k]) / (double)nr;
                            data[tile][2][k] = ((double)(nr - i - 1) * nextCenter[k] + (double)(i + 1) * data[ref][3][k]) / (double)nr;
                            data[tile][3][k] = ((double)(nr - i) * nextCenter[k] + (double)i * data[ref][3][k]) / (double)nr;
                        }
                        ++i;
                        ++tile;
                    }
                    ++j;
                    ref += nu;
                }
            }
            if (left) {
                int ref = nu - 1;
                double[] nextCenter = new double[3];
                double N3 = Double.isNaN(height) ? (double)nz : (height == 0.0 ? 2.147483647E9 : (double)nz / height);
                double aux3 = 1.0 / N3;
                j = 0;
                while (j < nz) {
                    center[0] = (double)j * aux3 * vectorz[0];
                    center[1] = (double)j * aux3 * vectorz[1];
                    center[2] = (double)j * aux3 * vectorz[2] - 0.5;
                    nextCenter[0] = (double)(j + 1) * aux3 * vectorz[0];
                    nextCenter[1] = (double)(j + 1) * aux3 * vectorz[1];
                    nextCenter[2] = (double)(j + 1) * aux3 * vectorz[2] - 0.5;
                    i = 0;
                    while (i < nr) {
                        for (k = 0; k < 3; ++k) {
                            data[tile][0][k] = ((double)(nr - i) * center[k] + (double)i * data[ref][1][k]) / (double)nr;
                            data[tile][1][k] = ((double)(nr - i - 1) * center[k] + (double)(i + 1) * data[ref][1][k]) / (double)nr;
                            data[tile][2][k] = ((double)(nr - i - 1) * nextCenter[k] + (double)(i + 1) * data[ref][2][k]) / (double)nr;
                            data[tile][3][k] = ((double)(nr - i) * nextCenter[k] + (double)i * data[ref][2][k]) / (double)nr;
                        }
                        ++i;
                        ++tile;
                    }
                    ++j;
                    ref += nu;
                }
            }
        }
        return data;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected static class Loader
    extends ElementCone.Loader {
        protected Loader() {
        }

        public Object createObject(XMLControl control) {
            return new ElementCone();
        }
    }
}

