/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementCylinder;
import org.opensourcephysics.display3d.simple3d.AbstractTile;
import org.opensourcephysics.display3d.simple3d.Resolution;

public class ElementCylinder
extends AbstractTile
implements org.opensourcephysics.display3d.core.ElementCylinder {
    private boolean closedBottom = true;
    private boolean closedTop = true;
    private boolean closedLeft = true;
    private boolean closedRight = true;
    private int minAngle = 0;
    private int maxAngle = 360;
    private boolean changeNTiles = true;
    private int nr = -1;
    private int nu = -1;
    private int nz = -1;
    private double[][][] standardCylinder = null;
    protected static final double TO_RADIANS = Math.PI / 180;
    protected static final double[] vectorx = new double[]{1.0, 0.0, 0.0};
    protected static final double[] vectory = new double[]{0.0, 1.0, 0.0};
    protected static final double[] vectorz = new double[]{0.0, 0.0, 1.0};

    public ElementCylinder() {
        this.getStyle().setResolution(new Resolution(3, 12, 5));
    }

    public void setClosedBottom(boolean close) {
        this.closedBottom = close;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean close) {
        this.closedTop = close;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    public void setClosedLeft(boolean close) {
        this.closedLeft = close;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedLeft() {
        return this.closedLeft;
    }

    public void setClosedRight(boolean close) {
        this.closedRight = close;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedRight() {
        return this.closedRight;
    }

    public void setMinimumAngle(int angle) {
        this.minAngle = angle;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMinimumAngle() {
        return this.minAngle;
    }

    public void setMaximumAngle(int angle) {
        this.maxAngle = angle;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMaximumAngle() {
        return this.maxAngle;
    }

    protected synchronized void computeCorners() {
        org.opensourcephysics.display3d.core.Resolution res;
        int theNr = 1;
        int theNu = 1;
        int theNz = 1;
        double angle2 = this.maxAngle;
        double angle1 = this.minAngle;
        if (Math.abs(angle2 - angle1) > 360.0) {
            angle2 = angle1 + 360.0;
        }
        if ((res = this.getRealStyle().getResolution()) != null) {
            switch (res.getType()) {
                case 0: {
                    theNr = Math.max(res.getN1(), 1);
                    theNu = Math.max(res.getN2(), 1);
                    theNz = Math.max(res.getN3(), 1);
                    break;
                }
                case 1: {
                    double dx = Math.abs(this.getSizeX()) / 2.0;
                    double dy = Math.abs(this.getSizeY()) / 2.0;
                    theNr = Math.max((int)Math.round(0.49 + Math.max(dx, dy) / res.getMaxLength()), 1);
                    theNu = Math.max((int)Math.round(0.49 + Math.abs(angle2 - angle1) * (Math.PI / 180) * (dx + dy) / res.getMaxLength()), 1);
                    theNz = Math.max((int)Math.round(0.49 + Math.abs(this.getSizeZ()) / res.getMaxLength()), 1);
                }
            }
        }
        if (this.nr != theNr || this.nu != theNu || this.nz != theNz || this.changeNTiles) {
            this.nr = theNr;
            this.nu = theNu;
            this.nz = theNz;
            this.changeNTiles = false;
            this.standardCylinder = ElementCylinder.createStandardCylinder(this.nr, this.nu, this.nz, angle1, angle2, this.closedTop, this.closedBottom, this.closedLeft, this.closedRight);
            this.setCorners(new double[this.standardCylinder.length][4][3]);
        }
        for (int i = 0; i < this.numberOfTiles; ++i) {
            int sides = this.corners[i].length;
            for (int j = 0; j < sides; ++j) {
                System.arraycopy(this.standardCylinder[i][j], 0, this.corners[i][j], 0, 3);
                this.sizeAndToSpaceFrame(this.corners[i][j]);
            }
        }
        this.setElementChanged(false);
    }

    private static double[][][] createStandardCylinder(int nr, int nu, int nz, double angle1, double angle2, boolean top, boolean bottom, boolean left, boolean right) {
        int k;
        int j;
        int totalN = nu * nz;
        if (bottom) {
            totalN += nr * nu;
        }
        if (top) {
            totalN += nr * nu;
        }
        if (Math.abs(angle2 - angle1) < 360.0) {
            if (left) {
                totalN += nr * nz;
            }
            if (right) {
                totalN += nr * nz;
            }
        }
        double[][][] data = new double[totalN][4][3];
        double[] cosu = new double[nu + 1];
        double[] sinu = new double[nu + 1];
        for (int u = 0; u <= nu; ++u) {
            double angle = ((double)(nu - u) * angle1 + (double)u * angle2) * (Math.PI / 180) / (double)nu;
            cosu[u] = Math.cos(angle) / 2.0;
            sinu[u] = Math.sin(angle) / 2.0;
        }
        int tile = 0;
        double[] center = new double[]{-vectorz[0] / 2.0, -vectorz[1] / 2.0, -vectorz[2] / 2.0};
        double aux = 1.0 / (double)nz;
        for (j = 0; j < nz; ++j) {
            int u = 0;
            while (u < nu) {
                for (k = 0; k < 3; ++k) {
                    data[tile][0][k] = center[k] + cosu[u] * vectorx[k] + sinu[u] * vectory[k] + (double)j * aux * vectorz[k];
                    data[tile][1][k] = center[k] + cosu[u + 1] * vectorx[k] + sinu[u + 1] * vectory[k] + (double)j * aux * vectorz[k];
                    data[tile][2][k] = center[k] + cosu[u + 1] * vectorx[k] + sinu[u + 1] * vectory[k] + (double)(j + 1) * aux * vectorz[k];
                    data[tile][3][k] = center[k] + cosu[u] * vectorx[k] + sinu[u] * vectory[k] + (double)(j + 1) * aux * vectorz[k];
                }
                ++u;
                ++tile;
            }
        }
        if (bottom) {
            for (int u = 0; u < nu; ++u) {
                int i = 0;
                while (i < nr) {
                    for (int k2 = 0; k2 < 3; ++k2) {
                        data[tile][0][k2] = ((double)(nr - i) * center[k2] + (double)i * data[u][0][k2]) / (double)nr;
                        data[tile][1][k2] = ((double)(nr - i - 1) * center[k2] + (double)(i + 1) * data[u][0][k2]) / (double)nr;
                        data[tile][2][k2] = ((double)(nr - i - 1) * center[k2] + (double)(i + 1) * data[u][1][k2]) / (double)nr;
                        data[tile][3][k2] = ((double)(nr - i) * center[k2] + (double)i * data[u][1][k2]) / (double)nr;
                    }
                    ++i;
                    ++tile;
                }
            }
        }
        if (top) {
            int ref = nu * (nz - 1);
            center[0] = vectorz[0];
            center[1] = vectorz[1];
            center[2] = vectorz[2] - 0.5;
            for (int u = 0; u < nu; ++u) {
                int i = 0;
                while (i < nr) {
                    for (int k3 = 0; k3 < 3; ++k3) {
                        data[tile][0][k3] = ((double)(nr - i) * center[k3] + (double)i * data[ref + u][3][k3]) / (double)nr;
                        data[tile][1][k3] = ((double)(nr - i - 1) * center[k3] + (double)(i + 1) * data[ref + u][3][k3]) / (double)nr;
                        data[tile][2][k3] = ((double)(nr - i - 1) * center[k3] + (double)(i + 1) * data[ref + u][2][k3]) / (double)nr;
                        data[tile][3][k3] = ((double)(nr - i) * center[k3] + (double)i * data[ref + u][2][k3]) / (double)nr;
                    }
                    ++i;
                    ++tile;
                }
            }
        }
        if (Math.abs(angle2 - angle1) < 360.0) {
            center[0] = -vectorz[0] / 2.0;
            center[1] = -vectorz[1] / 2.0;
            center[2] = -vectorz[2] / 2.0;
            if (right) {
                aux = 1.0 / (double)nz;
                for (j = 0; j < nz; ++j) {
                    int i = 0;
                    while (i < nr) {
                        for (k = 0; k < 3; ++k) {
                            data[tile][0][k] = ((double)(nr - i) * center[k] + (double)i * data[0][0][k]) / (double)nr + (double)j * aux * vectorz[k];
                            data[tile][1][k] = ((double)(nr - i - 1) * center[k] + (double)(i + 1) * data[0][0][k]) / (double)nr + (double)j * aux * vectorz[k];
                            data[tile][2][k] = ((double)(nr - i - 1) * center[k] + (double)(i + 1) * data[0][0][k]) / (double)nr + (double)(j + 1) * aux * vectorz[k];
                            data[tile][3][k] = ((double)(nr - i) * center[k] + (double)i * data[0][0][k]) / (double)nr + (double)(j + 1) * aux * vectorz[k];
                        }
                        ++i;
                        ++tile;
                    }
                }
            }
            if (left) {
                aux = 1.0 / (double)nz;
                int ref = nu - 1;
                for (int j2 = 0; j2 < nz; ++j2) {
                    int i = 0;
                    while (i < nr) {
                        for (int k4 = 0; k4 < 3; ++k4) {
                            data[tile][0][k4] = ((double)(nr - i) * center[k4] + (double)i * data[ref][1][k4]) / (double)nr + (double)j2 * aux * vectorz[k4];
                            data[tile][1][k4] = ((double)(nr - i - 1) * center[k4] + (double)(i + 1) * data[ref][1][k4]) / (double)nr + (double)j2 * aux * vectorz[k4];
                            data[tile][2][k4] = ((double)(nr - i - 1) * center[k4] + (double)(i + 1) * data[ref][1][k4]) / (double)nr + (double)(j2 + 1) * aux * vectorz[k4];
                            data[tile][3][k4] = ((double)(nr - i) * center[k4] + (double)i * data[ref][1][k4]) / (double)nr + (double)(j2 + 1) * aux * vectorz[k4];
                        }
                        ++i;
                        ++tile;
                    }
                }
            }
        }
        return data;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected static class Loader
    extends ElementCylinder.Loader {
        protected Loader() {
        }

        public Object createObject(XMLControl control) {
            return new ElementCylinder();
        }
    }
}

