/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementSegment;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;

public class ElementSegment
extends Element
implements org.opensourcephysics.display3d.core.ElementSegment {
    protected int div = -1;
    protected int[] aCoord = null;
    protected int[] bCoord = null;
    protected Object3D[] objects = null;
    private double[][] points = null;
    private double[] coordinates = new double[3];
    private double[] pixel = new double[3];

    Object3D[] getObjects3D() {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged()) {
            this.computeDivisions();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        return this.objects;
    }

    void draw(Graphics2D _g2, int _index) {
        Color theColor = this.getPanel().projectColor(this.getRealStyle().getLineColor(), this.objects[_index].getDistance());
        _g2.setStroke(this.getRealStyle().getLineStroke());
        _g2.setColor(theColor);
        _g2.drawLine(this.aCoord[_index], this.bCoord[_index], this.aCoord[_index + 1], this.bCoord[_index + 1]);
    }

    synchronized void drawQuickly(Graphics2D _g2) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged()) {
            this.computeDivisions();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        _g2.setStroke(this.getRealStyle().getLineStroke());
        _g2.setColor(this.getRealStyle().getLineColor());
        _g2.drawLine(this.aCoord[0], this.bCoord[0], this.aCoord[this.div], this.bCoord[this.div]);
    }

    void getExtrema(double[] min, double[] max) {
        min[0] = 0.0;
        max[0] = 1.0;
        min[1] = 0.0;
        max[1] = 1.0;
        min[2] = 0.0;
        max[2] = 1.0;
        this.sizeAndToSpaceFrame(min);
        this.sizeAndToSpaceFrame(max);
    }

    protected InteractionTarget getTargetHit(int x, int y) {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged()) {
            this.computeDivisions();
            this.projectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        if (this.targetPosition.isEnabled() && Math.abs(this.aCoord[0] - x) < 5 && Math.abs(this.bCoord[0] - y) < 5) {
            return this.targetPosition;
        }
        if (this.targetSize.isEnabled() && Math.abs(this.aCoord[this.div] - x) < 5 && Math.abs(this.bCoord[this.div] - y) < 5) {
            return this.targetSize;
        }
        return null;
    }

    void projectPoints() {
        for (int i = 0; i < this.div; ++i) {
            this.getPanel().project(this.points[i], this.pixel);
            this.aCoord[i] = (int)this.pixel[0];
            this.bCoord[i] = (int)this.pixel[1];
            for (int j = 0; j < 3; ++j) {
                this.coordinates[j] = (this.points[i][j] + this.points[i + 1][j]) / 2.0;
            }
            this.getPanel().project(this.coordinates, this.pixel);
            this.objects[i].setDistance(this.pixel[2]);
        }
        this.getPanel().project(this.points[this.div], this.pixel);
        this.aCoord[this.div] = (int)this.pixel[0];
        this.bCoord[this.div] = (int)this.pixel[1];
        this.setNeedToProject(false);
    }

    final void computeDivisions() {
        int i;
        int theDiv = 1;
        Resolution res = this.getRealStyle().getResolution();
        if (res != null) {
            switch (res.getType()) {
                case 1: {
                    theDiv = Math.max((int)Math.round(0.49 + this.getDiagonalSize() / res.getMaxLength()), 1);
                    break;
                }
                case 0: {
                    theDiv = Math.max(res.getN1(), 1);
                }
            }
        }
        if (this.div != theDiv) {
            this.div = theDiv;
            this.points = new double[this.div + 1][3];
            this.aCoord = new int[this.div + 1];
            this.bCoord = new int[this.div + 1];
            this.objects = new Object3D[this.div];
            for (int i2 = 0; i2 < this.div; ++i2) {
                this.objects[i2] = new Object3D(this, i2);
            }
        }
        this.points[0][0] = 0.0;
        this.points[0][1] = 0.0;
        this.points[0][2] = 0.0;
        this.points[this.div][0] = 1.0;
        this.points[this.div][1] = 1.0;
        this.points[this.div][2] = 1.0;
        double dx = 1.0 / (double)this.div;
        double dy = 1.0 / (double)this.div;
        double dz = 1.0 / (double)this.div;
        for (i = 1; i < this.div; ++i) {
            this.points[i][0] = (double)i * dx;
            this.points[i][1] = (double)i * dy;
            this.points[i][2] = (double)i * dz;
        }
        for (i = 0; i <= this.div; ++i) {
            this.sizeAndToSpaceFrame(this.points[i]);
        }
        this.setElementChanged(false);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementSegment.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl control) {
            return new ElementSegment();
        }
    }
}

