/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Graphics2D;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.Group;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;

public class Group
extends Element
implements org.opensourcephysics.display3d.core.Group {
    private ArrayList elementList = new ArrayList();
    private ArrayList list3D = new ArrayList();
    private Object3D[] minimalObjects = new Object3D[1];

    public void addElement(org.opensourcephysics.display3d.core.Element element) {
        if (!(element instanceof Element)) {
            throw new UnsupportedOperationException("Can't add element to group (incorrect implementation)");
        }
        if (!this.elementList.contains(element)) {
            this.elementList.add(element);
        }
        ((Element)element).setGroup(this);
    }

    public void addElements(Collection elements) {
        if (elements != null) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof Element)) continue;
                this.addElement((Element)obj);
            }
        }
    }

    public void removeElement(org.opensourcephysics.display3d.core.Element element) {
        ((AbstractCollection)this.elementList).remove(element);
    }

    public void removeAllElements() {
        this.elementList.clear();
    }

    public synchronized ArrayList getElements() {
        return (ArrayList)this.elementList.clone();
    }

    Object3D[] getObjects3D() {
        if (!this.isReallyVisible()) {
            return null;
        }
        this.list3D.clear();
        Iterator it = ((AbstractList)this.elementList).iterator();
        while (it.hasNext()) {
            Object3D[] objects = ((Element)it.next()).getObjects3D();
            if (objects == null) continue;
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                this.list3D.add(objects[i]);
            }
        }
        this.setElementChanged(false);
        if (this.list3D.size() == 0) {
            return null;
        }
        return this.list3D.toArray(this.minimalObjects);
    }

    void draw(Graphics2D _g2, int _index) {
        System.out.println("Group draw (i): I should not be called!");
    }

    void drawQuickly(Graphics2D _g2) {
        Iterator it = ((AbstractList)this.elementList).iterator();
        while (it.hasNext()) {
            ((Element)it.next()).drawQuickly(_g2);
        }
        this.setElementChanged(false);
    }

    void setNeedToProject(boolean _need) {
        Iterator it = ((AbstractList)this.elementList).iterator();
        while (it.hasNext()) {
            ((Element)it.next()).setNeedToProject(_need);
        }
    }

    public void getExtrema(double[] min, double[] max) {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        double[] firstPoint = new double[3];
        double[] secondPoint = new double[3];
        Iterator it = ((AbstractList)this.getElements()).iterator();
        while (it.hasNext()) {
            ((Element)it.next()).getExtrema(firstPoint, secondPoint);
            minX = Math.min(Math.min(minX, firstPoint[0]), secondPoint[0]);
            maxX = Math.max(Math.max(maxX, firstPoint[0]), secondPoint[0]);
            minY = Math.min(Math.min(minY, firstPoint[1]), secondPoint[1]);
            maxY = Math.max(Math.max(maxY, firstPoint[1]), secondPoint[1]);
            minZ = Math.min(Math.min(minZ, firstPoint[2]), secondPoint[2]);
            maxZ = Math.max(Math.max(maxZ, firstPoint[2]), secondPoint[2]);
        }
        min[0] = minX;
        max[0] = maxX;
        min[1] = minY;
        max[1] = maxY;
        min[2] = minZ;
        max[2] = maxZ;
    }

    public InteractionTarget getTargetHit(int x, int y) {
        if (!this.isReallyVisible()) {
            return null;
        }
        Iterator it = ((AbstractList)this.getElements()).iterator();
        while (it.hasNext()) {
            InteractionTarget target = ((Element)it.next()).getTargetHit(x, y);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    boolean getElementChanged() {
        Iterator it = ((AbstractList)this.elementList).iterator();
        while (it.hasNext()) {
            if (!((Element)it.next()).getElementChanged()) continue;
            return true;
        }
        return super.getElementChanged();
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected static class Loader
    extends Group.Loader {
        protected Loader() {
        }

        public Object createObject(XMLControl control) {
            return new Group();
        }
    }
}

