/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.VisualizationHints;
import org.opensourcephysics.display3d.simple3d.DrawingPanel3D;

public class VisualizationHints
implements org.opensourcephysics.display3d.core.VisualizationHints {
    static final int HINT_DECORATION_TYPE = 0;
    static final int HINT_REMOVE_HIDDEN_LINES = 1;
    static final int HINT_ALLOW_QUICK_REDRAW = 2;
    static final int HINT_USE_COLOR_DEPTH = 3;
    static final int HINT_CURSOR_TYPE = 4;
    static final int HINT_SHOW_COORDINATES = 5;
    private boolean removeHiddenLines = true;
    private boolean allowQuickRedraw = true;
    private boolean useColorDepth = true;
    private int cursorType = 1;
    private int showCoordinates = 0;
    private int decorationType = 2;
    private String formatX = "x = 0.00;x = -0.00";
    private String formatY = "y = 0.00;y = -0.00";
    private String formatZ = "z = 0.00;z = -0.00";
    private NumberFormat theFormatX = new DecimalFormat(this.formatX);
    private NumberFormat theFormatY = new DecimalFormat(this.formatY);
    private NumberFormat theFormatZ = new DecimalFormat(this.formatZ);
    private DrawingPanel3D panel;

    VisualizationHints(DrawingPanel3D _panel) {
        this.panel = _panel;
    }

    void setPanel(DrawingPanel3D aPanel) {
        this.panel = aPanel;
    }

    public void setCursorType(int _type) {
        this.cursorType = _type;
        if (this.panel != null) {
            this.panel.hintChanged(4);
        }
    }

    public final int getCursorType() {
        return this.cursorType;
    }

    public void setDecorationType(int _value) {
        this.decorationType = _value;
        if (this.panel != null) {
            this.panel.hintChanged(0);
        }
    }

    public final int getDecorationType() {
        return this.decorationType;
    }

    public void setRemoveHiddenLines(boolean _value) {
        this.removeHiddenLines = _value;
        if (this.panel != null) {
            this.panel.hintChanged(1);
        }
    }

    public final boolean isRemoveHiddenLines() {
        return this.removeHiddenLines;
    }

    public void setAllowQuickRedraw(boolean _value) {
        this.allowQuickRedraw = _value;
        if (this.panel != null) {
            this.panel.hintChanged(2);
        }
    }

    public final boolean isAllowQuickRedraw() {
        return this.allowQuickRedraw;
    }

    public void setUseColorDepth(boolean _value) {
        this.useColorDepth = _value;
        if (this.panel != null) {
            this.panel.hintChanged(3);
        }
    }

    public final boolean isUseColorDepth() {
        return this.useColorDepth;
    }

    public void setShowCoordinates(int location) {
        this.showCoordinates = location;
        if (this.panel != null) {
            this.panel.hintChanged(5);
        }
    }

    public int getShowCoordinates() {
        return this.showCoordinates;
    }

    public void setXFormat(String format) {
        this.formatX = format;
        if (this.formatX != null) {
            this.theFormatX = new DecimalFormat(this.formatX);
        }
    }

    public String getXFormat() {
        return this.formatX;
    }

    public void setYFormat(String format) {
        this.formatY = format;
        if (this.formatY != null) {
            this.theFormatY = new DecimalFormat(this.formatY);
        }
    }

    public String getYFormat() {
        return this.formatY;
    }

    public void setZFormat(String format) {
        this.formatZ = format;
        if (this.formatZ != null) {
            this.theFormatZ = new DecimalFormat(this.formatZ);
        }
    }

    public String getZFormat() {
        return this.formatZ;
    }

    void displayPosition(int projectionMode, double[] point) {
        if (this.showCoordinates < 0) {
            return;
        }
        if (point == null) {
            this.panel.setMessage(null, this.showCoordinates);
            return;
        }
        String text = "";
        switch (projectionMode) {
            case 0: {
                if (this.formatX != null) {
                    text = this.theFormatX.format(point[0]);
                }
                if (this.formatY == null) break;
                text = text + ", " + this.theFormatY.format(point[1]);
                break;
            }
            case 1: {
                if (this.formatX != null) {
                    text = this.theFormatX.format(point[0]);
                }
                if (this.formatZ == null) break;
                text = text + ", " + this.theFormatZ.format(point[2]);
                break;
            }
            case 2: {
                if (this.formatY != null) {
                    text = this.theFormatY.format(point[1]);
                }
                if (this.formatZ == null) break;
                text = text + ", " + this.theFormatZ.format(point[2]);
                break;
            }
            default: {
                if (this.formatX != null) {
                    text = this.theFormatX.format(point[0]);
                }
                if (this.formatY != null) {
                    text = text + ", " + this.theFormatY.format(point[1]);
                }
                if (this.formatZ == null) break;
                text = text + ", " + this.theFormatZ.format(point[2]);
            }
        }
        if (text.startsWith(", ")) {
            text = text.substring(2);
        }
        this.panel.setMessage(text, this.showCoordinates);
    }

    public static XML.ObjectLoader getLoader() {
        return new VisualizationHintsLoader();
    }

    protected static class VisualizationHintsLoader
    extends VisualizationHints.Loader {
        protected VisualizationHintsLoader() {
        }

        public Object createObject(XMLControl control) {
            return new VisualizationHints(null);
        }
    }
}

