/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.opensourcephysics.ejs.Model;
import org.opensourcephysics.ejs.View;

public abstract class Simulation
implements Runnable {
    public static final int MAXIMUM_FPS = 25;
    public static final int MINIMUM_FPS = 1;
    private Model model = null;
    private View view = null;
    private Thread thread = null;
    private boolean autoplay = false;
    private boolean isPlaying = false;
    private long delay = 0L;
    private URL codebase = null;
    private static final String dummy = "";
    private static final Class strClass = "".getClass();
    private static Hashtable memory = new Hashtable();

    private void errorMessage(String _text) {
        System.err.println(this.getClass().getName() + ": " + _text);
    }

    private void errorMessage(Exception _exc) {
        System.err.println(this.getClass().getName() + ": Exception caught! Text follows:");
        _exc.printStackTrace(System.err);
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model _aModel) {
        this.model = _aModel;
    }

    public View getView() {
        return this.view;
    }

    public void setView(View _aView) {
        this.view = _aView;
    }

    public void setCodebase(URL _codebase) {
        this.codebase = _codebase;
    }

    public URL getCodebase() {
        return this.codebase;
    }

    public void play() {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread(this);
        this.thread.setPriority(1);
        this.thread.start();
        this.isPlaying = true;
    }

    public void pause() {
        this.thread = null;
        this.isPlaying = false;
    }

    public void run() {
        while (this.thread == Thread.currentThread()) {
            this.step();
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setFPS(int _fps) {
        this.delay = _fps <= 1 ? 1000L : (_fps >= 25 ? 0L : (long)(1000.0 / (double)_fps));
    }

    public void setDelay(int _aDelay) {
        this.delay = _aDelay < 0 ? 0L : (long)_aDelay;
    }

    public void setAutoplay(boolean _play) {
        this.autoplay = _play;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public boolean isPaused() {
        return !this.isPlaying;
    }

    public void reset() {
        this.pause();
        if (this.model != null) {
            this.model.reset();
            this.model.initialize();
            this.model.update();
        }
        if (this.view != null) {
            this.view.reset();
            this.view.initialize();
            this.view.update();
        }
        System.gc();
        if (this.autoplay) {
            this.play();
        }
    }

    public void initialize() {
        if (this.view != null) {
            this.view.read();
        }
        if (this.model != null) {
            this.model.initialize();
            this.model.update();
        }
        if (this.view != null) {
            this.view.initialize();
            this.view.update();
        }
    }

    public void apply() {
        if (this.view != null) {
            this.view.read();
        }
        this.update();
    }

    public void applyAll() {
        this.view.read();
        this.update();
    }

    public void apply(String _variable) {
        if (this.view != null) {
            this.view.read(_variable);
        }
    }

    public void update() {
        if (this.model != null) {
            this.model.update();
        }
        if (this.view != null) {
            this.view.update();
        }
    }

    public void step() {
        this.model.step();
        this.update();
    }

    public void updateAfterModelAction() {
        this.update();
    }

    public String getVariable(String _name) {
        return this.getVariable(_name, ",");
    }

    public String getVariable(String _name, String _sep) {
        if (this.model == null) {
            return null;
        }
        try {
            Field field = this.model.getClass().getField(_name);
            if (field.getType().isArray()) {
                String txt = dummy;
                Object array = field.get(this.model);
                int l = Array.getLength(array);
                for (int i = 0; i < l; ++i) {
                    txt = i > 0 ? txt + _sep + Array.get(array, i).toString() : txt + Array.get(array, i).toString();
                }
                return txt;
            }
            return field.get(this.model).toString();
        }
        catch (Exception exc) {
            this.errorMessage(exc);
            return null;
        }
    }

    public boolean setVariable(String _name, String _value) {
        return this.setVariable(_name, _value, ",");
    }

    public boolean setVariable(String _variable, String _value, String _sep) {
        if (this.model == null) {
            return false;
        }
        try {
            Field field = this.model.getClass().getField(_variable);
            if (field.getType().isArray()) {
                boolean result = true;
                Object array = field.get(this.model);
                int i = 0;
                int l = Array.getLength(array);
                Class<?> type = field.getType().getComponentType();
                StringTokenizer line = new StringTokenizer(_value, _sep);
                if (l < line.countTokens()) {
                    this.errorMessage("Warning: there are less elements in the array than values provided!");
                } else if (l > line.countTokens()) {
                    this.errorMessage("Warning: there are more elements in the array than values provided!");
                }
                while (line.hasMoreTokens() && i < l) {
                    String token = line.nextToken();
                    if (type.equals(Double.TYPE)) {
                        Array.setDouble(array, i, Double.parseDouble(token));
                    } else if (type.equals(Float.TYPE)) {
                        Array.setFloat(array, i, Float.parseFloat(token));
                    } else if (type.equals(Byte.TYPE)) {
                        Array.setByte(array, i, Byte.parseByte(token));
                    } else if (type.equals(Short.TYPE)) {
                        Array.setShort(array, i, Short.parseShort(token));
                    } else if (type.equals(Integer.TYPE)) {
                        Array.setInt(array, i, Integer.parseInt(token));
                    } else if (type.equals(Long.TYPE)) {
                        Array.setLong(array, i, Long.parseLong(token));
                    } else if (type.equals(Boolean.TYPE)) {
                        if (token.trim().toLowerCase().equals("true")) {
                            Array.setBoolean(array, i, true);
                        } else {
                            Array.setBoolean(array, i, false);
                        }
                    } else if (type.equals(Character.TYPE)) {
                        Array.setChar(array, i, token.charAt(0));
                    } else if (type.equals(strClass)) {
                        Array.set(array, i, token);
                    } else {
                        result = false;
                    }
                    ++i;
                }
                return result;
            }
            Class<?> type = field.getType();
            if (type.equals(Double.TYPE)) {
                field.setDouble(this.model, Double.parseDouble(_value));
            } else if (type.equals(Float.TYPE)) {
                field.setFloat(this.model, Float.parseFloat(_value));
            } else if (type.equals(Byte.TYPE)) {
                field.setByte(this.model, Byte.parseByte(_value));
            } else if (type.equals(Short.TYPE)) {
                field.setShort(this.model, Short.parseShort(_value));
            } else if (type.equals(Integer.TYPE)) {
                field.setInt(this.model, Integer.parseInt(_value));
            } else if (type.equals(Long.TYPE)) {
                field.setLong(this.model, Long.parseLong(_value));
            } else if (type.equals(Boolean.TYPE)) {
                if (_value.trim().toLowerCase().equals("true")) {
                    field.setBoolean(this.model, true);
                } else {
                    field.setBoolean(this.model, false);
                }
            } else if (type.equals(Character.TYPE)) {
                field.setChar(this.model, _value.charAt(0));
            } else if (type.equals(strClass)) {
                field.set(this.model, _value);
            } else {
                return false;
            }
            return true;
        }
        catch (Exception exc) {
            this.errorMessage(exc);
            return false;
        }
    }

    public boolean setVariables(String _valueList) {
        return this.setVariables(_valueList, ";", ",");
    }

    public boolean setVariables(String _valueList, String _sep, String _arraySep) {
        boolean result = true;
        String name = dummy;
        String value = dummy;
        StringTokenizer line = new StringTokenizer(_valueList, _sep);
        while (line.hasMoreTokens()) {
            String token = line.nextToken();
            int index = token.indexOf(61);
            if (index < 0) {
                result = false;
                continue;
            }
            name = token.substring(0, index).trim();
            boolean partial = this.setVariable(name, value = token.substring(index + 1).trim(), _arraySep);
            if (partial) continue;
            result = false;
        }
        this.update();
        return result;
    }

    public boolean saveState(String _filename) {
        if (this.model == null) {
            return false;
        }
        try {
            OutputStream out = _filename.startsWith("ejs:") ? new ByteArrayOutputStream() : new FileOutputStream(_filename);
            BufferedOutputStream bout = new BufferedOutputStream(out);
            ObjectOutputStream dout = new ObjectOutputStream(bout);
            Field[] fields = this.model.getClass().getFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!(fields[i].get(this.model) instanceof Serializable)) continue;
                dout.writeObject(fields[i].get(this.model));
            }
            dout.close();
            if (_filename.startsWith("ejs:")) {
                memory.put(_filename, ((ByteArrayOutputStream)out).toByteArray());
            }
            return true;
        }
        catch (Exception ioe) {
            this.errorMessage("Error when trying to save" + _filename);
            ioe.printStackTrace(System.err);
            return false;
        }
    }

    public boolean readState(String _filename) {
        return this.readState(_filename, null);
    }

    public boolean readState(String _filename, URL _codebase) {
        if (this.model == null) {
            return false;
        }
        try {
            InputStream in;
            if (_filename.startsWith("ejs:")) {
                in = new ByteArrayInputStream((byte[])memory.get(_filename));
            } else if (_filename.startsWith("url:")) {
                String url = _filename.substring(4);
                if (_codebase != null && !url.startsWith("http:")) {
                    url = _codebase + url;
                }
                in = new URL(url).openStream();
            } else {
                in = new FileInputStream(_filename);
            }
            BufferedInputStream bin = new BufferedInputStream(in);
            ObjectInputStream din = new ObjectInputStream(bin);
            Field[] fields = this.model.getClass().getFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!(fields[i].get(this.model) instanceof Serializable)) continue;
                fields[i].set(this.model, din.readObject());
            }
            din.close();
            if (this.view != null) {
                this.view.initialize();
            }
            this.update();
            return true;
        }
        catch (Exception ioe) {
            this.errorMessage("Error when trying to read " + _filename);
            ioe.printStackTrace(System.err);
            return false;
        }
    }
}

