/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.opensourcephysics.ejs.Simulation;
import org.opensourcephysics.ejs.control.ConstantParser;
import org.opensourcephysics.ejs.control.GroupControl;
import org.opensourcephysics.ejs.control.GroupVariable;
import org.opensourcephysics.ejs.control.MethodWithOneParameter;
import org.opensourcephysics.ejs.control.Utils;
import org.opensourcephysics.ejs.control.value.BooleanValue;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.ExpressionValue;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.ObjectValue;
import org.opensourcephysics.ejs.control.value.StringValue;
import org.opensourcephysics.ejs.control.value.Value;
import org.opensourcephysics.tools.TranslatorTool;

public abstract class ControlElement {
    protected GroupControl myGroup = null;
    protected Hashtable myPropertiesTable = new Hashtable();
    protected Object myObject = null;
    private boolean myActiveState = true;
    private Vector myActionsList = new Vector();
    private GroupVariable[] myProperties = null;
    private String[] myPropertiesNames = null;
    protected boolean isUnderEjs = false;
    MethodWithOneParameter[] myMethodsForProperties = null;
    ExpressionValue[] myExpressionsForProperties = null;
    public static final int NAME = 0;
    public static final int ACTION = 0;
    public static final int VARIABLE_CHANGED = 1;
    public static final int METHOD_FOR_VARIABLE = 2;
    public static final String METHOD_TRIGGER = "_expr_";

    public ControlElement(Object _object) {
        ArrayList info = this.getPropertyList();
        this.myObject = _object;
        this.myPropertiesNames = new String[info.size()];
        this.myProperties = new GroupVariable[info.size()];
        this.myMethodsForProperties = new MethodWithOneParameter[info.size()];
        this.myExpressionsForProperties = new ExpressionValue[info.size()];
        for (int i = 0; i < info.size(); ++i) {
            String property;
            this.myPropertiesNames[i] = property = (String)info.get(i);
            this.myProperties[i] = null;
            this.myMethodsForProperties[i] = null;
            this.myExpressionsForProperties[i] = null;
        }
    }

    public Object getObject() {
        return this.myObject;
    }

    public abstract ArrayList getPropertyList();

    public abstract String getPropertyInfo(String var1);

    public Value parseConstant(String _propertyType, String _value) {
        Value constantValue;
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("boolean") >= 0 && (constantValue = ConstantParser.booleanConstant(_value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Color") >= 0 && (constantValue = ConstantParser.colorConstant(_value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("File") >= 0) {
            String codebase = null;
            if (this.getProperty("_ejs_codebase") != null) {
                codebase = this.getProperty("_ejs_codebase");
            } else if (this.getSimulation() != null && this.getSimulation().getCodebase() != null) {
                codebase = this.getSimulation().getCodebase().toString();
            }
            if (Utils.fileExists(codebase, _value)) {
                return new StringValue(_value);
            }
        }
        if (_propertyType.indexOf("Font") >= 0) {
            Font currentFont = null;
            if (this.getVisual() != null) {
                currentFont = this.getVisual().getFont();
            }
            if ((constantValue = ConstantParser.fontConstant(currentFont, _value)) != null) {
                return constantValue;
            }
        }
        if (_propertyType.indexOf("Format") >= 0 && (constantValue = ConstantParser.formatConstant(_value)) != null) {
            return constantValue;
        }
        if ((_propertyType.indexOf("Margins") >= 0 || _propertyType.indexOf("Rectangle") >= 0) && (constantValue = ConstantParser.rectangleConstant(_value)) != null) {
            return constantValue;
        }
        return null;
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (this.myGroup == null) break;
                this.myGroup.rename(this, _value.toString());
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                if (this.myGroup == null) break;
                this.myGroup.rename(this, null);
            }
        }
    }

    public Value getValue(int _index) {
        return null;
    }

    public ControlElement setProperty(String _property, String _value) {
        int index;
        if ((_property = _property.trim()).equals("_ejs_")) {
            this.isUnderEjs = true;
        }
        if ((index = this.propertyIndex(_property)) < 0) {
            if (_value == null) {
                this.myPropertiesTable.remove(_property);
            } else {
                this.myPropertiesTable.put(_property, _value);
            }
            return this;
        }
        this.myMethodsForProperties[index] = null;
        this.myExpressionsForProperties[index] = null;
        if (this.myProperties[index] != null) {
            this.myProperties[index].removeElementListener(this, index);
            this.myProperties[index] = null;
        }
        if (_value == null) {
            if (this.myProperties[index] != null) {
                this.myProperties[index].removeElementListener(this, index);
                this.myProperties[index] = null;
            }
            this.setDefaultValue(index);
            this.myPropertiesTable.remove(_property);
            return this;
        }
        if (!this.propertyIsTypeOf(_property, "NotTrimmed")) {
            _value = _value.trim();
        }
        String originalValue = _value;
        Value constantValue = null;
        if (_value.startsWith("%") && _value.endsWith("%") && _value.length() > 2) {
            _value = _value.substring(1, _value.length() - 1);
        } else if (!(_value.startsWith("@") && _value.endsWith("@") && _value.length() > 2 || _value.startsWith("#") && _value.endsWith("#") && _value.length() > 2)) {
            if (!_value.startsWith("\"") && !_value.startsWith("'")) {
                if (this.propertyIsTypeOf(_property, "CONSTANT")) {
                    constantValue = new StringValue(_value);
                }
                if (constantValue == null && this.propertyType(_property).equals("String") && !this.propertyIsTypeOf(_property, "VARIABLE_EXPECTED")) {
                    constantValue = new StringValue(_value);
                }
            }
            if (constantValue == null) {
                constantValue = this.parseConstant(this.propertyType(_property), _value);
            }
            if (constantValue == null) {
                constantValue = Value.parseConstantOrArray(_value, true);
            }
        }
        if (constantValue != null) {
            if (constantValue instanceof StringValue && this.propertyIsTypeOf(_property, "TRANSLATABLE")) {
                Object target = null;
                if (this.myGroup != null) {
                    target = this.myGroup.getTarget("_default_");
                }
                String translated = TranslatorTool.getProperty(target.getClass(), constantValue.getString());
                if (!constantValue.getString().equals(translated)) {
                    constantValue = new StringValue(translated);
                }
            }
            this.setValue(index, constantValue);
        } else if (this.myGroup != null) {
            boolean isNormalVariable = true;
            boolean isExpression = false;
            if (_value.startsWith("#") && _value.endsWith("#") && _value.length() > 2) {
                _value = _value.substring(1, _value.length() - 1);
                isNormalVariable = true;
            } else if (_value.startsWith("@") && _value.endsWith("@") && _value.length() > 2) {
                originalValue = _value = _value.substring(1, _value.length() - 1);
                isNormalVariable = false;
                isExpression = true;
            } else if (_value.indexOf(40) >= 0) {
                isNormalVariable = false;
            }
            if (isNormalVariable) {
                Value newValue = null;
                if (this.getProperty("_ejs_") == null) {
                    newValue = this.getValue(index);
                }
                if (newValue == null) {
                    newValue = this.propertyIsTypeOf(_property, "double") ? new DoubleValue(0.0) : (this.propertyIsTypeOf(_property, "boolean") ? new BooleanValue(false) : (this.propertyIsTypeOf(_property, "int") ? new IntegerValue(0) : (this.propertyIsTypeOf(_property, "String") ? new StringValue(_value) : new ObjectValue(null))));
                }
                this.myProperties[index] = this.myGroup.registerVariable(_value, this, index, newValue);
            } else if (isExpression) {
                String returnType = null;
                if (this.propertyIsTypeOf(_property, "double")) {
                    returnType = "double";
                } else if (this.propertyIsTypeOf(_property, "boolean")) {
                    returnType = "boolean";
                } else if (this.propertyIsTypeOf(_property, "int")) {
                    returnType = "int";
                } else if (this.propertyIsTypeOf(_property, "String")) {
                    returnType = "String";
                } else if (this.propertyIsTypeOf(_property, "Action")) {
                    returnType = "Action";
                } else {
                    System.out.println("Error for property " + _property + " of the element " + this.toString() + ". Cannot be set to : " + originalValue);
                    this.myPropertiesTable.put(_property, originalValue);
                    return this;
                }
                if (!returnType.equals("Action")) {
                    this.myExpressionsForProperties[index] = new ExpressionValue(_value, this.myGroup);
                    this.myGroup.methodTriggerVariable.addElementListener(this, index);
                    this.myProperties[index] = this.myGroup.methodTriggerVariable;
                }
            } else if (this.getProperty("_ejs_") == null) {
                Object target;
                String returnType = null;
                if (this.propertyIsTypeOf(_property, "double")) {
                    returnType = "double";
                } else if (this.propertyIsTypeOf(_property, "boolean")) {
                    returnType = "boolean";
                } else if (this.propertyIsTypeOf(_property, "int")) {
                    returnType = "int";
                } else if (this.propertyIsTypeOf(_property, "String")) {
                    returnType = "String";
                } else {
                    System.out.println("Error for property " + _property + " of the element " + this.toString() + ". Cannot be set to : " + originalValue);
                    this.myPropertiesTable.put(_property, originalValue);
                    return this;
                }
                String[] parts = MethodWithOneParameter.splitMethodName(_value);
                if (parts == null) {
                    System.err.println(this.getClass().getName() + " : Error! method <" + originalValue + "> not found");
                    this.myPropertiesTable.put(_property, originalValue);
                    return this;
                }
                if (parts[0] == null) {
                    parts[0] = "_default_";
                }
                if ((target = this.myGroup.getTarget(parts[0])) == null) {
                    System.err.println(this.getClass().getName() + " : Error! Target <" + parts[0] + "> not assigned");
                    this.myPropertiesTable.put(_property, originalValue);
                    return this;
                }
                _value = parts[2] == null ? parts[1] + "()" : parts[1] + "(" + parts[2] + ")";
                this.myMethodsForProperties[index] = new MethodWithOneParameter(2, target, _value, returnType, null, this);
                this.myGroup.methodTriggerVariable.addElementListener(this, index);
                this.myProperties[index] = this.myGroup.methodTriggerVariable;
            }
        }
        this.myPropertiesTable.put(_property, originalValue);
        return this;
    }

    public final ControlElement setProperties(String _propertyList) {
        Hashtable<String, String> propTable = new Hashtable<String, String>();
        StringTokenizer tkn = new StringTokenizer(_propertyList, ";");
        while (tkn.hasMoreTokens()) {
            String token = tkn.nextToken();
            if (token.trim().length() <= 0) continue;
            int index = token.indexOf("=");
            if (index < 0) {
                System.err.println(this.getClass().getName() + " : Error! Token <" + token + "> invalid for " + this.toString());
                continue;
            }
            propTable.put(token.substring(0, index).trim(), token.substring(index + 1));
        }
        return this.setProperties(propTable);
    }

    private void preprocess(String _property, Hashtable _propertyTable) {
        String value = (String)_propertyTable.get(_property);
        if (value != null) {
            this.setProperty(_property, value);
            _propertyTable.remove(_property);
        }
    }

    private ControlElement setProperties(Hashtable _propertyTable) {
        String key;
        this.preprocess("_ejs_", _propertyTable);
        Hashtable<String, String> postTable = new Hashtable<String, String>();
        Enumeration e = _propertyTable.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (this.propertyIsTypeOf(key, "PREVIOUS")) {
                this.preprocess(key, _propertyTable);
                continue;
            }
            if (!this.propertyIsTypeOf(key, "POSTPROCESS")) continue;
            String value = (String)_propertyTable.get(key);
            _propertyTable.remove(key);
            postTable.put(key, value);
        }
        e = _propertyTable.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            this.setProperty(key, (String)_propertyTable.get(key));
        }
        e = postTable.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            this.setProperty(key, (String)postTable.get(key));
        }
        return this;
    }

    public final String getProperty(String _property) {
        return (String)this.myPropertiesTable.get(_property);
    }

    public final boolean propertyIsTypeOf(String _property, String _keyword) {
        String info = this.getPropertyInfo(_property);
        if (info == null) {
            return false;
        }
        return info.toLowerCase().indexOf(_keyword.toLowerCase()) >= 0;
    }

    public final String propertyType(String _property) {
        String info = this.getPropertyInfo(_property);
        if (info == null) {
            return "double";
        }
        StringTokenizer tkn = new StringTokenizer(info, " ");
        if (tkn.countTokens() >= 1) {
            return tkn.nextToken();
        }
        return "double";
    }

    public Component getComponent() {
        return null;
    }

    public Component getVisual() {
        return null;
    }

    public void reset() {
    }

    public void initialize() {
    }

    private int propertyIndex(String _property) {
        if (this.myPropertiesNames != null) {
            for (int i = 0; i < this.myPropertiesNames.length; ++i) {
                if (!this.myPropertiesNames[i].equals(_property)) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean implementsProperty(String _property) {
        return this.propertyIndex(_property) >= 0;
    }

    public final void variablePropertiesClear() {
        if (this.myPropertiesNames != null) {
            for (int i = 0; i < this.myPropertiesNames.length; ++i) {
                this.setProperty(this.myPropertiesNames[i], null);
            }
        }
    }

    public String toString() {
        String name = (String)this.myPropertiesTable.get("name");
        if (name != null) {
            return name;
        }
        String text = this.getClass().getName();
        int index = text.lastIndexOf(".");
        if (index >= 0) {
            text = text.substring(index + 1);
        }
        return "Unnamed element of type " + text;
    }

    public void destroy() {
        this.setProperty("parent", null);
        if (this.myProperties != null) {
            for (int i = 0; i < this.myProperties.length; ++i) {
                if (this.myProperties[i] == null) continue;
                this.myProperties[i].removeElementListener(this, i);
            }
        }
    }

    public final ControlElement addAction(int _type, Object _target, String _method) {
        this.myActionsList.addElement(new MethodWithOneParameter(_type, _target, _method, null, null, this));
        return this;
    }

    public final ControlElement addAction(int _type, Object _target, String _method, MethodWithOneParameter _secondAction) {
        this.myActionsList.addElement(new MethodWithOneParameter(_type, _target, _method, null, _secondAction, this));
        return this;
    }

    public final ControlElement addAction(int _type, String _method) {
        if (this.getProperty("_ejs_") != null) {
            _method = "_ejs_.execute(\"" + _method + "\")";
        }
        Object target = null;
        MethodWithOneParameter secondAction = null;
        String[] parts = MethodWithOneParameter.splitMethodName(_method);
        if (parts == null) {
            System.err.println(this.getClass().getName() + " : Error! Method <" + _method + "> not assigned");
            return this;
        }
        if (parts[0] == null) {
            parts[0] = "_default_";
        }
        if (this.myGroup != null) {
            target = this.myGroup.getTarget(parts[0]);
            if (_type == 0 && this.getProperty("_ejs_SecondAction_") != null && this.myGroup.getTarget("_default_") != null) {
                secondAction = new MethodWithOneParameter(_type, this.myGroup.getTarget("_default_"), this.getProperty("_ejs_SecondAction_"), null, null, this);
            }
        }
        if (target == null) {
            System.err.println(this.getClass().getName() + " : Error! Target <" + parts[0] + "> not assigned");
            return this;
        }
        if (parts[2] == null) {
            return this.addAction(_type, target, parts[1] + "()", secondAction);
        }
        return this.addAction(_type, target, parts[1] + "(" + parts[2] + ")", secondAction);
    }

    public final void removeAction(int _type, Object _target, String _method) {
        if (_method == null) {
            return;
        }
        Enumeration e = this.myActionsList.elements();
        while (e.hasMoreElements()) {
            MethodWithOneParameter meth = (MethodWithOneParameter)e.nextElement();
            if (!meth.equals(_type, _target, _method)) continue;
            if (!this.myActionsList.removeElement(meth)) {
                System.err.println(this.getClass().getName() + ": Error! Action " + _method + " not removed");
            }
            return;
        }
    }

    public final void removeAction(int _type, String _method) {
        String[] parts;
        if (_method == null) {
            return;
        }
        if (this.getProperty("_ejs_") != null) {
            _method = "_ejs_.execute(\"" + _method + "\")";
        }
        if ((parts = MethodWithOneParameter.splitMethodName(_method)) == null) {
            System.err.println(this.getClass().getName() + " : Error! Method <" + _method + "> not removed");
            return;
        }
        if (parts[0] == null) {
            parts[0] = "_default_";
        }
        Object target = null;
        if (this.myGroup != null) {
            target = this.myGroup.getTarget(parts[0]);
        }
        if (target == null) {
            System.err.println(this.getClass().getName() + " : Error! Target <" + parts[0] + "> not assigned");
            return;
        }
        this.removeAction(_type, target, parts[1] + "(" + parts[2] + ")");
    }

    public final void invokeActions() {
        this.invokeActions(0);
    }

    public final void invokeActions(int _type) {
        if (this.myActiveState) {
            Enumeration e = this.myActionsList.elements();
            while (e.hasMoreElements()) {
                ((MethodWithOneParameter)e.nextElement()).invoke(_type, this);
            }
        }
    }

    public final void variableChangedDoNotUpdate(int _variableIndex, Value _value) {
        if (this.myGroup != null && this.myProperties != null) {
            this.myGroup.variableChanged(this.myProperties[_variableIndex], this, _value);
        }
        if (this.myActiveState) {
            Enumeration e = this.myActionsList.elements();
            while (e.hasMoreElements()) {
                MethodWithOneParameter method = (MethodWithOneParameter)e.nextElement();
                method.invoke(1, this);
            }
        }
    }

    public final void variableChanged(int _variableIndex, Value _value) {
        if (this.myMethodsForProperties[_variableIndex] != null) {
            return;
        }
        this.variableChangedDoNotUpdate(_variableIndex, _value);
        if (this.myGroup != null && this.myGroup.getSimulation() != null) {
            this.myGroup.getSimulation().update();
        }
    }

    public final void variablesChanged(int[] _variableIndex, Value[] _value) {
        boolean doMore = false;
        if (this.myGroup != null && this.myProperties != null) {
            for (int i = 0; i < _variableIndex.length; ++i) {
                if (this.myMethodsForProperties[_variableIndex[i]] != null) continue;
                this.myGroup.variableChanged(this.myProperties[_variableIndex[i]], this, _value[i]);
                doMore = true;
            }
        }
        if (!doMore) {
            return;
        }
        if (this.myActiveState) {
            Enumeration e = this.myActionsList.elements();
            while (e.hasMoreElements()) {
                MethodWithOneParameter method = (MethodWithOneParameter)e.nextElement();
                method.invoke(1, this);
            }
        }
        if (this.myGroup != null && this.myGroup.getSimulation() != null) {
            this.myGroup.getSimulation().update();
        }
    }

    public final void setActive(boolean _act) {
        this.myActiveState = _act;
    }

    public final boolean isActive() {
        return this.myActiveState;
    }

    public final void setGroup(GroupControl _group) {
        this.myGroup = _group;
    }

    public final GroupControl getGroup() {
        return this.myGroup;
    }

    public final Simulation getSimulation() {
        if (this.myGroup == null) {
            return null;
        }
        return this.myGroup.getSimulation();
    }
}

