/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import java.awt.Frame;
import java.util.Collection;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.ParsableTextArea;
import org.opensourcephysics.controls.VariableNotFoundException;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.GroupControl;
import org.opensourcephysics.ejs.control.swing.ControlInputArea;
import org.opensourcephysics.ejs.control.swing.ControlTextArea;
import org.opensourcephysics.ejs.control.value.StringValue;
import org.opensourcephysics.ejs.control.value.Value;

public class EjsControl
extends GroupControl
implements Control {
    static String _RETURN_ = System.getProperty("line.separator");
    private ControlTextArea messageArea = null;
    private ParsableTextArea inputArea = null;
    private StringValue strValue = new StringValue("");

    public EjsControl(Object _simulation) {
        super(_simulation);
    }

    public EjsControl(Object _simulation, String _replaceName, Frame _replaceOwnerFrame) {
        super(_simulation, _replaceName, _replaceOwnerFrame);
    }

    public EjsControl() {
    }

    public ControlElement addObject(Object _object, String _classname, String _propList) {
        ControlElement control = super.addObject(_object, _classname, _propList);
        if (control instanceof ControlTextArea) {
            this.messageArea = (ControlTextArea)control;
        } else if (control instanceof ControlInputArea) {
            this.inputArea = (ParsableTextArea)((ControlInputArea)control).getVisual();
        }
        return control;
    }

    public void reset() {
        this.clearValues();
        this.clearMessages();
        super.reset();
    }

    public void setLockValues(boolean lock) {
    }

    public Collection getPropertyNames() {
        return this.variableTable.keySet();
    }

    public void clearValues() {
        if (this.inputArea != null) {
            this.inputArea.setText("");
            this.inputArea.setCaretPosition(this.inputArea.getText().length());
        }
    }

    public void clearMessages() {
        if (this.messageArea != null) {
            this.messageArea.clear();
        }
    }

    public void println(String s) {
        this.print(s + _RETURN_);
    }

    public void println() {
        this.println("");
    }

    public void print(String s) {
        if (this.messageArea != null) {
            this.messageArea.print(s);
        } else {
            System.out.print(s);
        }
    }

    public void calculationDone(String message) {
        this.println(message);
    }

    public void setValue(String _variable, Value _value) {
        if (!this.isVariableRegistered(_variable) && this.inputArea != null) {
            this.inputArea.setValue(_variable, _value.getString());
        } else {
            super.setValue(_variable, _value);
        }
    }

    public Value getValue(String _variable) {
        if (!this.isVariableRegistered(_variable) && this.inputArea != null) {
            try {
                this.strValue.value = this.inputArea.getValue(_variable);
                return this.strValue;
            }
            catch (VariableNotFoundException variableNotFoundException) {
                // empty catch block
            }
        }
        return super.getValue(_variable);
    }
}

