/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.controls.ControlFrame;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.OSPApplication;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.ejs.EjsRes;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.ParsedEjsControl;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.TranslatorTool;

public class EjsControlFrame
extends ParsedEjsControl
implements RootPaneContainer {
    static final int MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    protected JMenuItem[] languageItems;
    protected JMenuItem translateItem;
    protected JMenu languageMenu;
    OSPFrame frame = new OSPFrame(){

        public void render() {
            EjsControlFrame.this.render();
        }

        public void clearData() {
            EjsControlFrame.this.clearData();
        }

        public void clearDataAndRepaint() {
            EjsControlFrame.this.clearDataAndRepaint();
        }
    };
    DrawingPanel defaultDrawingPanel;
    JFrame messageFrame = new JFrame(EjsRes.getString("EjsControlFrame.Messages_frame_title"));
    TextArea messageArea = new TextArea(20, 20);
    Object model;
    JMenuBar menuBar;
    protected XMLControlElement xmlDefault;
    protected PropertyChangeSupport support = new SwingPropertyChangeSupport(this);
    protected OSPApplication app;
    static /* synthetic */ Class class$org$opensourcephysics$controls$OSPApplication;
    static /* synthetic */ Class class$org$opensourcephysics$tools$LaunchNode;

    public EjsControlFrame(Object _simulation) {
        this(_simulation, "name=controlFrame;title=Control Frame;location=400,0;layout=border;exit=false; visible=true");
    }

    public EjsControlFrame(Object _simulation, String param) {
        super(_simulation);
        this.model = _simulation;
        this.frame.setName("controlFrame");
        this.addObject(this.frame, "Frame", param);
        this.createMenuBar();
        if (OSPFrame.appletMode) {
            this.frame.setDefaultCloseOperation(1);
        }
        this.messageFrame.getContentPane().add(this.messageArea);
        ((Component)this.messageFrame).setSize(300, 175);
    }

    private void createMenuBar() {
        this.menuBar = new JMenuBar();
        this.frame.setJMenuBar(this.menuBar);
        JMenu fileMenu = new JMenu(EjsRes.getString("EjsControlFrame.File_menu"));
        this.menuBar.add(fileMenu);
        JMenuItem readItem = new JMenuItem(EjsRes.getString("EjsControlFrame.Read_menu_item"));
        JMenuItem saveAsItem = new JMenuItem(EjsRes.getString("EjsControlFrame.SaveAs_menu_item"));
        JMenuItem inspectItem = new JMenuItem(EjsRes.getString("EjsControlFrame.Inspect_menu_item"));
        fileMenu.add(readItem);
        fileMenu.add(saveAsItem);
        fileMenu.add(inspectItem);
        readItem.setAccelerator(KeyStroke.getKeyStroke(82, MENU_SHORTCUT_KEY_MASK));
        readItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EjsControlFrame.this.loadXML((String)null);
                EjsControlFrame.this.support.firePropertyChange("xmlDefault", null, EjsControlFrame.this.xmlDefault);
                EjsControlFrame.this.frame.repaint();
            }
        });
        saveAsItem.setAccelerator(KeyStroke.getKeyStroke(83, MENU_SHORTCUT_KEY_MASK));
        saveAsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EjsControlFrame.this.saveXML();
            }
        });
        inspectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EjsControlFrame.this.inspectXML();
            }
        });
        this.loadDisplayMenu();
        JMenu helpMenu = new JMenu(EjsRes.getString("EjsControlFrame.Help_menu"));
        this.menuBar.add(helpMenu);
        JMenuItem aboutItem = new JMenuItem(EjsRes.getString("EjsControlFrame.About_menu_item"));
        aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlFrame.showAboutDialog(EjsControlFrame.this.getFrame());
            }
        });
        helpMenu.add(aboutItem);
        JMenuItem sysItem = new JMenuItem(EjsRes.getString("EjsControlFrame.System_menu_item"));
        sysItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlUtils.showSystemProperties(true);
            }
        });
        helpMenu.add(sysItem);
        helpMenu.addSeparator();
        JCheckBoxMenuItem logToFileItem = new JCheckBoxMenuItem(EjsRes.getString("EjsControlFrame.LogToFile_check_box"));
        logToFileItem.setSelected(false);
        logToFileItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                OSPLog.getOSPLog().setLogToFile(item.isSelected());
            }
        });
        helpMenu.add(logToFileItem);
        JMenuItem logItem = new JMenuItem(EjsRes.getString("EjsControlFrame.MessageLog_menu_item"));
        logItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OSPLog.getOSPLog().setVisible(true);
            }
        });
        helpMenu.add(logItem);
        this.menuBar.add(helpMenu);
    }

    protected void loadDisplayMenu() {
        int i;
        JMenu displayMenu = new JMenu();
        displayMenu.setText(EjsRes.getString("EjsControlFrame.Display_menu"));
        this.menuBar.add(displayMenu);
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                EjsControlFrame.this.refreshGUI();
            }
        });
        this.languageMenu = new JMenu();
        this.languageMenu.setText(EjsRes.getString("EjsControlFrame.Language"));
        this.translateItem = new JMenuItem();
        this.translateItem.setText(EjsRes.getString("EjsControlFrame.Translate"));
        this.translateItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TranslatorTool tool = TranslatorTool.getTool();
                tool.showProperties(EjsControlFrame.this.model.getClass());
                tool.setKeepHidden(false);
                tool.setVisible(true);
            }
        });
        this.languageMenu.add((Component)this.translateItem, 0);
        final Locale[] locales = OSPFrame.getDefaultLocales();
        AbstractAction languageAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                String language = e.getActionCommand();
                OSPLog.finest("setting language to " + language);
                for (int i = 0; i < locales.length; ++i) {
                    if (!language.equals(locales[i].getDisplayName())) continue;
                    ToolsRes.setLocale(locales[i]);
                    return;
                }
            }
        };
        ButtonGroup languageGroup = new ButtonGroup();
        this.languageItems = new JMenuItem[locales.length];
        for (i = 0; i < locales.length; ++i) {
            this.languageItems[i] = new JRadioButtonMenuItem(locales[i].getDisplayName(locales[i]));
            this.languageItems[i].setActionCommand(locales[i].getDisplayName());
            this.languageItems[i].addActionListener(languageAction);
            this.languageMenu.add(this.languageItems[i]);
            languageGroup.add(this.languageItems[i]);
        }
        for (i = 0; i < locales.length; ++i) {
            if (!locales[i].getLanguage().equals(ToolsRes.getLanguage())) continue;
            this.languageItems[i].setSelected(true);
        }
        displayMenu.add(this.languageMenu);
        JMenu fontMenu = new JMenu(EjsRes.getString("EjsControlFrame.Font_menu"));
        displayMenu.add(fontMenu);
        JMenuItem sizeUpItem = new JMenuItem();
        sizeUpItem.setText(EjsRes.getString("EjsControlFrame.IncreaseFontSize_menu_item"));
        sizeUpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontSizer.levelUp();
            }
        });
        fontMenu.add(sizeUpItem);
        final JMenuItem sizeDownItem = new JMenuItem();
        sizeDownItem.setText(EjsRes.getString("EjsControlFrame.DecreaseFontSize_menu_item"));
        sizeDownItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontSizer.levelDown();
            }
        });
        fontMenu.add(sizeDownItem);
        JMenu aliasMenu = new JMenu(EjsRes.getString("EjsControlFrame.AntiAlias_menu"));
        displayMenu.add(aliasMenu);
        final JCheckBoxMenuItem textAliasItem = new JCheckBoxMenuItem(EjsRes.getString("EjsControlFrame.Text_check_box"), false);
        textAliasItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EjsControlFrame.this.defaultDrawingPanel.setAntialiasTextOn(textAliasItem.isSelected());
                EjsControlFrame.this.defaultDrawingPanel.repaint();
            }
        });
        aliasMenu.add(textAliasItem);
        final JCheckBoxMenuItem shapeAliasItem = new JCheckBoxMenuItem(EjsRes.getString("EjsControlFrame.Drawing_check_box"), false);
        shapeAliasItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EjsControlFrame.this.defaultDrawingPanel.setAntialiasShapeOn(shapeAliasItem.isSelected());
                EjsControlFrame.this.defaultDrawingPanel.repaint();
            }
        });
        fontMenu.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                sizeDownItem.setEnabled(FontSizer.getLevel() > 0);
            }
        });
        aliasMenu.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (EjsControlFrame.this.defaultDrawingPanel == null) {
                    textAliasItem.setEnabled(false);
                    shapeAliasItem.setEnabled(false);
                } else {
                    textAliasItem.setEnabled(true);
                    textAliasItem.setEnabled(true);
                    textAliasItem.setSelected(EjsControlFrame.this.defaultDrawingPanel.isAntialiasTextOn());
                    shapeAliasItem.setSelected(EjsControlFrame.this.defaultDrawingPanel.isAntialiasShapeOn());
                }
            }
        });
        aliasMenu.add(shapeAliasItem);
        this.menuBar.add(displayMenu);
    }

    protected void refreshGUI() {
        this.createMenuBar();
        this.frame.pack();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void println(String s) {
        if (s == null) {
            return;
        }
        this.messageArea.append(s + "\n");
        ((Component)this.messageFrame).setVisible(true);
    }

    public void println() {
        this.messageArea.append("\n");
        ((Component)this.messageFrame).setVisible(true);
    }

    public void calculationDone(String message) {
        if (message == null || message.trim().equals("")) {
            return;
        }
        super.calculationDone(message);
    }

    public void print(String s) {
        if (s == null) {
            return;
        }
        this.messageArea.append(s);
        ((Component)this.messageFrame).setVisible(true);
    }

    public void clearMessages() {
        this.messageArea.setText("");
    }

    public OSPFrame getFrame() {
        return this.frame;
    }

    public void render() {
    }

    public ControlElement addObject(Object object, String classname, String propList) {
        if (object instanceof DrawingPanel) {
            this.defaultDrawingPanel = (DrawingPanel)object;
        }
        return super.addObject(object, classname, propList);
    }

    public void clearData() {
    }

    public void clearDataAndRepaint() {
    }

    public Container getTopLevelAncestor() {
        return this.frame;
    }

    public JRootPane getRootPane() {
        return this.frame.getRootPane();
    }

    public Container getContentPane() {
        return this.frame.getContentPane();
    }

    public void setContentPane(Container contentPane) {
        this.frame.setContentPane(contentPane);
    }

    public JLayeredPane getLayeredPane() {
        return this.frame.getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane layeredPane) {
        this.frame.setLayeredPane(layeredPane);
    }

    public Component getGlassPane() {
        return this.frame.getGlassPane();
    }

    public void setGlassPane(Component glassPane) {
        this.frame.setGlassPane(glassPane);
    }

    public void parseXMLMenu(String xmlMenu) {
        if (this.menuBar == null) {
            return;
        }
        XMLControlElement xml = new XMLControlElement(xmlMenu);
        if (xml.failedToRead()) {
            OSPLog.info("Tools menu not found: " + xmlMenu);
        } else {
            Class type = xml.getObjectClass();
            if (type != null && (class$org$opensourcephysics$tools$LaunchNode == null ? (class$org$opensourcephysics$tools$LaunchNode = EjsControlFrame.class$("org.opensourcephysics.tools.LaunchNode")) : class$org$opensourcephysics$tools$LaunchNode).isAssignableFrom(type)) {
                LaunchNode node = (LaunchNode)xml.loadObject(null);
                String menuName = node.toString();
                JMenu menu = null;
                for (int i = 0; i < this.menuBar.getMenuCount(); ++i) {
                    JMenu next = this.menuBar.getMenu(i);
                    if (!next.getText().equals(menuName)) continue;
                    menu = next;
                    break;
                }
                if (menu == null) {
                    menu = new JMenu(menuName);
                    this.menuBar.add(menu);
                    this.menuBar.validate();
                }
                node.setLaunchObject(this.model);
                node.addMenuItemsTo(menu);
                OSPLog.finest("Tools menu loaded: " + xmlMenu);
            }
        }
    }

    public void saveXML() {
        JFileChooser chooser = OSPFrame.getChooser();
        int result = chooser.showSaveDialog(null);
        if (result == 0) {
            int selected;
            File file = chooser.getSelectedFile();
            if (file.exists() && (selected = JOptionPane.showConfirmDialog(null, EjsRes.getString("EjsControlFrame.ReplaceExisting_dialog") + file.getName() + EjsRes.getString("EjsControlFrame.question_mark"), EjsRes.getString("EjsControlFrame.RepalceFile_dialog_message"), 1)) != 0) {
                return;
            }
            OSPFrame.chooserDir = chooser.getCurrentDirectory().toString();
            String fileName = XML.getRelativePath(file.getAbsolutePath());
            if (fileName == null || fileName.trim().equals("")) {
                return;
            }
            int i = fileName.toLowerCase().lastIndexOf(".xml");
            if (i != fileName.length() - 4) {
                fileName = fileName + ".xml";
            }
            XMLControlElement xml = new XMLControlElement(this.getApp());
            xml.write(fileName);
        }
    }

    private OSPApplication getApp() {
        if (this.app == null) {
            this.app = new OSPApplication(this, this.model);
        }
        return this.app;
    }

    public void loadDefaultXML() {
        if (this.xmlDefault != null) {
            this.xmlDefault.loadObject(this.getApp());
        }
    }

    public void loadXML(String fileName) {
        XMLControlElement xml;
        if (fileName == null || fileName.trim().equals("")) {
            this.loadXML();
            return;
        }
        if ((class$org$opensourcephysics$controls$OSPApplication == null ? (class$org$opensourcephysics$controls$OSPApplication = EjsControlFrame.class$("org.opensourcephysics.controls.OSPApplication")) : class$org$opensourcephysics$controls$OSPApplication).isAssignableFrom((xml = new XMLControlElement(fileName)).getObjectClass())) {
            this.xmlDefault = xml;
            xml.loadObject(this.getApp());
        } else {
            JOptionPane.showMessageDialog(this.frame, "\"" + fileName + "\" is for " + xml.getObjectClass() + ".", "Incorrect XML Object Type", 2);
        }
    }

    public void loadXML() {
        JFileChooser chooser = OSPFrame.getChooser();
        int result = chooser.showOpenDialog(null);
        if (result == 0) {
            String fileName = chooser.getSelectedFile().getAbsolutePath();
            this.loadXML(XML.getRelativePath(fileName));
        }
    }

    public void inspectXML() {
        XMLControlElement xml = new XMLControlElement(this.getApp());
        XMLTreePanel treePanel = new XMLTreePanel(xml);
        JDialog dialog = new JDialog((Frame)null, true);
        dialog.setContentPane(treePanel);
        ((Component)dialog).setSize(new Dimension(600, 300));
        ((Component)dialog).setVisible(true);
    }

    public void loadXML(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                this.loadXML(args[i]);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

