/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import java.util.Enumeration;
import java.util.Vector;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.MethodWithOneParameter;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.Value;

public class GroupVariable {
    private String name;
    private Value value;
    private Vector elementList;
    private Vector methodList;

    public GroupVariable(String _aName, Value _aValue) {
        this.name = _aName;
        this.elementList = new Vector();
        this.methodList = new Vector();
        this.value = _aValue != null ? _aValue.cloneValue() : new DoubleValue(0.0);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setValue(Value _aValue) {
        if (this.value.getClass() != _aValue.getClass()) {
            this.value = _aValue.cloneValue();
        } else {
            this.value.copyValue(_aValue);
        }
    }

    public Value getValue() {
        return this.value;
    }

    public void addElementListener(ControlElement _element, int _index) {
        this.elementList.add(new Item(_element, _index));
    }

    public void removeElementListener(ControlElement _element, int _index) {
        Enumeration e = this.elementList.elements();
        while (e.hasMoreElements()) {
            Item item = (Item)e.nextElement();
            if (item.element != _element || item.index != _index) continue;
            this.elementList.removeElement(item);
            return;
        }
    }

    public void propagateValue(ControlElement _element) {
        Enumeration e = this.elementList.elements();
        while (e.hasMoreElements()) {
            Item item = (Item)e.nextElement();
            if (item.element == _element) continue;
            item.element.setActive(false);
            if (item.element.myMethodsForProperties[item.index] != null) {
                item.element.setValue(item.index, item.element.myMethodsForProperties[item.index].invoke(2, null));
            } else if (item.element.myExpressionsForProperties[item.index] != null) {
                item.element.setValue(item.index, item.element.myExpressionsForProperties[item.index]);
            } else {
                item.element.setValue(item.index, this.value);
            }
            item.element.setActive(true);
        }
    }

    public void addListener(Object _target, String _method) {
        this.addListener(_target, _method, null);
    }

    public void addListener(Object _target, String _method, Object _anObject) {
        this.methodList.add(new MethodWithOneParameter(1, _target, _method, null, null, _anObject));
    }

    public void removeListener(Object _target, String _method) {
        Enumeration e = this.methodList.elements();
        while (e.hasMoreElements()) {
            MethodWithOneParameter method = (MethodWithOneParameter)e.nextElement();
            if (!method.equals(1, _target, _method)) continue;
            this.methodList.removeElement(method);
            return;
        }
    }

    public void invokeListeners(ControlElement _element) {
        Enumeration e = this.methodList.elements();
        while (e.hasMoreElements()) {
            ((MethodWithOneParameter)e.nextElement()).invoke(1, _element);
        }
    }

    private class Item {
        public ControlElement element;
        public int index;

        Item(ControlElement _anElement, int _anIndex) {
            this.element = _anElement;
            this.index = _anIndex;
        }
    }
}

