/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.swing.ImageIcon;

public class Utils {
    private static Hashtable cacheImages = new Hashtable();
    private static byte[] enormous = new byte[100000];

    public static boolean fileExists(String _codebase, String _filename) {
        int index;
        if (_filename == null) {
            return false;
        }
        if (cacheImages.get(_filename) != null) {
            return true;
        }
        if (_codebase != null) {
            if (_codebase.startsWith("file:")) {
                _codebase = "file:///" + _codebase.substring(6);
            }
            if (!_codebase.endsWith("/")) {
                _codebase = _codebase + "/";
            }
        }
        if ((index = _filename.indexOf(43)) >= 0) {
            return Utils.fileExistsInJar(_codebase, _filename.substring(0, index), _filename.substring(index + 1));
        }
        if (_codebase == null) {
            File file = new File(_filename);
            return file.exists();
        }
        try {
            URL url = new URL(_codebase + _filename);
            InputStream stream = url.openStream();
            stream.close();
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static boolean fileExistsInJar(String _codebase, String _jarFile, String _filename) {
        if (_filename == null || _jarFile == null) {
            return false;
        }
        InputStream inputStream = null;
        try {
            JarEntry je;
            if (_codebase == null) {
                inputStream = new FileInputStream(_jarFile);
            } else {
                URL url = new URL(_codebase + _jarFile);
                inputStream = url.openStream();
            }
            JarInputStream jis = new JarInputStream(inputStream);
            while ((je = jis.getNextJarEntry()) != null) {
                if (je.isDirectory() || !je.getName().equals(_filename)) continue;
                return true;
            }
        }
        catch (Exception exc) {
            return false;
        }
        return false;
    }

    public static ImageIcon icon(String _codebase, String _gifFile) {
        return Utils.icon(_codebase, _gifFile, true);
    }

    public static ImageIcon icon(String _codebase, String _gifFile, boolean _verbose) {
        int index;
        if (_gifFile == null) {
            return null;
        }
        ImageIcon icon = (ImageIcon)cacheImages.get(_gifFile);
        if (icon != null) {
            return icon;
        }
        if (_codebase != null) {
            if (_codebase.startsWith("file:")) {
                _codebase = "file:///" + _codebase.substring(6);
            }
            if (!_codebase.endsWith("/")) {
                _codebase = _codebase + "/";
            }
        }
        if ((index = _gifFile.indexOf(43)) >= 0) {
            icon = Utils.iconJar(_codebase, _gifFile.substring(0, index), _gifFile.substring(index + 1), _verbose);
        } else if (_codebase == null) {
            File file = new File(_gifFile);
            if (file.exists()) {
                icon = new ImageIcon(_gifFile);
            }
        } else {
            try {
                URL url = new URL(_codebase + _gifFile);
                icon = new ImageIcon(url);
            }
            catch (Exception exc) {
                if (_verbose) {
                    exc.printStackTrace();
                }
                icon = null;
            }
        }
        if (icon == null || icon.getIconHeight() <= 0) {
            if (_verbose) {
                System.out.println("Unable to load image " + _gifFile);
            }
        } else {
            cacheImages.put(_gifFile, icon);
        }
        return icon;
    }

    public static ImageIcon iconJar(String _codebase, String _jarFile, String _gifFile, boolean _verbose) {
        if (_gifFile == null || _jarFile == null) {
            return null;
        }
        ImageIcon icon = null;
        InputStream inputStream = null;
        try {
            JarEntry je;
            if (_codebase == null) {
                inputStream = new FileInputStream(_jarFile);
            } else {
                URL url = new URL(_codebase + _jarFile);
                inputStream = url.openStream();
            }
            JarInputStream jis = new JarInputStream(inputStream);
            boolean done = false;
            byte[] b = null;
            while (!done && (je = jis.getNextJarEntry()) != null) {
                if (je.isDirectory() || !je.getName().equals(_gifFile)) continue;
                long size = (int)je.getSize();
                int rb = 0;
                int chunk = 0;
                while (chunk >= 0 && (chunk = jis.read(enormous, rb, 255)) != -1) {
                    rb += chunk;
                }
                size = rb;
                b = new byte[(int)size];
                System.arraycopy(enormous, 0, b, 0, (int)size);
                done = true;
            }
            icon = new ImageIcon(b);
        }
        catch (Exception exc) {
            if (_verbose) {
                exc.printStackTrace();
            }
            icon = null;
        }
        return icon;
    }
}

