/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.BooleanValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlCheckBox
extends ControlSwingElement {
    static final int VARIABLE = 4;
    protected JCheckBox checkbox;
    private BooleanValue internalValue;
    private boolean defaultState;
    private boolean defaultStateSet;
    private String imageFile = null;
    private String selectedimageFile = null;
    private static ArrayList infoList = null;

    public ControlCheckBox(Object _visual) {
        super(_visual);
    }

    protected Component createVisual(Object _visual) {
        this.checkbox = _visual instanceof JCheckBox ? (JCheckBox)_visual : new JCheckBox();
        this.defaultStateSet = false;
        this.defaultState = this.checkbox.isSelected();
        this.internalValue = new BooleanValue(this.defaultState);
        this.checkbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent _e) {
                ControlCheckBox.this.setInternalValue(ControlCheckBox.this.checkbox.isSelected());
            }
        });
        return this.checkbox;
    }

    public void reset() {
        if (this.defaultStateSet) {
            this.checkbox.setSelected(this.defaultState);
            this.setInternalValue(this.defaultState);
        }
    }

    private void setInternalValue(boolean _state) {
        this.internalValue.value = _state;
        this.variableChanged(4, this.internalValue);
        this.invokeActions();
        if (this.internalValue.value) {
            this.invokeActions(20);
        } else {
            this.invokeActions(21);
        }
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("text");
            infoList.add("image");
            infoList.add("selectedimage");
            infoList.add("alignment");
            infoList.add("variable");
            infoList.add("selected");
            infoList.add("action");
            infoList.add("actionon");
            infoList.add("actionoff");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("text")) {
            return "String NotTrimmed TRANSLATABLE";
        }
        if (_property.equals("image")) {
            return "File|String";
        }
        if (_property.equals("selectedimage")) {
            return "File|String";
        }
        if (_property.equals("alignment")) {
            return "Alignment|int";
        }
        if (_property.equals("variable")) {
            return "boolean";
        }
        if (_property.equals("selected")) {
            return "boolean CONSTANT POSTPROCESS";
        }
        if (_property.equals("action")) {
            return "Action  CONSTANT";
        }
        if (_property.equals("actionon")) {
            return "Action  CONSTANT";
        }
        if (_property.equals("actionoff")) {
            return "Action  CONSTANT";
        }
        if (_property.equals("enabled")) {
            return "boolean BASIC";
        }
        return super.getPropertyInfo(_property);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.checkbox.setText(_value.getString());
                break;
            }
            case 1: {
                if (_value.getString().equals(this.imageFile)) {
                    return;
                }
                this.imageFile = _value.getString();
                this.checkbox.setIcon(this.getIcon(this.imageFile));
                break;
            }
            case 2: {
                if (_value.getString().equals(this.selectedimageFile)) {
                    return;
                }
                this.selectedimageFile = _value.getString();
                this.checkbox.setSelectedIcon(this.getIcon(this.selectedimageFile));
                break;
            }
            case 3: {
                this.checkbox.setHorizontalAlignment(_value.getInteger());
                break;
            }
            case 4: {
                this.internalValue.value = _value.getBoolean();
                this.checkbox.setSelected(this.internalValue.value);
                break;
            }
            case 5: {
                this.defaultStateSet = true;
                this.defaultState = _value.getBoolean();
                this.setActive(false);
                this.reset();
                this.setActive(true);
                break;
            }
            case 6: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, _value.getString());
                break;
            }
            case 7: {
                this.removeAction(20, this.getProperty("actionon"));
                this.addAction(20, _value.getString());
                break;
            }
            case 8: {
                this.removeAction(21, this.getProperty("actionoff"));
                this.addAction(21, _value.getString());
                break;
            }
            default: {
                super.setValue(_index - 9, _value);
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.checkbox.setText("");
                break;
            }
            case 1: {
                this.checkbox.setIcon(null);
                this.imageFile = null;
                break;
            }
            case 2: {
                this.checkbox.setSelectedIcon(null);
                this.selectedimageFile = null;
                break;
            }
            case 3: {
                this.checkbox.setHorizontalAlignment(0);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.defaultStateSet = false;
                break;
            }
            case 6: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 7: {
                this.removeAction(20, this.getProperty("actionon"));
                break;
            }
            case 8: {
                this.removeAction(21, this.getProperty("actionoff"));
                break;
            }
            default: {
                super.setDefaultValue(_index - 9);
            }
        }
    }

    public Value getValue(int _index) {
        switch (_index) {
            case 4: {
                return this.internalValue;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return null;
            }
        }
        return super.getValue(_index - 9);
    }
}

