/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.StringValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlComboBox
extends ControlSwingElement {
    private static final int VARIABLE = 0;
    private static final int BACKGROUND = 13;
    private static final int FOREGROUND = 12;
    protected JComboBox combo;
    private Component editorComponent;
    private String optionsString;
    private StringValue internalValue;
    private boolean defaultValueSet;
    private boolean defaultEditable;
    private boolean doNotUpdate = false;
    private String defaultValue;
    private Color defaultColor;
    private Color editingColor;
    private Color errorColor;
    private static ArrayList infoList = null;

    public ControlComboBox(Object _visual) {
        super(_visual);
    }

    protected Component createVisual(Object _visual) {
        this.combo = _visual instanceof JComboBox ? (JComboBox)_visual : new JComboBox();
        this.defaultEditable = this.combo.isEditable();
        this.combo.addActionListener(new MyActionListener());
        this.editorComponent = this.combo.getEditor().getEditorComponent();
        this.editorComponent.addKeyListener(new MyKeyListener());
        this.defaultValue = "";
        this.defaultValueSet = false;
        this.internalValue = new StringValue(this.defaultValue);
        this.decideColors(this.editorComponent.getBackground());
        return this.combo;
    }

    public void reset() {
        if (this.defaultValueSet) {
            this.setTheValue(this.defaultValue);
            this.setInternalValue(this.defaultValue);
        }
    }

    private void setTheValue(String _value) {
        if (this.internalValue.value != null && this.internalValue.value.equals(_value)) {
            return;
        }
        this.internalValue.value = _value;
        this.combo.setSelectedItem(this.internalValue.value);
        this.setColor(this.defaultColor);
    }

    private void setInternalValue(String _value) {
        this.internalValue.value = _value;
        this.variableChanged(0, this.internalValue);
        this.invokeActions();
    }

    private void setTheOptions(String _options) {
        if (_options == null) {
            if (this.optionsString != null) {
                this.combo.removeAllItems();
                this.optionsString = null;
            }
            return;
        }
        if (_options.equals(this.optionsString)) {
            return;
        }
        this.doNotUpdate = true;
        this.combo.removeAllItems();
        StringTokenizer tkn = new StringTokenizer(_options, ";");
        while (tkn.hasMoreTokens()) {
            this.combo.addItem(tkn.nextToken());
        }
        this.optionsString = _options;
        this.doNotUpdate = false;
        if (this.combo.getItemCount() > 0) {
            this.setTheValue(this.combo.getItemAt(0).toString());
        }
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("variable");
            infoList.add("options");
            infoList.add("value");
            infoList.add("editable");
            infoList.add("editBackground");
            infoList.add("action");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("variable")) {
            return "String VARIABLE_EXPECTED";
        }
        if (_property.equals("options")) {
            return "String PREVIOUS TRANSLATABLE";
        }
        if (_property.equals("value")) {
            return "String CONSTANT";
        }
        if (_property.equals("editable")) {
            return "boolean";
        }
        if (_property.equals("editBackground")) {
            return "Color|Object";
        }
        if (_property.equals("action")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(_property);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.setTheValue(_value.getString());
                break;
            }
            case 1: {
                this.setTheOptions(_value.getString());
                break;
            }
            case 2: {
                this.defaultValueSet = true;
                this.defaultValue = _value.getString();
                this.setActive(false);
                this.reset();
                this.setActive(true);
                break;
            }
            case 3: {
                this.combo.setEditable(_value.getBoolean());
                break;
            }
            case 4: {
                if (_value.getObject() instanceof Color) {
                    this.editorComponent.setBackground((Color)_value.getObject());
                }
                this.decideColors(this.editorComponent.getBackground());
                break;
            }
            case 5: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, _value.getString());
                break;
            }
            default: {
                super.setValue(_index - 6, _value);
                break;
            }
            case 12: {
                super.setValue(6, _value);
                if (!(_value.getObject() instanceof Color)) break;
                this.editorComponent.setForeground((Color)_value.getObject());
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                break;
            }
            case 1: {
                this.setTheOptions(null);
                break;
            }
            case 2: {
                this.defaultValueSet = false;
                break;
            }
            case 3: {
                this.combo.setEditable(this.defaultEditable);
                break;
            }
            case 4: {
                this.editorComponent.setBackground(Color.white);
                this.decideColors(this.editorComponent.getBackground());
                break;
            }
            case 5: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            default: {
                super.setDefaultValue(_index - 6);
                break;
            }
            case 12: {
                super.setDefaultValue(6);
                this.editorComponent.setForeground(Color.black);
            }
        }
    }

    public Value getValue(int _index) {
        switch (_index) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return null;
            }
        }
        return super.getValue(_index - 6);
    }

    private void setColor(Color aColor) {
        if (this.combo.isEditable()) {
            this.editorComponent.setBackground(aColor);
        }
    }

    private void decideColors(Color aColor) {
        if (aColor == null) {
            return;
        }
        this.defaultColor = aColor;
        this.editingColor = this.defaultColor.equals(Color.yellow) ? Color.orange : Color.yellow;
        this.errorColor = this.defaultColor.equals(Color.red) ? Color.magenta : Color.red;
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        public void keyPressed(KeyEvent _e) {
            this.processKeyEvent(_e, 0);
        }

        public void keyReleased(KeyEvent _e) {
            this.processKeyEvent(_e, 1);
        }

        public void keyTyped(KeyEvent _e) {
            this.processKeyEvent(_e, 2);
        }

        private void processKeyEvent(KeyEvent _e, int _n) {
            if (!ControlComboBox.this.combo.isEditable()) {
                return;
            }
            if (_e.getKeyChar() != '\n') {
                ControlComboBox.this.setColor(ControlComboBox.this.editingColor);
            }
            if (_e.getKeyCode() == 27) {
                ControlComboBox.this.setValue(0, ControlComboBox.this.internalValue);
            }
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        public void actionPerformed(ActionEvent _e) {
            if (ControlComboBox.this.doNotUpdate) {
                return;
            }
            ControlComboBox.this.setInternalValue((String)ControlComboBox.this.combo.getSelectedItem());
            ControlComboBox.this.setColor(ControlComboBox.this.defaultColor);
        }
    }
}

