/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlTextArea
extends ControlSwingElement {
    static String _RETURN_ = System.getProperty("line.separator");
    protected JTextArea textarea;
    private JScrollPane panel;
    private TitledBorder titledBorder;
    private EtchedBorder etchedBorder;
    private static ArrayList infoList = null;

    public ControlTextArea(Object _visual) {
        super(_visual);
    }

    protected Component createVisual(Object _visual) {
        if (_visual instanceof JTextArea) {
            this.textarea = (JTextArea)_visual;
        } else {
            this.textarea = new JTextArea(5, 5);
            this.textarea.setEditable(false);
        }
        this.panel = new JScrollPane(this.textarea);
        this.etchedBorder = new EtchedBorder(1);
        this.titledBorder = new TitledBorder(this.etchedBorder, "");
        this.titledBorder.setTitleJustification(2);
        this.panel.setBorder(this.etchedBorder);
        return this.textarea;
    }

    public Component getComponent() {
        return this.panel;
    }

    public void reset() {
        this.textarea.setText("");
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("title");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("title")) {
            return "String TRANSLATABLE";
        }
        return super.getPropertyInfo(_property);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (_value.getString().equals(this.titledBorder.getTitle())) break;
                this.titledBorder.setTitle(_value.getString());
                this.panel.setBorder(this.titledBorder);
                this.panel.repaint();
                break;
            }
            default: {
                super.setValue(_index - 1, _value);
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.panel.setBorder(this.etchedBorder);
                this.panel.repaint();
                break;
            }
            default: {
                super.setDefaultValue(_index - 1);
            }
        }
    }

    public Value getValue(int _index) {
        switch (_index) {
            case 0: {
                return null;
            }
        }
        return super.getValue(_index - 1);
    }

    public void clear() {
        this.textarea.setText("");
        this.textarea.setCaretPosition(this.textarea.getText().length());
    }

    public void println(String s) {
        this.print(s + _RETURN_);
    }

    public void print(String s) {
        this.textarea.append(s);
        this.textarea.setCaretPosition(this.textarea.getText().length());
    }
}

