/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.opensourcephysics.ejs.control.NeedsUpdate;
import org.opensourcephysics.ejs.control.swing.ControlContainer;
import org.opensourcephysics.ejs.control.value.BooleanValue;
import org.opensourcephysics.ejs.control.value.StringValue;
import org.opensourcephysics.ejs.control.value.Value;

public abstract class ControlWindow
extends ControlContainer
implements NeedsUpdate {
    public static final int NAME = 3;
    public static final int VISIBLE = 7;
    private static final int SIZE = 8;
    protected BooleanValue internalValue;
    private LayoutManager myLayout = null;
    private Point myLocation = null;
    private Dimension mySize = null;
    protected boolean waitForReset = false;
    protected boolean startingup = true;
    protected boolean shouldShow = true;
    private static ArrayList infoList = null;

    public ControlWindow(Object _visual) {
        super(_visual);
    }

    public void dispose() {
        ((Window)this.getComponent()).dispose();
    }

    public void show() {
        Window w;
        if (this.startingup) {
            this.shouldShow = true;
            if (this.waitForReset) {
                return;
            }
        }
        if (!(w = (Window)this.getComponent()).isShowing()) {
            ((Component)w).setVisible(true);
        }
    }

    public void hide() {
        Window w;
        if (this.startingup) {
            this.shouldShow = false;
            if (this.waitForReset) {
                return;
            }
        }
        if ((w = (Window)this.getComponent()).isShowing()) {
            ((Component)w).setVisible(false);
        }
    }

    public void destroy() {
        this.dispose();
        super.destroy();
    }

    public void setWaitForReset(boolean _option) {
        this.waitForReset = _option;
        if (this.waitForReset) {
            ((Component)((Window)this.getComponent())).setVisible(false);
        }
    }

    public void reset() {
        this.startingup = false;
        if (this.shouldShow) {
            this.show();
        } else {
            this.hide();
        }
        super.reset();
    }

    public void update() {
        this.startingup = false;
    }

    public void adjustSize() {
        String size = this.getProperty("size");
        ((Window)this.getComponent()).validate();
        if (size != null && size.trim().toLowerCase().equals("pack")) {
            ((Window)this.getComponent()).pack();
        } else {
            super.adjustSize();
        }
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("layout");
            infoList.add("location");
            infoList.add("waitForReset");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("location")) {
            return "Point|Object";
        }
        if (_property.equals("layout")) {
            return "Layout|Object";
        }
        if (_property.equals("waitForReset")) {
            return "boolean HIDDEN";
        }
        if (_property.equals("tooltip")) {
            return "String HIDDEN";
        }
        return super.getPropertyInfo(_property);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (!(_value.getObject() instanceof LayoutManager)) break;
                LayoutManager layout = (LayoutManager)_value.getObject();
                if (layout != this.myLayout) {
                    this.myLayout = layout;
                    this.getContainer().setLayout(this.myLayout);
                }
                ((Container)this.getComponent()).validate();
                break;
            }
            case 1: {
                if (!(_value.getObject() instanceof Point)) break;
                Point pos = (Point)_value.getObject();
                if (pos.equals(this.myLocation)) {
                    return;
                }
                this.myLocation = pos;
                this.getComponent().setLocation(this.myLocation);
                break;
            }
            case 2: {
                this.setWaitForReset(_value.getBoolean());
                break;
            }
            case 7: {
                this.internalValue.value = _value.getBoolean();
                if (this.internalValue.value) {
                    this.show();
                    break;
                }
                this.hide();
                break;
            }
            case 8: {
                Dimension size = null;
                if (_value instanceof StringValue && "pack".equals(_value.getString())) {
                    ((Window)this.getComponent()).pack();
                    size = this.getComponent().getSize();
                } else if (_value.getObject() instanceof Dimension) {
                    size = (Dimension)_value.getObject();
                    if (size.equals(this.mySize)) {
                        return;
                    }
                    this.mySize = size;
                    ((JComponent)this.getContainer()).setPreferredSize(this.mySize);
                    ((Container)this.getComponent()).validate();
                    ((Window)this.getComponent()).pack();
                } else {
                    return;
                }
                String loc = this.getProperty("location");
                if (loc == null || !loc.trim().toLowerCase().equals("center")) break;
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                this.getComponent().setLocation((dim.width - size.width) / 2, (dim.height - size.height) / 2);
                break;
            }
            default: {
                super.setValue(_index - 3, _value);
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.myLayout = new BorderLayout();
                this.getContainer().setLayout(this.myLayout);
                ((Container)this.getComponent()).validate();
                break;
            }
            case 1: {
                this.myLocation = new Point(0, 0);
                this.getComponent().setLocation(this.myLocation);
                break;
            }
            case 2: {
                this.setWaitForReset(false);
                break;
            }
            case 7: {
                this.internalValue.value = true;
                this.show();
                break;
            }
            case 8: {
                ((Window)this.getComponent()).pack();
                Dimension size = this.getComponent().getSize();
                String loc = this.getProperty("location");
                if (loc == null || !loc.trim().toLowerCase().equals("center")) break;
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                this.getComponent().setLocation((dim.width - size.width) / 2, (dim.height - size.height) / 2);
                break;
            }
            default: {
                super.setDefaultValue(_index - 3);
            }
        }
    }

    public Value getValue(int _index) {
        switch (_index) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: {
                return null;
            }
        }
        return super.getValue(_index - 3);
    }
}

