/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.value;

import java.util.StringTokenizer;
import org.opensourcephysics.ejs.control.value.BooleanValue;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.ObjectValue;
import org.opensourcephysics.ejs.control.value.StringValue;

public abstract class Value {
    public abstract boolean getBoolean();

    public abstract int getInteger();

    public abstract double getDouble();

    public abstract String getString();

    public abstract Object getObject();

    public void copyValue(Value _source) {
        if (this instanceof DoubleValue) {
            ((DoubleValue)this).value = _source.getDouble();
        } else if (this instanceof IntegerValue) {
            ((IntegerValue)this).value = _source.getInteger();
        } else if (this instanceof BooleanValue) {
            ((BooleanValue)this).value = _source.getBoolean();
        } else if (this instanceof StringValue) {
            ((StringValue)this).value = _source.getString();
        } else if (this instanceof ObjectValue) {
            ((ObjectValue)this).value = _source.getObject();
        }
    }

    public Value cloneValue() {
        if (this instanceof DoubleValue) {
            return new DoubleValue(this.getDouble());
        }
        if (this instanceof IntegerValue) {
            return new IntegerValue(this.getInteger());
        }
        if (this instanceof BooleanValue) {
            return new BooleanValue(this.getBoolean());
        }
        if (this instanceof StringValue) {
            return new StringValue(this.getString());
        }
        if (this instanceof ObjectValue) {
            return new ObjectValue(this.getObject());
        }
        return null;
    }

    public String toString() {
        return this.getString();
    }

    public static Value parseConstantOrArray(String _input, boolean _silentMode) {
        StringTokenizer tkn = new StringTokenizer(_input, ",");
        int dim = tkn.countTokens();
        if (dim <= 1) {
            return Value.parseConstant(_input, _silentMode);
        }
        Value[] data = new Value[dim];
        boolean hasDoubles = false;
        boolean hasInts = false;
        boolean hasBooleans = false;
        for (int i = 0; i < dim; ++i) {
            data[i] = Value.parseConstant(tkn.nextToken(), _silentMode);
            if (data[i] == null) {
                return Value.parseConstant(_input, _silentMode);
            }
            if (data[i] instanceof DoubleValue) {
                hasDoubles = true;
                continue;
            }
            if (data[i] instanceof IntegerValue) {
                hasInts = true;
                continue;
            }
            if (!(data[i] instanceof BooleanValue)) continue;
            hasBooleans = true;
        }
        if (hasDoubles) {
            double[] doubleArray = new double[dim];
            for (int i = 0; i < dim; ++i) {
                doubleArray[i] = data[i].getDouble();
            }
            return new ObjectValue(doubleArray);
        }
        if (hasInts) {
            int[] intArray = new int[dim];
            for (int i = 0; i < dim; ++i) {
                intArray[i] = data[i].getInteger();
            }
            return new ObjectValue(intArray);
        }
        if (hasBooleans) {
            boolean[] booleanArray = new boolean[dim];
            for (int i = 0; i < dim; ++i) {
                booleanArray[i] = data[i].getBoolean();
            }
            return new ObjectValue(booleanArray);
        }
        return Value.parseConstant(_input, _silentMode);
    }

    public static String removeScapes(String str) {
        String txt = "";
        int l = str.length();
        for (int i = 0; i < l; ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                if (i == l - 1) {
                    return txt + c;
                }
                c = str.charAt(++i);
            }
            txt = txt + c;
        }
        return txt;
    }

    public static Value parseConstant(String _input, boolean _silentMode) {
        if ((_input = _input.trim()).length() <= 0) {
            return null;
        }
        if (_input.startsWith("\"")) {
            if (_input.length() <= 1) {
                return null;
            }
            if (!_input.endsWith("\"")) {
                return null;
            }
            return new StringValue(Value.removeScapes(_input.substring(1, _input.length() - 1)));
        }
        if (_input.startsWith("'")) {
            if (!_input.endsWith("'")) {
                return null;
            }
            return new StringValue(Value.removeScapes(_input.substring(1, _input.length() - 1)));
        }
        if (_input.equals("true")) {
            return new BooleanValue(true);
        }
        if (_input.equals("false")) {
            return new BooleanValue(false);
        }
        if (_input.indexOf(46) >= 0) {
            try {
                double v = Double.parseDouble(_input);
                return new DoubleValue(v);
            }
            catch (Exception e) {
                if (!_silentMode) {
                    System.err.println("Value : Error 2! Incorrect input to parse " + _input);
                }
                return null;
            }
        }
        try {
            int i = Integer.parseInt(_input);
            return new IntegerValue(i);
        }
        catch (Exception e) {
            return null;
        }
    }
}

