/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.ComplexDataset;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.DataTableFrame;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.PlottingPanel;

public class ComplexPlotFrame
extends DrawingFrame {
    protected ComplexDataset complexDataset = new ComplexDataset();
    protected DataTable dataTable = new DataTable();
    JMenuItem ampPhaseItem;
    JMenuItem reImItem;
    JMenuItem postItem;
    JMenuItem barItem;
    protected DataTableFrame tableFrame;
    static /* synthetic */ Class class$org$opensourcephysics$display$ComplexDataset;

    public ComplexPlotFrame(String xlabel, String ylabel, String frameTitle) {
        super(new PlottingPanel(xlabel, ylabel, frameTitle));
        this.setTitle(frameTitle);
        this.drawingPanel.addDrawable(this.complexDataset);
        this.dataTable.add(this.complexDataset);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    protected void addMenuItems() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return;
        }
        JMenu helpMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu menu = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (menu == null) {
            menu = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            menuBar.add(menu);
            menuBar.validate();
        } else {
            menu.addSeparator();
        }
        if (helpMenu != null) {
            menuBar.add(helpMenu);
        }
        ButtonGroup menubarGroup = new ButtonGroup();
        this.ampPhaseItem = new JRadioButtonMenuItem("Amp & Phase");
        menubarGroup.add(this.ampPhaseItem);
        this.ampPhaseItem.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComplexPlotFrame.this.convertToAmpAndPhaseView();
            }
        };
        this.ampPhaseItem.addActionListener(actionListener);
        menu.add(this.ampPhaseItem);
        this.postItem = new JRadioButtonMenuItem("Post View");
        menubarGroup.add(this.postItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComplexPlotFrame.this.convertToPostView();
            }
        };
        this.postItem.addActionListener(actionListener);
        menu.add(this.postItem);
        this.barItem = new JRadioButtonMenuItem("Bar View");
        menubarGroup.add(this.barItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComplexPlotFrame.this.convertToPhaseBarView();
            }
        };
        this.barItem.addActionListener(actionListener);
        menu.add(this.barItem);
        this.reImItem = new JRadioButtonMenuItem("Re Im Components");
        menubarGroup.add(this.reImItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComplexPlotFrame.this.convertToReImView();
            }
        };
        this.reImItem.addActionListener(actionListener);
        menu.add(this.reImItem);
        menu.addSeparator();
        JMenuItem tableItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        tableItem.setAccelerator(KeyStroke.getKeyStroke(84, DrawingFrame.MENU_SHORTCUT_KEY_MASK));
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComplexPlotFrame.this.showDataTable(true);
            }
        };
        tableItem.addActionListener(actionListener);
        menu.add(tableItem);
        JMenuItem legendItem = new JMenuItem("Phase Legend");
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComplexPlotFrame.this.complexDataset.showLegend();
            }
        };
        legendItem.addActionListener(actionListener);
        menu.add(legendItem);
        if (this.drawingPanel != null && this.drawingPanel.getPopupMenu() != null) {
            JMenuItem item = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
            item.addActionListener(actionListener);
            this.drawingPanel.getPopupMenu().add(item);
        }
    }

    protected void convertToPostView() {
        this.complexDataset.setMarkerShape(4);
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
        this.postItem.setSelected(true);
    }

    protected void convertToAmpAndPhaseView() {
        this.complexDataset.setMarkerShape(2);
        this.complexDataset.setCentered(true);
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
        this.ampPhaseItem.setSelected(true);
    }

    protected void convertToPhaseBarView() {
        this.complexDataset.setMarkerShape(3);
        this.complexDataset.setCentered(false);
        this.drawingPanel.invalidateImage();
        this.barItem.setSelected(true);
        this.drawingPanel.repaint();
    }

    protected void convertToReImView() {
        this.complexDataset.setMarkerShape(1);
        this.drawingPanel.invalidateImage();
        this.reImItem.setSelected(true);
        this.drawingPanel.repaint();
    }

    public void append(double x, double re, double im) {
        this.complexDataset.append(x, re, im);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void append(double[] x, double[] z) {
        this.complexDataset.append(x, z);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void append(double[] xpoints, double[] re, double[] im) {
        this.complexDataset.append(xpoints, re, im);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void setConnected(boolean connected) {
        this.complexDataset.setConnected(connected);
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.complexDataset);
    }

    public synchronized ArrayList getDrawables() {
        ArrayList list = super.getDrawables();
        ((AbstractCollection)list).remove(this.complexDataset);
        return list;
    }

    public synchronized ArrayList getDrawables(Class c) {
        ArrayList list = super.getDrawables(c);
        ((AbstractCollection)list).remove(this.complexDataset);
        return list;
    }

    public void clearData() {
        this.complexDataset.clear();
        this.dataTable.refreshTable();
        this.drawingPanel.invalidateImage();
    }

    public synchronized void showDataTable(boolean show) {
        if (show) {
            if (this.tableFrame == null || !this.tableFrame.isDisplayable()) {
                this.tableFrame = new DataTableFrame(this.getTitle() + " Data", this.dataTable);
                this.tableFrame.setDefaultCloseOperation(2);
            }
            this.dataTable.refreshTable();
            this.tableFrame.setVisible(true);
        } else {
            this.tableFrame.setVisible(false);
            this.tableFrame.dispose();
            this.tableFrame = null;
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new ComplexPlotFrameLoader();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class ComplexPlotFrameLoader
    extends DrawingFrame.DrawingFrameLoader {
        protected ComplexPlotFrameLoader() {
        }

        public Object createObject(XMLControl control) {
            ComplexPlotFrame frame = new ComplexPlotFrame("x", "y", "Complex Plot Frame");
            return frame;
        }

        public Object loadObject(XMLControl control, Object obj) {
            super.loadObject(control, obj);
            ComplexPlotFrame frame = (ComplexPlotFrame)obj;
            ArrayList list = frame.getObjectOfClass(class$org$opensourcephysics$display$ComplexDataset == null ? (class$org$opensourcephysics$display$ComplexDataset = ComplexPlotFrame.class$("org.opensourcephysics.display.ComplexDataset")) : class$org$opensourcephysics$display$ComplexDataset);
            if (list.size() > 0) {
                frame.complexDataset = (ComplexDataset)list.get(0);
                frame.dataTable.clear();
                frame.dataTable.add(frame.complexDataset);
            }
            return obj;
        }
    }
}

