/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display2d.ByteRaster;

public class RasterFrame
extends DrawingFrame {
    protected ByteRaster raster = new ByteRaster(1, 1);
    MouseInputAdapter mouseAdapter;
    int[] editValues = new int[2];
    int dragV;
    Color[] customColors;

    public RasterFrame(String xlabel, String ylabel, String frameTitle) {
        super(new PlottingPanel(xlabel, ylabel, null));
        this.setTitle(frameTitle);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorXGrid(false);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorYGrid(false);
        this.addMenuItems();
        this.drawingPanel.addDrawable(this.raster);
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    public RasterFrame(String frameTitle) {
        super(new InteractivePanel());
        this.setTitle(frameTitle);
        this.addMenuItems();
        this.drawingPanel.addDrawable(this.raster);
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    protected void addMenuItems() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return;
        }
        JMenu helpMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu menu = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (menu == null) {
            menu = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            menuBar.add(menu);
            menuBar.validate();
        } else {
            menu.addSeparator();
        }
        if (helpMenu != null) {
            menuBar.add(helpMenu);
        }
        JMenuItem menuItem = new JMenuItem("Color");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RasterFrame.this.setColorPalette();
            }
        };
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Black and White");
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RasterFrame.this.setBWPalette();
            }
        };
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
    }

    public void setBWPalette() {
        this.raster.setBWPalette();
        this.repaint();
    }

    public void setColorPalette() {
        if (this.customColors == null) {
            this.raster.createDefaultColors();
        } else {
            this.raster.setColorPalette(this.customColors);
        }
        this.repaint();
    }

    public void setColorPalette(Color[] colors) {
        this.customColors = colors;
        this.raster.setColorPalette(colors);
        this.repaint();
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.raster);
    }

    public synchronized ArrayList getDrawables() {
        ArrayList list = super.getDrawables();
        ((AbstractCollection)list).remove(this.raster);
        return list;
    }

    public synchronized ArrayList getDrawables(Class c) {
        ArrayList list = super.getDrawables(c);
        ((AbstractCollection)list).remove(this.raster);
        return list;
    }

    public void clearData() {
        this.raster.setBlock(0, 0, new byte[this.raster.getNx()][this.raster.getNy()]);
        this.drawingPanel.invalidateImage();
    }

    public void randomize() {
        this.raster.randomize();
    }

    private void resizeRaster(int nx, int ny) {
        this.drawingPanel.setPreferredSize(new Dimension(Math.max(nx + this.drawingPanel.getLeftGutter() + this.drawingPanel.getRightGutter(), 50), Math.max(ny + this.drawingPanel.getTopGutter() + this.drawingPanel.getBottomGutter(), 50)));
        this.pack();
        this.raster.resizeLattice(nx, ny);
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void setIndexedColor(int index, Color color) {
        this.raster.setIndexedColor(index, color);
    }

    public void setAll(byte[][] val, double xmin, double xmax, double ymin, double ymax) {
        this.setAll(val);
        this.raster.setMinMax(xmin, xmax, ymin, ymax);
    }

    public void setAll(byte[][] val) {
        if (val.length != this.raster.getNx() || val[0].length != this.raster.getNy()) {
            this.resizeRaster(val.length, val[0].length);
        }
        this.raster.setBlock(0, 0, val);
    }

    public void setAll(int[][] val) {
        if (val.length != this.raster.getNx() || val[0].length != this.raster.getNy()) {
            this.resizeRaster(val.length, val[0].length);
        }
        this.raster.setBlock(0, 0, val);
    }

    public void setAll(int[][] val, double xmin, double xmax, double ymin, double ymax) {
        this.setAll(val);
        this.raster.setMinMax(xmin, xmax, ymin, ymax);
    }

    public void setAll(int[] val, int nx, double xmin, double xmax, double ymin, double ymax) {
        if (val.length % nx != 0) {
            throw new IllegalArgumentException("Raster dimension must match number of values.");
        }
        this.resizeRaster(nx, val.length / nx);
        this.setAll(val);
        this.raster.setMinMax(xmin, xmax, ymin, ymax);
    }

    public void setAll(int[] v) {
        if (v.length != this.raster.getNx() * this.raster.getNy()) {
            throw new IllegalArgumentException("Raster size must be set before using row-major format.");
        }
        for (int i = 0; i < v.length; ++i) {
            this.setAtIndex(i, v[i]);
        }
    }

    public void setAtIndex(int i, int v) {
        int nx = this.raster.getNx();
        this.setValue(i % nx, i / nx, v);
    }

    public void setValue(int ix, int iy, int v) {
        this.raster.setValue(ix, iy, (byte)v);
    }

    public int getAtIndex(int i) {
        int Nx = this.raster.getNx();
        return this.get(i % Nx, i / Nx);
    }

    public int get(int ix, int iy) {
        return this.raster.getValue(ix, iy) + 128;
    }

    public int[] getAll() {
        int N = this.raster.getNx() * this.raster.getNy();
        int[] ret = new int[N];
        for (int i = 0; i < N; ++i) {
            ret[i] = this.getAtIndex(i);
        }
        return ret;
    }

    public void setToggleOnClick(boolean enable, int v1, int v2) {
        this.editValues = new int[]{v1, v2};
        if (enable) {
            this.drawingPanel.addMouseListener(this.getMouseAdapter());
            this.drawingPanel.addMouseMotionListener(this.getMouseAdapter());
        } else {
            this.drawingPanel.removeMouseListener(this.getMouseAdapter());
            this.drawingPanel.removeMouseMotionListener(this.getMouseAdapter());
        }
    }

    void mouse(MouseEvent e, boolean pressed) {
        double y;
        if (e.getButton() == 3) {
            return;
        }
        double x = this.drawingPanel.pixToX(e.getX());
        int i = this.indexFromPoint(x, y = this.drawingPanel.pixToY(e.getY()));
        if (i == -1) {
            return;
        }
        if (pressed) {
            this.dragV = this.editValues[0];
            int len = this.editValues.length;
            for (int j = 0; j < len; ++j) {
                if (this.getAtIndex(i) != this.editValues[j]) continue;
                this.dragV = this.editValues[(j + 1) % len];
            }
        }
        if (this.getAtIndex(i) != this.dragV) {
            this.setAtIndex(i, this.dragV);
            this.drawingPanel.render();
        }
    }

    public double indexToX(int i) {
        if (this.raster == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.raster.indexToX(i);
    }

    public int xToIndex(double x) {
        if (this.raster == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.raster.xToIndex(x);
    }

    public int yToIndex(double y) {
        if (this.raster == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.raster.yToIndex(y);
    }

    public double indexToY(int i) {
        if (this.raster == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.raster.indexToY(i);
    }

    public int indexFromPoint(double x, double y) {
        return this.raster.indexFromPoint(x, y);
    }

    synchronized MouseInputAdapter getMouseAdapter() {
        if (this.mouseAdapter == null) {
            return new MouseInputAdapter(){

                public void mousePressed(MouseEvent e) {
                    RasterFrame.this.mouse(e, true);
                }

                public void mouseDragged(MouseEvent e) {
                    RasterFrame.this.mouse(e, false);
                }
            };
        }
        return this.mouseAdapter;
    }
}

