/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class TableData
extends AbstractTableModel {
    ArrayList rowList = new ArrayList();
    ArrayList colNames = new ArrayList();
    ArrayList formats = new ArrayList();
    boolean rowNumberVisible = true;
    int colCount = 0;

    public synchronized void appendRow(Object obj) throws IllegalArgumentException {
        if (!obj.getClass().isArray()) {
            throw new IllegalArgumentException("A TableData row must be an array.");
        }
        Class<?> componentType = obj.getClass().getComponentType();
        String type = componentType.getName();
        if (type.equals("double")) {
            this.appendDoubles((double[])obj);
        } else if (type.equals("int")) {
            this.appendInts((int[])obj);
        } else if (type.equals("byte")) {
            this.appendBytes((byte[])obj);
        } else if (type.equals("string")) {
            this.appendStrings((String[])obj);
        } else {
            Object[] row = (Object[])obj;
            String[] strings = new String[row.length];
            int n = row.length;
            for (int i = 0; i < n; ++i) {
                strings[i] = row[i].toString();
            }
            this.appendStrings(strings);
        }
    }

    void appendDoubles(double[] x) {
        if (x == null) {
            return;
        }
        double[] row = new double[x.length];
        System.arraycopy(x, 0, row, 0, x.length);
        this.rowList.add(row);
        this.colCount = Math.max(this.colCount, row.length + 1);
    }

    void appendInts(int[] x) {
        if (x == null) {
            return;
        }
        int[] row = new int[x.length];
        System.arraycopy(x, 0, row, 0, x.length);
        this.rowList.add(row);
        this.colCount = Math.max(this.colCount, row.length + 1);
    }

    void appendBytes(byte[] x) {
        if (x == null) {
            return;
        }
        byte[] row = new byte[x.length];
        System.arraycopy(x, 0, row, 0, x.length);
        this.rowList.add(row);
        this.colCount = Math.max(this.colCount, row.length + 1);
    }

    void appendStrings(String[] x) {
        if (x == null) {
            return;
        }
        String[] row = new String[x.length];
        System.arraycopy(x, 0, row, 0, x.length);
        this.rowList.add(row);
        this.colCount = Math.max(this.colCount, row.length + 1);
    }

    public void setRowNumberVisible(boolean vis) {
        this.rowNumberVisible = vis;
    }

    public void setColumnNames(int column, String name) {
        while (column >= this.colNames.size()) {
            this.colNames.add("" + (char)(65 + column));
        }
        this.colNames.set(column, name);
    }

    public void setColumnFormat(int column, String format) {
        while (column >= this.formats.size()) {
            this.formats.add(null);
        }
        this.formats.set(column, new DecimalFormat(format));
    }

    public DecimalFormat getColumnFormat(int column) {
        if (column <= this.formats.size()) {
            return (DecimalFormat)this.formats.get(column - 1);
        }
        return null;
    }

    public int getColumnCount() {
        if (this.getRowCount() == 0) {
            return 0;
        }
        return this.rowNumberVisible ? this.colCount : this.colCount - 1;
    }

    public String getColumnName(int column) {
        if (column == 0 && this.rowNumberVisible) {
            return "row #";
        }
        if (!this.rowNumberVisible) {
            ++column;
        }
        if (column <= this.colNames.size()) {
            return (String)this.colNames.get(column - 1);
        }
        return "" + (char)(65 + column);
    }

    public int getRowCount() {
        return this.rowList.size();
    }

    public Object getValueAt(int row, int column) {
        if (column == 0 && this.rowNumberVisible) {
            return new Integer(row);
        }
        if (!this.rowNumberVisible) {
            ++column;
        }
        if (row >= this.rowList.size()) {
            return "";
        }
        Object r = this.rowList.get(row);
        if (!r.getClass().isArray()) {
            return "";
        }
        if (r instanceof double[]) {
            double[] array = (double[])r;
            if (column > array.length) {
                return "";
            }
            DecimalFormat format = this.getColumnFormat(column);
            if (format == null) {
                return new Double(array[column - 1]);
            }
            return format.format(array[column - 1]);
        }
        if (r instanceof byte[]) {
            byte[] array = (byte[])r;
            if (column > array.length) {
                return "";
            }
            return new Byte(array[column - 1]);
        }
        if (r instanceof int[]) {
            int[] array = (int[])r;
            if (column > array.length) {
                return "";
            }
            return new Integer(array[column - 1]);
        }
        if (r instanceof String[]) {
            String[] array = (String[])r;
            if (column > array.length) {
                return "";
            }
            return array[column - 1];
        }
        return "";
    }
}

