/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.DataTableFrame;
import org.opensourcephysics.frames.TableData;

public class TableFrame
extends DataTableFrame {
    TableData tableData = new TableData();

    public TableFrame(String frameTitle) {
        super(frameTitle, new DataTable());
        this.setAnimated(true);
        this.setAutoclear(true);
        this.table.setModel(this.tableData);
        this.setRowNumberVisible(true);
    }

    public void setRefreshDelay(int delay) {
        this.table.setRefreshDelay(delay);
    }

    public void setRowNumberVisible(boolean vis) {
        this.table.setRowNumberVisible(vis);
        this.tableData.setRowNumberVisible(vis);
    }

    public synchronized void appendArray(Object obj) throws IllegalArgumentException {
        if (!obj.getClass().isArray()) {
            throw new IllegalArgumentException("");
        }
        Class<?> componentType = obj.getClass().getComponentType();
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
        }
        String type = componentType.getName();
        if (type.equals("double")) {
            double[][] array = (double[][])obj;
            double[] row = new double[array.length];
            int n = array[0].length;
            for (int i = 0; i < n; ++i) {
                int m = row.length;
                for (int j = 0; j < m; ++j) {
                    row[j] = array[j][i];
                }
                this.appendRow(row);
            }
        } else if (type.equals("int")) {
            int[][] array = (int[][])obj;
            int[] row = new int[array.length];
            int n = array[0].length;
            for (int i = 0; i < n; ++i) {
                int m = row.length;
                for (int j = 0; j < m; ++j) {
                    row[j] = array[j][i];
                }
                this.appendRow(row);
            }
        } else if (type.equals("byte")) {
            byte[][] array = (byte[][])obj;
            byte[] row = new byte[array.length];
            int n = array[0].length;
            for (int i = 0; i < n; ++i) {
                int m = row.length;
                for (int j = 0; j < m; ++j) {
                    row[j] = array[j][i];
                }
                this.appendRow(row);
            }
        } else {
            Object[][] array = (Object[][])obj;
            Object[] row = new Object[array.length];
            int n = array[0].length;
            for (int i = 0; i < n; ++i) {
                int m = row.length;
                for (int j = 0; j < m; ++j) {
                    row[j] = array[j][i];
                }
                this.appendRow(row);
            }
        }
    }

    public synchronized void appendRow(double[] x) {
        this.tableData.appendDoubles(x);
        if (this.isShowing()) {
            this.table.refreshTable();
        }
    }

    public synchronized void appendRow(int[] x) {
        this.tableData.appendInts(x);
        if (this.isShowing()) {
            this.table.refreshTable();
        }
    }

    public synchronized void appendRow(Object[] x) {
        this.tableData.appendRow(x);
        if (this.isShowing()) {
            this.table.refreshTable();
        }
    }

    public synchronized void appendRow(byte[] x) {
        this.tableData.appendBytes(x);
        if (this.isShowing()) {
            this.table.refreshTable();
        }
    }

    public void setColumnNames(int column, String name) {
        this.tableData.setColumnNames(column, name);
    }

    public void setColumnFormat(int column, String format) {
        this.tableData.setColumnFormat(column, format);
    }

    public void setVisible(boolean vis) {
        if (vis) {
            this.table.refreshTable();
        }
        super.setVisible(vis);
    }

    public synchronized void clearData() {
        this.tableData.rowList.clear();
        this.tableData.colCount = 0;
    }
}

