/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridTableFrame;
import org.opensourcephysics.display2d.VectorPlot;

public class Vector2DFrame
extends DrawingFrame {
    GridData gridData;
    VectorPlot plot = new VectorPlot(null);
    GridTableFrame tableFrame;

    public Vector2DFrame(String xlabel, String ylabel, String frameTitle) {
        super(new PlottingPanel(xlabel, ylabel, null));
        this.drawingPanel.setPreferredSize(new Dimension(350, 350));
        this.setTitle(frameTitle);
        this.plot.setShowGridLines(false);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorXGrid(false);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorYGrid(false);
        this.drawingPanel.addDrawable(this.plot);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    public Vector2DFrame(String frameTitle) {
        super(new InteractivePanel());
        this.setTitle(frameTitle);
        this.plot.setShowGridLines(false);
        this.drawingPanel.addDrawable(this.plot);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    protected void addMenuItems() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return;
        }
        JMenu helpMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu menu = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (menu == null) {
            menu = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            menuBar.add(menu);
            menuBar.validate();
        } else {
            menu.addSeparator();
        }
        if (helpMenu != null) {
            menuBar.add(helpMenu);
        }
        JMenuItem tableItem = new JMenuItem("Legend");
        ActionListener tableListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector2DFrame.this.plot.showLegend();
            }
        };
        tableItem.addActionListener(tableListener);
        menu.add(tableItem);
        menu.addSeparator();
        tableItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        tableItem.setAccelerator(KeyStroke.getKeyStroke(84, DrawingFrame.MENU_SHORTCUT_KEY_MASK));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector2DFrame.this.showDataTable(true);
            }
        };
        tableItem.addActionListener(actionListener);
        menu.add(tableItem);
        if (this.drawingPanel != null && this.drawingPanel.getPopupMenu() != null) {
            JMenuItem item = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
            item.addActionListener(actionListener);
            this.drawingPanel.getPopupMenu().add(item);
        }
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.plot);
    }

    public synchronized ArrayList getDrawables() {
        ArrayList list = super.getDrawables();
        ((AbstractCollection)list).remove(this.plot);
        return list;
    }

    public double indexToX(int i) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.indexToX(i);
    }

    public double indexToY(int i) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.indexToY(i);
    }

    public int xToIndex(double x) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.xToIndex(x);
    }

    public int yToIndex(double y) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.yToIndex(y);
    }

    public int getNx() {
        if (this.gridData == null) {
            return 0;
        }
        return this.gridData.getNx();
    }

    public int getNy() {
        if (this.gridData == null) {
            return 0;
        }
        return this.gridData.getNy();
    }

    public synchronized ArrayList getDrawables(Class c) {
        ArrayList list = super.getDrawables(c);
        ((AbstractCollection)list).remove(this.plot);
        return list;
    }

    public void clearData() {
        if (this.gridData != null) {
            this.setAll(new double[2][this.gridData.getNx()][this.gridData.getNy()]);
        }
        this.drawingPanel.invalidateImage();
    }

    public void resizeGrid(int nx, int ny) {
        double ymax;
        double ymin;
        double xmax;
        double xmin;
        boolean cellScale = false;
        if (this.gridData == null) {
            xmin = this.drawingPanel.getPreferredXMin();
            xmax = this.drawingPanel.getPreferredXMax();
            ymin = this.drawingPanel.getPreferredYMin();
            ymax = this.drawingPanel.getPreferredYMax();
        } else {
            xmin = this.gridData.getLeft();
            xmax = this.gridData.getRight();
            ymin = this.gridData.getBottom();
            ymax = this.gridData.getTop();
            cellScale = this.gridData.isCellData();
        }
        this.gridData = new ArrayData(nx, ny, 3);
        this.gridData.setComponentName(0, "magnitude");
        this.gridData.setComponentName(1, "x component");
        this.gridData.setComponentName(2, "y component");
        if (cellScale) {
            this.gridData.setCellScale(xmin, xmax, ymin, ymax);
        } else {
            this.gridData.setScale(xmin, xmax, ymin, ymax);
        }
        this.plot.setGridData(this.gridData);
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void setRow(int row, double[][] vals) throws IllegalArgumentException {
        if (this.gridData.getNx() != vals.length) {
            throw new IllegalArgumentException("Row data length does not match grid size.");
        }
        double[] re = this.gridData.getData()[1][row];
        double[] im = this.gridData.getData()[2][row];
        double[] phase = this.gridData.getData()[0][row];
        System.arraycopy(vals[0], 0, re, 0, vals.length);
        System.arraycopy(vals[1], 0, im, 0, vals.length);
        int ny = phase.length;
        for (int j = 0; j < ny; ++j) {
            phase[j] = Math.atan2(re[j], im[j]);
        }
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
    }

    public void setAll(double[][][] vals, double xmin, double xmax, double ymin, double ymax) {
        this.setAll(vals);
        if (this.gridData.isCellData()) {
            this.gridData.setCellScale(xmin, xmax, ymin, ymax);
        } else {
            this.gridData.setScale(xmin, xmax, ymin, ymax);
        }
    }

    public void setAll(double[][][] vals) {
        if (this.gridData == null || this.gridData.getNx() != vals.length || this.gridData.getNy() != vals[0].length) {
            this.resizeGrid(vals[0].length, vals[0][0].length);
        }
        double[][] colorValue = this.gridData.getData()[0];
        double[][] xComp = this.gridData.getData()[1];
        double[][] yComp = this.gridData.getData()[2];
        int ny = vals[0][0].length;
        int nx = vals[0].length;
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                colorValue[i][j] = Math.sqrt(vals[0][i][j] * vals[0][i][j] + vals[1][i][j] * vals[1][i][j]);
                xComp[i][j] = colorValue[i][j] == 0.0 ? 0.0 : vals[0][i][j] / colorValue[i][j];
                yComp[i][j] = colorValue[i][j] == 0.0 ? 0.0 : vals[1][i][j] / colorValue[i][j];
            }
        }
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
    }

    public void setZRange(boolean isAutoscale, double floor, double ceil) {
        this.plot.setAutoscaleZ(isAutoscale, floor, ceil);
    }

    public synchronized void showDataTable(boolean show) {
        if (show) {
            if (this.tableFrame == null || !this.tableFrame.isDisplayable()) {
                if (this.gridData == null) {
                    return;
                }
                this.tableFrame = new GridTableFrame(this.gridData);
                this.tableFrame.setTitle("Vector Field Data");
                this.tableFrame.setDefaultCloseOperation(2);
            }
            this.tableFrame.refreshTable();
            this.tableFrame.setVisible(true);
        } else {
            this.tableFrame.setVisible(false);
            this.tableFrame.dispose();
            this.tableFrame = null;
        }
    }
}

