/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Butcher5;
import org.opensourcephysics.numerics.ODE;

public class Adams5
extends Butcher5 {
    private double[] fn;
    private double[] fn1;
    private double[] fn2;
    private double[] fn3;
    private double[] fn4;
    private double[] temp_state;
    private double[] temp_rate;
    private int counter = 0;

    public Adams5(ODE ode) {
        super(ode);
    }

    public void initialize(double stepSize) {
        super.initialize(stepSize);
        this.fn = new double[this.numEqn];
        this.fn1 = new double[this.numEqn];
        this.fn2 = new double[this.numEqn];
        this.fn3 = new double[this.numEqn];
        this.fn4 = new double[this.numEqn];
        this.temp_state = new double[this.numEqn];
        this.temp_rate = new double[this.numEqn];
        this.counter = 0;
    }

    public double step() {
        double[] state = this.ode.getState();
        if (state == null) {
            return this.stepSize;
        }
        if (state.length != this.numEqn) {
            this.initialize(this.stepSize);
        }
        this.ode.getRate(state, this.fn);
        if (this.counter < 4) {
            this.stepSize = super.step();
            ++this.counter;
        } else {
            int i;
            for (i = 0; i < this.numEqn; ++i) {
                this.temp_state[i] = state[i] + this.stepSize * (1901.0 * this.fn[i] - 2774.0 * this.fn1[i] + 2616.0 * this.fn2[i] - 1274.0 * this.fn3[i] + 251.0 * this.fn4[i]) / 720.0;
            }
            this.ode.getRate(this.temp_state, this.temp_rate);
            for (i = 0; i < this.numEqn; ++i) {
                state[i] = state[i] + this.stepSize * (251.0 * this.temp_rate[i] + 646.0 * this.fn[i] - 264.0 * this.fn1[i] + 106.0 * this.fn2[i] - 19.0 * this.fn3[i]) / 720.0;
            }
        }
        System.arraycopy(this.fn3, 0, this.fn4, 0, this.numEqn);
        System.arraycopy(this.fn2, 0, this.fn3, 0, this.numEqn);
        System.arraycopy(this.fn1, 0, this.fn2, 0, this.numEqn);
        System.arraycopy(this.fn, 0, this.fn1, 0, this.numEqn);
        return this.stepSize;
    }
}

