/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.MultiVarFunction;
import org.opensourcephysics.numerics.NumericMethodException;
import org.opensourcephysics.numerics.Util;

public class Derivative {
    private Derivative() {
    }

    public static Function getFirst(final Function f, final double h) {
        return new Function(){

            public double evaluate(double x) {
                return (f.evaluate(x + h) - f.evaluate(x - h)) / h / 2.0;
            }
        };
    }

    public static Function getSecond(final Function f, final double h) {
        return new Function(){

            public double evaluate(double x) {
                return (f.evaluate(x + h) - 2.0 * f.evaluate(x) + f.evaluate(x - h)) / h / h;
            }
        };
    }

    public static double romberg(Function f, double x0, double h, double tol) {
        int n = 6;
        double[] d = new double[n];
        d[0] = (f.evaluate(x0 + h) - f.evaluate(x0 - h)) / h / 2.0;
        int error_code = 1;
        for (int j = 1; j <= n - 1; ++j) {
            d[j] = 0.0;
            double d1 = d[0];
            double h2 = h;
            if ((h *= 0.5) < Util.defaultNumericalPrecision) {
                error_code = 2;
                break;
            }
            d[0] = (f.evaluate(x0 + h) - f.evaluate(x0 - h)) / h2;
            int m = 4;
            int i = 1;
            while (i <= j) {
                double d2 = d[i];
                d[i] = ((double)m * d[i - 1] - d1) / (double)(m - 1);
                d1 = d2;
                ++i;
                m *= 4;
            }
            if (!(Math.abs(d[j] - d[j - 1]) < tol)) continue;
            return d[j];
        }
        throw new NumericMethodException("Derivative did not converge.", error_code, d[0]);
    }

    public static double first(Function f, double x, double h) {
        return (f.evaluate(x + h) - f.evaluate(x - h)) / h / 2.0;
    }

    public static double centered(Function f, double x, double h) {
        return (f.evaluate(x + h) - f.evaluate(x - h)) / h / 2.0;
    }

    public static double backward(Function f, double x, double h) {
        return (f.evaluate(x - 2.0 * h) - 4.0 * f.evaluate(x - h) + 3.0 * f.evaluate(x)) / h / 2.0;
    }

    public static double forward(Function f, double x, double h) {
        return (-f.evaluate(x + 2.0 * h) + 4.0 * f.evaluate(x + h) - 3.0 * f.evaluate(x)) / h / 2.0;
    }

    public static double firstPartial(MultiVarFunction f, double[] x, int n, double h) {
        double[] tempPlus = new double[x.length];
        System.arraycopy(x, 0, tempPlus, 0, x.length);
        int n2 = n;
        tempPlus[n2] = tempPlus[n2] + h;
        double[] tempMinus = new double[x.length];
        System.arraycopy(x, 0, tempMinus, 0, x.length);
        int n3 = n;
        tempMinus[n3] = tempMinus[n3] - h;
        return (f.evaluate(tempPlus) - f.evaluate(tempMinus)) / 2.0 / h;
    }

    public static double second(Function f, double x, double h) {
        return (f.evaluate(x + h) - 2.0 * f.evaluate(x) + f.evaluate(x - h)) / h / h;
    }
}

