/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.text.DecimalFormat;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;

public class DoubleArray {
    public static int NumberFormatError = 1;
    public static int ArrayIndexOutOfBoundsError = 2;
    protected DecimalFormat format = new DecimalFormat("0.00");
    protected DecimalFormat formatExp = new DecimalFormat("0.00#E0");
    protected double[] array;
    protected String defaultString;
    protected double[] defaultArray;
    protected int errorcode = 0;

    public DoubleArray(int n) {
        this.array = new double[n];
        this.defaultArray = this.array;
    }

    public DoubleArray(double[] array) {
        this.defaultArray = (double[])array.clone();
        this.array = this.defaultArray;
    }

    public DoubleArray(String str) throws NumberFormatException {
        this.array = this.toDouble(str);
        this.defaultString = str;
        this.defaultArray = this.array;
    }

    public void setDecimalFormat(String pattern) {
        this.formatExp = this.format = new DecimalFormat(pattern);
    }

    public String getDefault() {
        return this.defaultString;
    }

    public String toString() {
        if (this.errorcode > 0) {
            return this.defaultString;
        }
        String str = "{";
        int n = this.array.length;
        for (int i = 0; i < n; ++i) {
            str = str + (Math.abs(this.array[i]) < 0.1 || Math.abs(this.array[i]) > 1000.0 ? this.formatExp.format(this.array[i]) : this.format.format(this.array[i]));
            if (i >= n - 1) continue;
            str = str + ", ";
        }
        str = str + "}";
        return str;
    }

    public int getError() {
        return this.errorcode;
    }

    public double[] getArray(String str) {
        this.set(str);
        return this.array;
    }

    public double[] getArray() {
        return this.array;
    }

    public boolean set(String str) {
        this.errorcode = 0;
        try {
            this.array = this.toDouble(str);
        }
        catch (NumberFormatException ex) {
            this.errorcode = NumberFormatError;
            this.array = this.toDouble(this.defaultString);
            return false;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.errorcode = ArrayIndexOutOfBoundsError;
            this.array = this.toDouble(this.defaultString);
            return false;
        }
        return true;
    }

    public void setDefaultArray(double[] array) {
        this.defaultArray = (double[])array.clone();
        this.array = this.defaultArray;
    }

    protected double[] toDouble(String str) throws ArrayIndexOutOfBoundsException {
        if (str == null) {
            str = "{}";
        }
        double[] array = null;
        int start = str.indexOf("{") + 1;
        int end = str.indexOf("}");
        if (end - start <= 0) {
            this.errorcode = ArrayIndexOutOfBoundsError;
            return this.defaultArray;
        }
        String[] s = str.substring(start, end).split(",");
        if (this.array != null && this.array.length != s.length) {
            throw new ArrayIndexOutOfBoundsException("Array length cannot be changed in DoubleArray. " + str);
        }
        array = new double[s.length];
        int n = s.length;
        for (int i = 0; i < n; ++i) {
            try {
                array[i] = Double.parseDouble(s[i]);
                continue;
            }
            catch (NumberFormatException ex) {
                this.errorcode = NumberFormatError;
            }
        }
        return array;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            DoubleArray array = (DoubleArray)obj;
            control.setValue("data", array.getArray());
        }

        public Object createObject(XMLControl control) {
            return new DoubleArray((double[])control.getObject("data"));
        }

        public Object loadObject(XMLControl control, Object obj) {
            DoubleArray dataArray = (DoubleArray)obj;
            double[] data = (double[])control.getObject("data");
            dataArray.array = data;
            dataArray.defaultArray = data;
            return obj;
        }
    }
}

