/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.util.ArrayList;
import org.opensourcephysics.numerics.Polynomial;

public class Hermite {
    static final ArrayList hermiteList;
    static final Polynomial twoX;

    private Hermite() {
    }

    public static synchronized Polynomial getPolynomial(int n) {
        if (n < hermiteList.size()) {
            return (Polynomial)hermiteList.get(n);
        }
        Polynomial p1 = Hermite.getPolynomial(n - 1).multiply(twoX);
        Polynomial p2 = Hermite.getPolynomial(n - 2).multiply(2 * (n - 1));
        Polynomial p = p1.subtract(p2);
        hermiteList.add(p);
        return p;
    }

    static {
        twoX = new Polynomial(new double[]{0.0, 2.0});
        hermiteList = new ArrayList();
        Polynomial p = new Polynomial(new double[]{1.0});
        hermiteList.add(p);
        p = new Polynomial(new double[]{0.0, 2.0});
        hermiteList.add(p);
    }
}

