/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Function;

public class LagrangeInterpolator
implements Function {
    protected double[] hornerCoef;
    double[] xd;
    double[] yd;

    public LagrangeInterpolator(double[] xdata, double[] ydata) {
        this.hornerCoef = new double[xdata.length];
        this.xd = xdata;
        this.yd = ydata;
        this.computeCoefficients(xdata, ydata);
    }

    private void computeCoefficients(double[] xd, double[] yd) {
        int i;
        int n = xd.length;
        for (i = 0; i < n; ++i) {
            this.hornerCoef[i] = yd[i];
        }
        --n;
        for (i = 0; i < n; ++i) {
            for (int k = n; k > i; --k) {
                int k1 = k - 1;
                int kn = k - (i + 1);
                this.hornerCoef[k] = (this.hornerCoef[k] - this.hornerCoef[k1]) / (xd[k] - xd[kn]);
            }
        }
    }

    public double evaluate(double x) {
        int n = this.hornerCoef.length;
        double answer = this.hornerCoef[--n];
        while (--n >= 0) {
            answer = answer * (x - this.xd[n]) + this.hornerCoef[n];
        }
        return answer;
    }

    public double[] getCoefficients() {
        int n = this.xd.length;
        double[] temp = new double[n];
        double[] coef = new double[n];
        temp[n - 1] = -this.xd[0];
        for (int i = 1; i < n; ++i) {
            for (int j = n - i - 1; j < n - 1; ++j) {
                int n2 = j;
                temp[n2] = temp[n2] - this.xd[i] * temp[j + 1];
            }
            int n3 = n - 1;
            temp[n3] = temp[n3] - this.xd[i];
        }
        for (int j = 0; j < n; ++j) {
            double a = n;
            for (int k = n - 1; k >= 1; --k) {
                a = (double)k * temp[k] + this.xd[j] * a;
            }
            double b = this.yd[j] / a;
            double c = 1.0;
            for (int k = n - 1; k >= 0; --k) {
                int n4 = k;
                coef[n4] = coef[n4] + c * b;
                c = temp[k] + this.xd[j] * c;
            }
        }
        return coef;
    }
}

