/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

public class PBC {
    private PBC() {
    }

    public static double position(double r, double size) {
        return r < 0.0 ? r % size + size : r % size;
    }

    public static int position(int r, int size) {
        return r < 0 ? (r + 1) % size + size - 1 : r % size;
    }

    public static double separation(double dr, double size) {
        return dr - size * Math.floor(dr / size + 0.5);
    }

    public static int separation(int dr, int size) {
        if (dr < 0) {
            return dr + size * ((-2 * dr + size) / (2 * size));
        }
        return dr - size * ((2 * dr + size - 1) / (2 * size));
    }
}

