/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.AbstractODESolver;
import org.opensourcephysics.numerics.ODE;

public class Verlet
extends AbstractODESolver {
    private double[] rate1;
    private double[] rate2;
    private int rateCounter = -1;

    public Verlet(ODE ode) {
        super(ode);
    }

    public void initialize(double stepSize) {
        super.initialize(stepSize);
        this.rate1 = new double[this.numEqn];
        this.rate2 = new double[this.numEqn];
        this.rateCounter = -1;
    }

    public int getRateCounter() {
        return this.rateCounter;
    }

    public double step() {
        int i;
        double[] state = this.ode.getState();
        if (state.length != this.numEqn) {
            this.initialize(this.stepSize);
        }
        this.rateCounter = 0;
        this.ode.getRate(state, this.rate1);
        double dt2 = this.stepSize * this.stepSize;
        for (i = 0; i < this.numEqn - 1; i += 2) {
            int n = i;
            state[n] = state[n] + (this.stepSize * this.rate1[i] + dt2 * this.rate1[i + 1] / 2.0);
        }
        this.rateCounter = 1;
        this.ode.getRate(state, this.rate2);
        this.rateCounter = 2;
        for (i = 1; i < this.numEqn; i += 2) {
            int n = i;
            state[n] = state[n] + this.stepSize * (this.rate1[i] + this.rate2[i]) / 2.0;
        }
        if (this.numEqn % 2 == 1) {
            int n = this.numEqn - 1;
            state[n] = state[n] + this.stepSize * this.rate1[this.numEqn - 1];
        }
        return this.stepSize;
    }
}

