/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import javax.swing.table.AbstractTableModel;

public class ArrayTableModel
extends AbstractTableModel {
    double[] doubleArray1;
    double[][] doubleArray2;
    int[] intArray1;
    int[][] intArray2;
    String[] stringArray1;
    String[][] stringArray2;
    boolean[] booleanArray1;
    boolean[][] booleanArray2;
    boolean editable = false;

    public ArrayTableModel(int[] array) {
        this.intArray1 = array;
    }

    public ArrayTableModel(int[][] array) {
        this.intArray2 = array;
    }

    public ArrayTableModel(double[] array) {
        this.doubleArray1 = array;
    }

    public ArrayTableModel(double[][] array) {
        this.doubleArray2 = array;
    }

    public ArrayTableModel(String[] array) {
        this.stringArray1 = array;
    }

    public ArrayTableModel(String[][] array) {
        this.stringArray2 = array;
    }

    public ArrayTableModel(boolean[] array) {
        this.booleanArray1 = array;
    }

    public ArrayTableModel(boolean[][] array) {
        this.booleanArray2 = array;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public int getColumnCount() {
        if (this.getRowCount() == 0) {
            return 0;
        }
        if (this.intArray1 != null || this.doubleArray1 != null || this.stringArray1 != null || this.booleanArray1 != null) {
            return 2;
        }
        if (this.intArray2 != null) {
            return this.intArray2[0].length + 1;
        }
        if (this.doubleArray2 != null) {
            return this.doubleArray2[0].length + 1;
        }
        if (this.stringArray2 != null) {
            return this.stringArray2[0].length + 1;
        }
        if (this.booleanArray2 != null) {
            return this.booleanArray2[0].length + 1;
        }
        return 0;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "";
        }
        if (this.intArray1 != null || this.doubleArray1 != null || this.stringArray1 != null || this.booleanArray1 != null) {
            return "value";
        }
        return "" + (column - 1);
    }

    public int getRowCount() {
        if (this.intArray1 != null) {
            return this.intArray1.length;
        }
        if (this.intArray2 != null) {
            return this.intArray2.length;
        }
        if (this.doubleArray1 != null) {
            return this.doubleArray1.length;
        }
        if (this.doubleArray2 != null) {
            return this.doubleArray2.length;
        }
        if (this.stringArray1 != null) {
            return this.stringArray1.length;
        }
        if (this.stringArray2 != null) {
            return this.stringArray2.length;
        }
        if (this.booleanArray1 != null) {
            return this.booleanArray1.length;
        }
        if (this.booleanArray2 != null) {
            return this.booleanArray2.length;
        }
        return 0;
    }

    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return new Integer(row);
        }
        if (this.intArray1 != null) {
            return new Integer(this.intArray1[row]);
        }
        if (this.intArray2 != null) {
            return new Integer(this.intArray2[row][column - 1]);
        }
        if (this.doubleArray1 != null) {
            return new Double(this.doubleArray1[row]);
        }
        if (this.doubleArray2 != null) {
            return new Double(this.doubleArray2[row][column - 1]);
        }
        if (this.stringArray1 != null) {
            return this.stringArray1[row];
        }
        if (this.stringArray2 != null) {
            return this.stringArray2[row][column - 1];
        }
        if (this.booleanArray1 != null) {
            return new Boolean(this.booleanArray1[row]);
        }
        if (this.booleanArray2 != null) {
            return new Boolean(this.booleanArray2[row][column - 1]);
        }
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        return this.editable && col > 0;
    }

    public void setValueAt(Object value, int row, int col) {
        if (value instanceof String) {
            String val = (String)value;
            if (this.intArray1 != null) {
                try {
                    this.intArray1[row] = Integer.parseInt(val);
                }
                catch (NumberFormatException ex) {}
            } else if (this.intArray2 != null) {
                try {
                    this.intArray2[row][col - 1] = Integer.parseInt(val);
                }
                catch (NumberFormatException ex) {}
            } else if (this.doubleArray1 != null) {
                try {
                    this.doubleArray1[row] = Double.parseDouble(val);
                }
                catch (NumberFormatException ex) {}
            } else if (this.doubleArray2 != null) {
                try {
                    this.doubleArray2[row][col - 1] = Double.parseDouble(val);
                }
                catch (NumberFormatException ex) {}
            } else if (this.stringArray1 != null) {
                this.stringArray1[row] = val;
            } else if (this.stringArray2 != null) {
                this.stringArray2[row][col - 1] = val;
            } else if (this.booleanArray1 != null) {
                this.booleanArray1[row] = val.toLowerCase().startsWith("t");
            } else if (this.booleanArray2 != null) {
                this.booleanArray2[row][col - 1] = val.toLowerCase().startsWith("t");
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

