/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.AbstractSpinnerModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.FunctionDrawer;
import org.opensourcephysics.numerics.PolynomialLeastSquareFit;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.ToolsRes;

public class DatasetCurveFitter
extends JPanel {
    Dataset dataset;
    KnownFunction fit;
    FunctionDrawer drawer;
    Color color = Color.red;
    JCheckBox autofitCheckBox;
    String[] fitNames;
    JComboBox fitDropDown;
    JTextField equation;
    JToolBar toolbar = new JToolBar();
    JTable paramTable;
    TableCellRenderer cellRenderer;
    SpinCellEditor spinCellEditor;
    Map namedFits = new HashMap();

    public DatasetCurveFitter(Dataset data) {
        this.createGUI();
        this.setData(data);
    }

    public Drawable getDrawer() {
        return this.drawer;
    }

    public Dataset getData() {
        return this.dataset;
    }

    public void setData(Dataset data) {
        this.dataset = data;
        this.fit();
    }

    public void setColor(Color newColor) {
        this.color = newColor;
        if (this.drawer != null) {
            this.drawer.setColor(newColor);
        }
    }

    public void fit() {
        if (this.drawer == null) {
            this.createFit();
        }
        if (this.autofitCheckBox.isSelected()) {
            if (this.fit instanceof KnownPolynomial) {
                KnownPolynomial poly = (KnownPolynomial)this.fit;
                poly.fitData(this.dataset.getValidXPoints(), this.dataset.getValidYPoints());
            }
            this.drawer.functionChanged = true;
            this.paramTable.repaint();
        }
        this.firePropertyChange("fit", null, null);
    }

    protected void createGUI() {
        this.setLayout(new BorderLayout());
        this.autofitCheckBox = new JCheckBox(ToolsRes.getString("Checkbox.Autofit.Label"), true);
        this.autofitCheckBox.setOpaque(false);
        this.autofitCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DatasetCurveFitter.this.fit();
            }
        });
        this.fitNames = new String[]{ToolsRes.getString("Function.Poly1.Name"), ToolsRes.getString("Function.Poly2.Name"), ToolsRes.getString("Function.Poly.Name") + " 3", ToolsRes.getString("Function.Poly.Name") + " 4"};
        this.fitDropDown = new JComboBox<String>(this.fitNames);
        this.fitDropDown.setMaximumSize(this.fitDropDown.getMinimumSize());
        this.fitDropDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DatasetCurveFitter.this.createFit();
            }
        });
        this.equation = new JTextField();
        this.equation.setEditable(false);
        this.equation.setEnabled(true);
        this.equation.setBackground(Color.white);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.add((Component)this.toolbar, "North");
        this.cellRenderer = new ParamCellRenderer();
        this.spinCellEditor = new SpinCellEditor();
        this.paramTable = new ParamTable(new ParamTableModel());
        this.paramTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (DatasetCurveFitter.this.paramTable.getSelectedColumn() == 0) {
                    DatasetCurveFitter.this.paramTable.clearSelection();
                }
            }
        });
        this.add((Component)new JScrollPane(this.paramTable), "Center");
    }

    protected void createFit() {
        String name = (String)this.fitDropDown.getSelectedItem();
        this.fit = (KnownFunction)this.namedFits.get(name);
        if (this.fit == null) {
            for (int i = 0; i < this.fitNames.length; ++i) {
                if (!this.fitNames[i].equals(name)) continue;
                switch (i) {
                    case 1: {
                        this.fit = new KnownPolynomial(new double[]{0.0, 0.0, 0.0});
                        break;
                    }
                    case 2: {
                        this.fit = new KnownPolynomial(new double[]{0.0, 0.0, 0.0, 0.0});
                        break;
                    }
                    case 3: {
                        this.fit = new KnownPolynomial(new double[]{0.0, 0.0, 0.0, 0.0, 0.0});
                        break;
                    }
                    default: {
                        this.fit = new KnownPolynomial(new double[]{0.0, 0.0});
                    }
                }
                this.namedFits.put(name, this.fit);
            }
        }
        this.toolbar.removeAll();
        this.toolbar.add(this.fitDropDown);
        this.toolbar.addSeparator();
        this.toolbar.add(this.equation);
        this.toolbar.add(this.autofitCheckBox);
        FunctionDrawer prev = this.drawer;
        this.drawer = new FunctionDrawer(this.fit);
        this.drawer.setColor(this.color);
        this.paramTable.tableChanged(null);
        String depVar = this.dataset.getColumnName(1);
        String indepVar = this.dataset.getColumnName(0);
        this.equation.setText(depVar + " = " + this.fit.getEquation(indepVar));
        this.firePropertyChange("drawer", prev, this.drawer);
        this.fit();
    }

    class NumberField
    extends JTextField {
        protected NumberFormat format = NumberFormat.getInstance();
        protected double prevValue;

        public NumberField(int columns) {
            super(columns);
            if (this.format instanceof DecimalFormat) {
                ((DecimalFormat)this.format).applyPattern("0.000E0");
            }
            this.setForeground(Color.black);
        }

        public double getValue() {
            double retValue;
            if (this.getText().equals(this.format.format(this.prevValue))) {
                return this.prevValue;
            }
            try {
                retValue = this.format.parse(this.getText()).doubleValue();
            }
            catch (ParseException e) {
                Toolkit.getDefaultToolkit().beep();
                this.setValue(this.prevValue);
                return this.prevValue;
            }
            return retValue;
        }

        public void setValue(double value) {
            if (!this.isVisible()) {
                return;
            }
            this.setText(this.format.format(value));
            this.prevValue = value;
        }
    }

    class KnownPolynomial
    extends PolynomialLeastSquareFit
    implements KnownFunction {
        String[] names = new String[]{"a", "b", "c", "d", "e", "f"};

        KnownPolynomial(double[] xdata, double[] ydata, int degree) {
            super(xdata, ydata, degree);
        }

        KnownPolynomial(double[] coeffs) {
            super(coeffs);
        }

        public int getParameterCount() {
            return this.coefficients.length;
        }

        public String getParameterName(int i) {
            return this.names[i];
        }

        public double getParameterValue(int i) {
            return this.coefficients[this.coefficients.length - i - 1];
        }

        public void setParameterValue(int i, double value) {
            this.coefficients[this.coefficients.length - i - 1] = value;
        }

        public String getEquation(String indepVarName) {
            StringBuffer eqn = new StringBuffer();
            int end = this.coefficients.length - 1;
            for (int i = 0; i <= end; ++i) {
                eqn.append(this.getParameterName(i));
                if (end - i <= 0) continue;
                eqn.append("*");
                eqn.append(indepVarName);
                if (end - i > 1) {
                    eqn.append("^");
                    eqn.append(end - i);
                }
                eqn.append(" + ");
            }
            return eqn.toString();
        }
    }

    class SpinnerNumberCrawlerModel
    extends AbstractSpinnerModel {
        double val = 0.0;
        double delta;
        double percentDelta = 10.0;

        public SpinnerNumberCrawlerModel(double initialDelta) {
            this.delta = initialDelta;
        }

        public Object getValue() {
            return new Double(this.val);
        }

        public Object getNextValue() {
            return new Double(this.val + this.delta);
        }

        public Object getPreviousValue() {
            return new Double(this.val - this.delta);
        }

        public void setValue(Object value) {
            if (value != null) {
                this.val = (Double)value;
                this.fireStateChanged();
            }
        }

        public void setPercentDelta(double percent) {
            this.percentDelta = percent;
        }

        public double getPercentDelta() {
            return this.percentDelta;
        }

        public void refreshDelta() {
            if (this.val != 0.0) {
                this.delta = Math.abs(this.val * this.percentDelta / 100.0);
            }
        }
    }

    class SpinCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JPanel panel = new JPanel(new BorderLayout());
        SpinnerNumberCrawlerModel crawlerModel = new SpinnerNumberCrawlerModel(1.0);
        JSpinner spinner;
        NumberField field;
        int index;

        SpinCellEditor() {
            this.panel.setOpaque(false);
            this.spinner = new JSpinner(this.crawlerModel);
            this.spinner.setToolTipText(ToolsRes.getString("Table.Spinner.ToolTip"));
            this.spinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.autofitCheckBox.setSelected(false);
                    double val = (Double)SpinCellEditor.this.spinner.getValue();
                    SpinCellEditor.this.field.setValue(val);
                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit.setParameterValue(SpinCellEditor.this.index, val);
                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.drawer.functionChanged = true;
                    DatasetCurveFitter.this.firePropertyChange("fit", null, null);
                }
            });
            this.field = new NumberField(10);
            this.spinner.setEditor(this.field);
            this.field.addMouseListener(new MouseInputAdapter(){

                public void mousePressed(MouseEvent e) {
                    int mask = 4096;
                    if (e.isPopupTrigger() || (((InputEvent)e).getModifiersEx() & mask) == mask || e.isControlDown()) {
                        JPopupMenu popup = new JPopupMenu();
                        ActionListener listener = new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                double percent = Double.parseDouble(e.getActionCommand());
                                (this).SpinCellEditor.this.crawlerModel.setPercentDelta(percent);
                                (this).SpinCellEditor.this.crawlerModel.refreshDelta();
                            }
                        };
                        ButtonGroup buttonGroup = new ButtonGroup();
                        JMenu choices = new JMenu(ToolsRes.getString("Menu.StepSize"));
                        popup.add(choices);
                        double percent = 10.0;
                        for (int i = 0; i < 3; ++i) {
                            String val = String.valueOf(percent);
                            JRadioButtonMenuItem item = new JRadioButtonMenuItem(val + "%");
                            item.setActionCommand(val);
                            item.addActionListener(listener);
                            choices.add(item);
                            buttonGroup.add(item);
                            if (percent == SpinCellEditor.this.crawlerModel.getPercentDelta()) {
                                item.setSelected(true);
                            }
                            percent /= 10.0;
                        }
                        popup.show(SpinCellEditor.this.field, e.getX(), e.getY());
                    }
                }
            });
            this.field.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    JComponent comp = (JComponent)e.getSource();
                    if (e.getKeyCode() == 10) {
                        SpinCellEditor.this.spinner.setValue(new Double(SpinCellEditor.this.field.getValue()));
                        comp.setBackground(Color.white);
                        SpinCellEditor.this.crawlerModel.refreshDelta();
                    } else {
                        comp.setBackground(Color.yellow);
                    }
                }
            });
            this.panel.add((Component)this.spinner, "Center");
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.spinner.setValue(value);
            this.crawlerModel.refreshDelta();
            return this.panel;
        }

        public boolean isCellEditable(EventObject e) {
            MouseEvent me;
            return e instanceof MouseEvent ? (me = (MouseEvent)e).getClickCount() == 2 : e instanceof ActionEvent;
        }

        public Object getCellEditorValue() {
            if (this.field.getBackground() == Color.yellow) {
                DatasetCurveFitter.this.fit.setParameterValue(this.index, this.field.getValue());
                DatasetCurveFitter.this.drawer.functionChanged = true;
                DatasetCurveFitter.this.firePropertyChange("fit", null, null);
                this.field.setBackground(Color.white);
            }
            return null;
        }
    }

    class ParamCellRenderer
    extends JLabel
    implements TableCellRenderer {
        Color lightBlue = new Color(204, 204, 255);
        Color lightGray = UIManager.getColor("Panel.background");
        Font labelFont = this.getFont();
        Font fieldFont = new JTextField().getFont();

        public ParamCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 2));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setHorizontalAlignment(col == 0 ? 4 : 2);
            if (value instanceof String) {
                this.setFont(this.labelFont);
                this.setBackground(this.lightGray);
                this.setForeground(Color.black);
                this.setText(value.toString());
            } else {
                this.setFont(this.fieldFont);
                this.setBackground(isSelected ? this.lightBlue : Color.white);
                this.setForeground(isSelected ? Color.red : Color.black);
                NumberFormat format = DatasetCurveFitter.this.spinCellEditor.field.format;
                this.setText(format.format(value));
            }
            return this;
        }
    }

    class ParamTableModel
    extends AbstractTableModel {
        ParamTableModel() {
        }

        public String getColumnName(int col) {
            return col == 0 ? ToolsRes.getString("Table.Heading.Parameter") : ToolsRes.getString("Table.Heading.Value");
        }

        public int getRowCount() {
            return DatasetCurveFitter.this.fit == null ? 0 : DatasetCurveFitter.this.fit.getParameterCount();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return DatasetCurveFitter.this.fit.getParameterName(row);
            }
            return new Double(DatasetCurveFitter.this.fit.getParameterValue(row));
        }

        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class ParamTable
    extends JTable {
        public ParamTable(ParamTableModel model) {
            super(model);
            this.setPreferredScrollableViewportSize(new Dimension(60, 50));
            this.setGridColor(Color.blue);
            JTableHeader header = this.getTableHeader();
            header.setForeground(Color.blue);
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            return DatasetCurveFitter.this.cellRenderer;
        }

        public TableCellEditor getCellEditor(int row, int column) {
            DatasetCurveFitter.this.spinCellEditor.index = row;
            return DatasetCurveFitter.this.spinCellEditor;
        }
    }
}

