/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.HighlightableDataset;

public class DatasetDataTable
extends DataTable {
    final HighlightableDataset dataset;
    HighlightableDataset data = new HighlightableDataset();
    HighlightableDataset workingData = new HighlightableDataset();

    public DatasetDataTable(HighlightableDataset dataset) {
        this.dataset = dataset;
        this.add(dataset);
        this.setRowNumberVisible(true);
        this.setSelectionMode(2);
    }

    protected HighlightableDataset getData() {
        this.data.clear();
        if (this.isXYColumnsReversed()) {
            this.data.append(this.dataset.getYPoints(), this.dataset.getXPoints());
            this.data.setXYColumnNames(this.dataset.getColumnName(1), this.dataset.getColumnName(0));
        } else {
            this.data.append(this.dataset.getXPoints(), this.dataset.getYPoints());
            this.data.setXYColumnNames(this.dataset.getColumnName(0), this.dataset.getColumnName(1));
        }
        this.data.setMarkerShape(this.dataset.getMarkerShape());
        this.data.setMarkerSize(this.dataset.getMarkerSize());
        this.data.setConnected(this.dataset.isConnected());
        this.data.setLineColor(this.dataset.getLineColor());
        this.data.setName(this.dataset.getName());
        this.data.setMarkerColor(this.dataset.getFillColor(), this.dataset.getEdgeColor());
        for (int i = 0; i < this.dataset.getRowCount(); ++i) {
            this.data.setHighlighted(i, this.dataset.isHighlighted(i));
        }
        return this.data;
    }

    protected HighlightableDataset getWorkingData() {
        double[] yValues;
        double[] xValues;
        double[] x = this.dataset.getXPoints();
        double[] y = this.dataset.getYPoints();
        this.dataset.clearHighlights();
        this.data.clearHighlights();
        if (this.getSelectedRowCount() == 0) {
            xValues = x;
            yValues = y;
        } else {
            int[] rows = this.getSelectedRows();
            xValues = new double[rows.length];
            yValues = new double[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                xValues[i] = x[rows[i]];
                yValues[i] = y[rows[i]];
                this.dataset.setHighlighted(rows[i], true);
                this.data.setHighlighted(rows[i], true);
            }
        }
        this.workingData.clear();
        if (this.isXYColumnsReversed()) {
            this.workingData.append(yValues, xValues);
            this.workingData.setXYColumnNames(this.dataset.getColumnName(1), this.dataset.getColumnName(0));
        } else {
            this.workingData.append(xValues, yValues);
            this.workingData.setXYColumnNames(this.dataset.getColumnName(0), this.dataset.getColumnName(1));
        }
        this.workingData.setMarkerShape(this.dataset.getMarkerShape());
        this.workingData.setMarkerSize(this.dataset.getMarkerSize());
        this.workingData.setConnected(this.dataset.isConnected());
        this.workingData.setLineColor(this.dataset.getLineColor());
        this.workingData.setName(this.dataset.getName());
        this.workingData.setMarkerColor(this.dataset.getFillColor(), this.dataset.getEdgeColor());
        return this.workingData;
    }

    protected boolean isXYColumnsReversed() {
        int i = this.isRowNumberVisible() ? 1 : 0;
        return this.convertColumnIndexToView(i) > this.convertColumnIndexToView(i + 1);
    }

    public void clearSelection() {
        if (this.dataset != null) {
            this.dataset.clearHighlights();
            this.data.clearHighlights();
        }
        super.clearSelection();
    }
}

