/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.tools.DatasetDataTable;
import org.opensourcephysics.tools.ToolsRes;

public class DatasetStatisticsTable
extends JTable {
    DatasetDataTable dataTable;
    StatisticsTableModel tableModel;
    LabelRenderer labelRenderer;
    protected Object[][] statsData;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    public DatasetStatisticsTable(DatasetDataTable table) {
        this.dataTable = table;
        this.tableModel = new StatisticsTableModel();
        this.init();
    }

    protected void init() {
        this.dataTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent e) {
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            public void columnMarginChanged(ChangeEvent e) {
                DatasetStatisticsTable.this.refreshTable();
            }

            public void columnMoved(TableColumnModelEvent e) {
                DatasetStatisticsTable.this.refreshTable();
            }
        });
        HighlightableDataset workingData = this.dataTable.getWorkingData();
        double[] xstats = this.getStatistics(workingData.getXPoints());
        double[] ystats = this.getStatistics(workingData.getValidYPoints());
        if (this.statsData == null) {
            this.statsData = new Object[xstats.length][0];
        }
        for (int i = 0; i < xstats.length; ++i) {
            String label = ToolsRes.getString("Table.Entry.Count");
            if (i == 5) {
                this.statsData[i] = new Object[]{label, new Integer((int)xstats[i]), new Integer((int)ystats[i])};
                continue;
            }
            switch (i) {
                case 0: {
                    label = ToolsRes.getString("Table.Entry.Max");
                    break;
                }
                case 1: {
                    label = ToolsRes.getString("Table.Entry.Min");
                    break;
                }
                case 2: {
                    label = ToolsRes.getString("Table.Entry.Mean");
                    break;
                }
                case 3: {
                    label = ToolsRes.getString("Table.Entry.StandardDev");
                    break;
                }
                case 4: {
                    label = ToolsRes.getString("Table.Entry.StandardError");
                }
            }
            this.statsData[i] = new Object[]{label, new Double(xstats[i]), new Double(ystats[i])};
        }
        this.setModel(this.tableModel);
        this.setGridColor(Color.blue);
        this.setEnabled(false);
        this.setTableHeader(null);
        this.labelRenderer = new LabelRenderer();
        this.setAutoResizeMode(0);
        this.setDefaultRenderer(class$java$lang$Double == null ? (class$java$lang$Double = DatasetStatisticsTable.class$("java.lang.Double")) : class$java$lang$Double, new ScientificRenderer(3));
        ListSelectionModel selectionModel = this.dataTable.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int i;
                HighlightableDataset workingData = DatasetStatisticsTable.this.dataTable.getWorkingData();
                double[] xstats = DatasetStatisticsTable.this.getStatistics(workingData.getXPoints());
                double[] ystats = DatasetStatisticsTable.this.getStatistics(workingData.getValidYPoints());
                for (i = 0; i < xstats.length - 1; ++i) {
                    DatasetStatisticsTable.this.statsData[i][1] = new Double(xstats[i]);
                    DatasetStatisticsTable.this.statsData[i][2] = new Double(ystats[i]);
                }
                DatasetStatisticsTable.this.statsData[i][1] = new Integer((int)xstats[i]);
                DatasetStatisticsTable.this.statsData[i][2] = new Integer((int)ystats[i]);
                DatasetStatisticsTable.this.refreshTable();
            }
        });
        this.refreshCellWidths();
    }

    public void getXStatistics() {
    }

    private double[] getStatistics(double[] data) {
        double sd;
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        double sum = 0.0;
        double squareSum = 0.0;
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i])) continue;
            ++count;
            max = Math.max(max, data[i]);
            min = Math.min(min, data[i]);
            sum += data[i];
            squareSum += data[i] * data[i];
        }
        double mean = sum / (double)count;
        double d = sd = count < 2 ? Double.NaN : Math.sqrt((squareSum - (double)count * mean * mean) / (double)(count - 1));
        if (max == -1.7976931348623157E308) {
            max = Double.NaN;
        }
        if (min == Double.MAX_VALUE) {
            min = Double.NaN;
        }
        return new double[]{max, min, mean, sd, sd / Math.sqrt(count), count};
    }

    public void refreshTable() {
        Runnable refresh = new Runnable(){

            public synchronized void run() {
                DatasetStatisticsTable.this.tableChanged(new TableModelEvent(DatasetStatisticsTable.this.tableModel, -1));
                DatasetStatisticsTable.this.refreshCellWidths();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            refresh.run();
        } else {
            SwingUtilities.invokeLater(refresh);
        }
    }

    public void refreshCellWidths() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            String name = this.getColumnName(i);
            TableColumn statColumn = this.getColumn(name);
            name = this.dataTable.getColumnName(i);
            TableColumn dataColumn = this.dataTable.getColumn(name);
            statColumn.setMaxWidth(dataColumn.getWidth());
            statColumn.setMinWidth(dataColumn.getWidth());
            statColumn.setWidth(dataColumn.getWidth());
        }
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        int i = this.dataTable.convertColumnIndexToModel(column);
        if (i == 0) {
            return this.labelRenderer;
        }
        return this.getDefaultRenderer(this.tableModel.getValueAt(row, column).getClass());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ScientificRenderer
    extends JLabel
    implements TableCellRenderer {
        NumberFormat format = NumberFormat.getInstance();

        public ScientificRenderer(int sigfigs) {
            sigfigs = Math.min(sigfigs, 6);
            if (this.format instanceof DecimalFormat) {
                String pattern = "0.0";
                for (int i = 0; i < sigfigs - 1; ++i) {
                    pattern = pattern + "0";
                }
                pattern = pattern + "E0";
                ((DecimalFormat)this.format).applyPattern(pattern);
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(DatasetStatisticsTable.this.getDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = DatasetStatisticsTable.class$("java.lang.String")) : class$java$lang$String).getTableCellRendererComponent(DatasetStatisticsTable.this, "a", false, false, 0, 0).getFont());
            this.setText(this.format.format(value));
            this.setHorizontalAlignment(11);
            return this;
        }
    }

    static class LabelRenderer
    extends JLabel
    implements TableCellRenderer {
        public LabelRenderer() {
            this.setHorizontalAlignment(4);
            this.setOpaque(true);
            this.setForeground(Color.black);
            this.setBackground(UIManager.getColor("Panel.background"));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value.toString());
            return this;
        }
    }

    class StatisticsTableModel
    extends AbstractTableModel {
        StatisticsTableModel() {
        }

        public String getColumnName(int col) {
            return DatasetStatisticsTable.this.dataTable.getColumnName(col);
        }

        public int getRowCount() {
            return DatasetStatisticsTable.this.statsData.length;
        }

        public int getColumnCount() {
            return DatasetStatisticsTable.this.dataTable.getColumnCount();
        }

        public Object getValueAt(int row, int col) {
            int i = DatasetStatisticsTable.this.dataTable.convertColumnIndexToModel(col);
            return DatasetStatisticsTable.this.statsData[row][i];
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

